/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.common.provisional;

import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OSGIStarter {
    protected static Logger logger = Logger.getLogger(OSGIStarter.class.getName());
    protected static final String ECLIPSESTARTERCLASS = "org.eclipse.core.runtime.adaptor.EclipseStarter";
    protected File platformDirectory;
    protected ClassLoader frameworkClassLoader;
    protected ClassLoader frameworkContextClassLoader;
    protected Object bundleContext;

    public static final void setProperty(String name, String value) {
        System.setProperty(name, value);
    }

    public void startup(String root, String[] args) throws Exception {
        this.platformDirectory = new File(root);
        if (!this.platformDirectory.exists() || !this.platformDirectory.isDirectory()) {
            throw new Exception("Could not start the Framework - {0}" + root);
        }
        if (this.frameworkClassLoader != null) {
            logger.log(Level.WARNING, "Framework is already started");
            return;
        }
        OSGIStarter.setProperty("osgi.parentClassloader", "fwk");
        OSGIStarter.setProperty("osgi.install.area", this.platformDirectory.getAbsolutePath());
        File configurationDirectory = new File(this.platformDirectory, "configuration");
        if (!configurationDirectory.exists()) {
            configurationDirectory.mkdirs();
        }
        OSGIStarter.setProperty("osgi.configuration.area", configurationDirectory.getAbsolutePath());
        File workspaceDirectory = new File(this.platformDirectory, "workspace");
        if (!workspaceDirectory.exists()) {
            workspaceDirectory.mkdirs();
        }
        OSGIStarter.setProperty("osgi.instance.area", workspaceDirectory.getAbsolutePath());
        OSGIStarter.setProperty("eclipse.ignoreApp", "true");
        OSGIStarter.setProperty("osgi.noShutdown", "true");
        String path = new File(this.platformDirectory, "plugins").toString();
        path = this.searchFor("org.eclipse.osgi", path);
        if (path == null) {
            throw new Exception("Could not find the Framework - {0}");
        }
        String framework = new File(path).getAbsolutePath();
        if (args == null) {
            args = new String[]{"-clean"};
        }
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            try {
                URL frameworkUrl = new File(framework).toURL();
                OSGIStarter.setProperty("osgi.framework", frameworkUrl.toExternalForm());
                ClassLoader loader = this.getClass().getClassLoader();
                this.frameworkClassLoader = new URLClassLoader(new URL[]{frameworkUrl}, loader);
                Class<?> clazz = this.frameworkClassLoader.loadClass(ECLIPSESTARTERCLASS);
                OSGIStarter.setProperty("osgi.framework.useSystemProperties", "true");
                Method runMethod = clazz.getMethod("startup", String[].class, Runnable.class);
                Object[] objectArray = new Object[2];
                objectArray[0] = args;
                this.bundleContext = runMethod.invoke(null, objectArray);
                this.frameworkContextClassLoader = Thread.currentThread().getContextClassLoader();
            }
            catch (Exception e) {
                e.printStackTrace();
                Thread.currentThread().setContextClassLoader(original);
                return;
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    public ClassLoader getFrameworkContextClassLoader() {
        return this.frameworkContextClassLoader;
    }

    public void shutdown() {
        if (this.platformDirectory == null) {
            logger.log(Level.WARNING, "Shutdown unnecessary. (not deployed)");
            return;
        }
        if (this.frameworkClassLoader == null) {
            logger.log(Level.WARNING, "Framework is already shutdown");
            return;
        }
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Class<?> clazz = this.frameworkClassLoader.loadClass(ECLIPSESTARTERCLASS);
                Method method = clazz.getDeclaredMethod("shutdown", null);
                Thread.currentThread().setContextClassLoader(this.frameworkContextClassLoader);
                method.invoke(clazz, null);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Error while stopping Framework", e);
                this.frameworkClassLoader = null;
                this.frameworkContextClassLoader = null;
                Thread.currentThread().setContextClassLoader(original);
                return;
            }
        }
        finally {
            this.frameworkClassLoader = null;
            this.frameworkContextClassLoader = null;
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    protected String searchFor(final String target, String start) {
        FileFilter filter = new FileFilter(){

            public boolean accept(File candidate) {
                return candidate.getName().equals(target) || candidate.getName().startsWith(String.valueOf(target) + "_");
            }
        };
        File[] candidates = new File(start).listFiles(filter);
        if (candidates == null) {
            return null;
        }
        String[] arrays = new String[candidates.length];
        int i = 0;
        while (i < arrays.length) {
            arrays[i] = candidates[i].getName();
            ++i;
        }
        int result = this.findMax(arrays);
        if (result == -1) {
            return null;
        }
        return String.valueOf(candidates[result].getAbsolutePath().replace(File.separatorChar, '/')) + (candidates[result].isDirectory() ? "/" : "");
    }

    protected int findMax(String[] candidates) {
        int result = -1;
        Object[] maxVersion = null;
        int i = 0;
        while (i < candidates.length) {
            String name = candidates[i];
            String version = "";
            int index = name.indexOf(95);
            if (index != -1) {
                version = name.substring(index + 1);
            }
            Object[] currentVersion = this.getVersionElements(version);
            if (maxVersion == null) {
                result = i;
                maxVersion = currentVersion;
            } else if (this.compareVersion(maxVersion, currentVersion) < 0) {
                result = i;
                maxVersion = currentVersion;
            }
            ++i;
        }
        return result;
    }

    protected int compareVersion(Object[] left, Object[] right) {
        int result = ((Integer)left[0]).compareTo((Integer)right[0]);
        if (result != 0) {
            return result;
        }
        result = ((Integer)left[1]).compareTo((Integer)right[1]);
        if (result != 0) {
            return result;
        }
        result = ((Integer)left[2]).compareTo((Integer)right[2]);
        if (result != 0) {
            return result;
        }
        return ((String)left[3]).compareTo((String)right[3]);
    }

    protected Object[] getVersionElements(String version) {
        if (version.endsWith(".jar")) {
            version = version.substring(0, version.length() - 4);
        }
        Object[] result = new Object[]{new Integer(0), new Integer(0), new Integer(0), ""};
        StringTokenizer t = new StringTokenizer(version, ".");
        int i = 0;
        while (t.hasMoreTokens() && i < 4) {
            String token = t.nextToken();
            if (i < 3) {
                try {
                    result[i++] = new Integer(token);
                    continue;
                }
                catch (Exception exception) {
                    break;
                }
            }
            result[i++] = token;
        }
        return result;
    }

    Object getBundle(String symbolicName) {
        if (this.bundleContext == null) {
            return null;
        }
        try {
            Method methodLoadBundle = this.bundleContext.getClass().getMethod("getBundles", new Class[0]);
            Object objects = methodLoadBundle.invoke(this.bundleContext, new Object[0]);
            if (objects instanceof Object[]) {
                Object[] bundles = (Object[])objects;
                int i = 0;
                while (i < bundles.length) {
                    Object bundle = bundles[i];
                    Method methodGetSymbolicName = bundle.getClass().getMethod("getSymbolicName", new Class[0]);
                    Object name = methodGetSymbolicName.invoke(bundle, new Object[0]);
                    if (symbolicName.equals(name)) {
                        return bundle;
                    }
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }
}

