/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.iac.administrator.internal.common;

import java.io.File;
import java.io.FileFilter;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.tptp.platform.agentcontroller.config.FileFilterImpl;
import org.eclipse.tptp.platform.agentcontroller.config.IConfigUtility;
import org.eclipse.tptp.platform.iac.administrator.AdminPlugin;
import org.osgi.framework.Bundle;

public class IACConfigUtil
implements IConfigUtility {
    public String resolveAbsolutePath(String directory, String pluginAlias) {
        File f;
        block7: {
            try {
                Bundle bundle = Platform.getBundle((String)pluginAlias);
                f = FileLocator.getBundleFile((Bundle)bundle);
                if (f != null) break block7;
                return "null";
            }
            catch (Exception exception) {}
        }
        if (f.exists() && !f.isDirectory()) {
            if ("org.eclipse.swt".equalsIgnoreCase(pluginAlias)) {
                return this.AddAllSWTJars(f);
            }
            return f.getAbsolutePath();
        }
        if (f.isDirectory()) {
            return this.locateBundleJarFile(f.getCanonicalPath());
        }
        if (!f.exists()) {
            return "null";
        }
        return "null";
    }

    private String locateBundleJarFile(String bundleLocation) {
        StringBuffer classpathBuffer = new StringBuffer();
        FileFilter filter = new FileFilter(){

            public boolean accept(File file) {
                return file.getName().endsWith(".zip") || file.getName().endsWith(".jar");
            }
        };
        File pluginDir = new File(bundleLocation);
        File[] jars = pluginDir.listFiles(filter);
        int i = 0;
        while (i < jars.length) {
            classpathBuffer.append(String.valueOf(jars[i].getAbsolutePath()) + File.pathSeparator);
            ++i;
        }
        String classpath = classpathBuffer.toString();
        if (classpath.length() > 1) {
            return classpath.substring(0, classpath.length() - 1);
        }
        return new String("null");
    }

    private String AddAllSWTJars(File swtJar) {
        StringBuffer path = new StringBuffer();
        if (swtJar == null) {
            return "null";
        }
        File dir = swtJar.getParentFile();
        File[] jars = dir.listFiles((FileFilter)new FileFilterImpl("^org.eclipse.swt.*"));
        int i = 0;
        while (i < jars.length) {
            path.append(String.valueOf(jars[i].getAbsolutePath()) + File.pathSeparator);
            ++i;
        }
        String classpath = path.toString();
        if (classpath.length() > 1) {
            return classpath.substring(0, classpath.length() - 1);
        }
        return new String("null");
    }

    public File getACConfigDirectory(String home, boolean isInvokedByWorkbench, boolean isIacConfig) {
        IPath path = Platform.getStateLocation((Bundle)AdminPlugin.getDefault().getBundle());
        File dir = new File(String.valueOf(path.toString()) + File.separator + "config");
        dir.mkdirs();
        return dir;
    }

    public File getPluginPropertyDirectory(boolean isInvokedByWorkbench) {
        String result = "";
        if (isInvokedByWorkbench) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot root = workspace.getRoot();
            IPath location = root.getLocation();
            result = String.valueOf(location.toString()) + File.separator + ".metadata" + File.separator + ".plugins";
        }
        return new File(result);
    }
}

