/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.iac.administrator.internal.config;

import java.io.File;
import org.eclipse.tptp.platform.agentcontroller.config.IConfigUtility;
import org.eclipse.tptp.platform.agentcontroller.config.SetConfig;
import org.eclipse.tptp.platform.iac.administrator.internal.common.AdminUtil;
import org.eclipse.tptp.platform.iac.administrator.internal.common.IACConfigUtil;
import org.eclipse.tptp.platform.iac.administrator.internal.preference.PreferenceMessages;

public class ConfigGenerator {
    public ConfigGenerator() {
        SetConfig.setIsIACConfiguration((boolean)true);
        SetConfig.setIsInvokedByWorkbench((boolean)true);
    }

    public void allowAllWithNoSecurity(String acHome, String javaExecutable, String pluginsFolder, File[] plugins) {
        String[] arguments = new String[]{"-silent", "RASERVER_HOME=\"" + acHome + "\"", "PLUGINS_HOME=\"" + pluginsFolder + "\"", "JAVA_PATH=\"" + javaExecutable + "\"", "TYPE=ALL", "SECURITY=FALSE", "HOSTS=\"\"", "USERS=\"\""};
        SetConfig.generateConfig((String[])arguments, (IConfigUtility)new IACConfigUtil(), (File[])plugins);
    }

    public void setUpLocallyWithNoSecurity(String acHome, String javaExecutable, String pluginsFolder, File[] plugins) {
        String[] arguments = new String[]{"-silent", "RASERVER_HOME=\"" + acHome + "\"", "JAVA_PATH=\"" + javaExecutable + "\"", "PLUGINS_HOME=\"" + pluginsFolder + "\"", "TYPE=LOCAL", "SECURITY=FALSE", "HOSTS=\"\"", "USERS=\"\""};
        SetConfig.generateConfig((String[])arguments, (IConfigUtility)new IACConfigUtil(), (File[])plugins);
    }

    public void customAccessWithNoSecurity(String hosts, String acHome, String javaExecutable, String pluginsFolder, File[] plugins) {
        if (!AdminUtil.validString(hosts)) {
            hosts = "localhost";
        }
        String[] arguments = new String[]{"-silent", "RASERVER_HOME=\"" + acHome + "\"", "JAVA_PATH=\"" + javaExecutable + "\"", "PLUGINS_HOME=\"" + pluginsFolder + "\"", "TYPE=CUSTOM", "HOSTS=" + hosts, "SECURITY=FALSE", "USERS=\"\""};
        SetConfig.generateConfig((String[])arguments, (IConfigUtility)new IACConfigUtil(), (File[])plugins);
    }

    public void allowAllWithSecurity(String userType, String userList, String acHome, String javaExecutable, String pluginsFolder, File[] plugins) {
        if (!AdminUtil.validString(userType)) {
            userType = "ANY";
        }
        String[] arguments = new String[]{"-silent", "RASERVER_HOME=\"" + acHome + "\"", "JAVA_PATH=\"" + javaExecutable + "\"", "PLUGINS_HOME=\"" + pluginsFolder + "\"", "TYPE=ALL", "SECURITY=TRUE", "USERTYPE=" + userType, "USERLIST=" + userList, "HOSTS=\"\""};
        SetConfig.generateConfig((String[])arguments, (IConfigUtility)new IACConfigUtil(), (File[])plugins);
    }

    public void setUpLocallyWithSecurity(String userType, String userList, String acHome, String javaExecutable, String pluginsFolder, File[] plugins) {
        if (!AdminUtil.validString(userType)) {
            userType = "ANY";
        }
        String[] arguments = new String[]{"-silent", "RASERVER_HOME=\"" + acHome + "\"", "JAVA_PATH=\"" + javaExecutable + "\"", "PLUGINS_HOME=\"" + pluginsFolder + "\"", "SECURITY=TRUE", "USERTYPE=" + userType, "USERLIST=" + userList, "TYPE=LOCAL", "HOSTS=\"\""};
        SetConfig.generateConfig((String[])arguments, (IConfigUtility)new IACConfigUtil(), (File[])plugins);
    }

    public void customAccessWithSecurity(String hosts, String userType, String userList, String acHome, String javaExecutable, String pluginsFolder, File[] plugins) {
        if (!AdminUtil.validString(userType)) {
            userType = "ANY";
        }
        if (!AdminUtil.validString(hosts)) {
            hosts = "localhost";
        }
        String[] arguments = new String[]{"-silent", "RASERVER_HOME=\"" + acHome + "\"", "JAVA_PATH=\"" + javaExecutable + "\"", "TYPE=CUSTOM", "PLUGINS_HOME=\"" + pluginsFolder + "\"", "HOSTS=" + hosts, "SECURITY=TRUE", "USERTYPE=" + userType, "USERLIST=" + userList};
        SetConfig.generateConfig((String[])arguments, (IConfigUtility)new IACConfigUtil(), (File[])plugins);
    }

    public void generateConfiguration(String acHome, String javaExecutable, String pluginsFolder, File[] plugins, boolean security, String userType, String userList, String allowedHosts, String hosts) {
        if (security) {
            if (userType.equals(PreferenceMessages.ANY_USER)) {
                userType = "ANY";
            }
            if (allowedHosts.equals(PreferenceMessages.ALL_HOSTS)) {
                this.allowAllWithSecurity(userType, userList, acHome, javaExecutable, pluginsFolder, plugins);
            } else if (allowedHosts.equals(PreferenceMessages.LOCALHOST)) {
                this.setUpLocallyWithSecurity(userType, userList, acHome, javaExecutable, pluginsFolder, plugins);
            } else {
                this.customAccessWithSecurity(hosts, userType, userList, acHome, javaExecutable, pluginsFolder, plugins);
            }
        } else if (allowedHosts.equals(PreferenceMessages.ALL_HOSTS)) {
            this.allowAllWithNoSecurity(acHome, javaExecutable, pluginsFolder, plugins);
        } else if (allowedHosts.equals(PreferenceMessages.LOCALHOST)) {
            this.setUpLocallyWithNoSecurity(acHome, javaExecutable, pluginsFolder, plugins);
        } else {
            this.customAccessWithNoSecurity(hosts, acHome, javaExecutable, pluginsFolder, plugins);
        }
    }
}

