/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.integration.pde.internal.util;

import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.trace.ui.internal.util.WorkspaceFiltersExtractor;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.ui.launcher.JUnitLaunchConfigurationDelegate;
import org.eclipse.ui.IWorkingSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDEIntegrationLauncherUtility {
    private static void addToMap(Map<String, IPluginModelBase> map, IPluginModelBase[] models) {
        int i = 0;
        while (i < models.length) {
            PDEIntegrationLauncherUtility.addToMap(map, models[i]);
            ++i;
        }
    }

    private static void addToMap(Map<String, IPluginModelBase> map, IPluginModelBase model) {
        BundleDescription desc = model.getBundleDescription();
        if (desc != null) {
            String id = desc.getSymbolicName();
            if (!map.containsKey(id)) {
                map.put(id, model);
            } else {
                map.put(String.valueOf(id) + "_" + desc.getBundleId(), model);
            }
        }
    }

    private static IPluginModelBase[] getSelectedWorkspacePlugins(ILaunchConfiguration configuration) throws CoreException {
        boolean usedefault = configuration.getAttribute("default", true);
        boolean useFeatures = configuration.getAttribute("usefeatures", false);
        IPluginModelBase[] models = PluginRegistry.getWorkspaceModels();
        if (usedefault || useFeatures || models.length == 0) {
            return models;
        }
        ArrayList<IPluginModelBase> list = new ArrayList<IPluginModelBase>();
        if (configuration.getAttribute("automaticAdd", true)) {
            TreeSet<String> deselected = PDEIntegrationLauncherUtility.parsePlugins(configuration, "deselected_workspace_plugins");
            if (deselected.size() == 0) {
                return models;
            }
            int i = 0;
            while (i < models.length) {
                String id = models[i].getPluginBase().getId();
                if (id != null && !deselected.contains(id)) {
                    list.add(models[i]);
                }
                ++i;
            }
        } else {
            TreeSet<String> selected = PDEIntegrationLauncherUtility.parsePlugins(configuration, "selected_workspace_plugins");
            int i = 0;
            while (i < models.length) {
                String id = models[i].getPluginBase().getId();
                if (id != null && selected.contains(id)) {
                    list.add(models[i]);
                }
                ++i;
            }
        }
        return list.toArray(new IPluginModelBase[list.size()]);
    }

    public static TreeSet<String> parsePlugins(ILaunchConfiguration configuration, String attribute) throws CoreException {
        TreeSet<String> set = new TreeSet<String>();
        String ids = configuration.getAttribute(attribute, null);
        if (ids != null) {
            StringTokenizer tok = new StringTokenizer(ids, ",");
            while (tok.hasMoreTokens()) {
                set.add(tok.nextToken());
            }
        }
        return set;
    }

    public static IPluginModelBase[] getPluginList(ILaunchConfiguration config) throws CoreException {
        Map<String, IPluginModelBase> map = PDEIntegrationLauncherUtility.getPluginsToRun(config);
        return map.values().toArray(new IPluginModelBase[map.size()]);
    }

    public static Map<String, IPluginModelBase> getPluginsToRun(ILaunchConfiguration config) throws CoreException {
        TreeMap<String, IPluginModelBase> map = new TreeMap<String, IPluginModelBase>();
        if (config.getAttribute("default", true)) {
            PDEIntegrationLauncherUtility.addToMap(map, PluginRegistry.getActiveModels());
            return map;
        }
        if (config.getAttribute("usefeatures", false)) {
            PDEIntegrationLauncherUtility.addToMap(map, PluginRegistry.getWorkspaceModels());
            return map;
        }
        PDEIntegrationLauncherUtility.addToMap(map, PDEIntegrationLauncherUtility.getSelectedWorkspacePlugins(config));
        TreeSet<String> exModels = PDEIntegrationLauncherUtility.parsePlugins(config, "selected_target_plugins");
        IPluginModelBase[] exmodels = PluginRegistry.getExternalModels();
        int i = 0;
        while (i < exmodels.length) {
            IPluginModelBase existing;
            String id = exmodels[i].getPluginBase().getId();
            if (id != null && exModels.contains(id) && ((existing = map.get(id)) == null || existing.getUnderlyingResource() == null)) {
                PDEIntegrationLauncherUtility.addToMap(map, exmodels[i]);
            }
            ++i;
        }
        return map;
    }

    public static ArrayList getWorkspacePluginFilters(ILaunchConfiguration config, IWorkingSet[] workingSets) throws CoreException {
        ArrayList result = new ArrayList();
        IPluginModelBase[] plugins = PDEIntegrationLauncherUtility.getPluginList(config);
        int i = 0;
        while (i < plugins.length) {
            IResource res = plugins[i].getUnderlyingResource();
            if (res != null) {
                ArrayList filters = WorkspaceFiltersExtractor.extractFilters((IProject)res.getProject(), (IWorkingSet[])workingSets);
                result.addAll(filters);
            }
            ++i;
        }
        return result;
    }

    public static class JUnitPluginConfigurationExtended
    extends JUnitLaunchConfigurationDelegate {
        private IVMRunner runner;
        private VMRunnerConfiguration configuration;

        public IVMRunner getVMRunner(ILaunchConfiguration configuration, String mode) throws CoreException {
            if (this.runner == null) {
                this.runner = new IVMRunner(){

                    public void run(VMRunnerConfiguration configuration, ILaunch launch, IProgressMonitor monitor) throws CoreException {
                        JUnitPluginConfigurationExtended.this.configuration = configuration;
                    }
                };
            }
            return this.runner;
        }

        public VMRunnerConfiguration getVMRunnerConfiguration() {
            return this.configuration;
        }
    }
}

