/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.jvmti.client.internal;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCConfiguration;
import org.eclipse.hyades.models.hierarchy.TRCOption;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.tptp.platform.jvmti.client.internal.launcher.TIDelegateHelper;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherUtility;

public class TIUtility {
    public static final String OPEN_ANGLE_BRACKET = "<";
    public static final String FORWARD_SLASH = "/";
    public static final String EMPTY_STRING = "";
    public static final String CLOSE_ANGLE_BRACKET = ">";
    public static final String SINGLE_SPACE = " ";
    public static final String EQUAL_SIGN = "=";
    public static final String DOUBLE_QUOTE = "\"";

    public static void terminateAgentProxy(TRCAgentProxy agentProxy, boolean terminateProcessProxy) {
        agentProxy.setActive(false);
        agentProxy.setAttached(false);
        agentProxy.setMonitored(false);
        LauncherUtility.sendProfileEvent((int)16, (Object)agentProxy);
        TIUtility.closeFileStream(agentProxy);
        LoadersUtils.deregisterAgentInstance((TRCAgentProxy)agentProxy);
        if (!terminateProcessProxy) {
            return;
        }
        TRCProcessProxy processProxy = agentProxy.getProcessProxy();
        if (processProxy == null) {
            return;
        }
        EList agentProxies = processProxy.getAgentProxies();
        boolean agentsAreInactive = true;
        int i = 0;
        int agentCount = agentProxies.size();
        while (i < agentCount) {
            if (((TRCAgentProxy)agentProxies.get(i)).isActive()) {
                agentsAreInactive = false;
                break;
            }
            ++i;
        }
        if (agentsAreInactive) {
            TIUtility.terminateProcessProxy(processProxy);
        }
    }

    public static void closeFileStream(TRCAgentProxy trcAgentProxy) {
        if (trcAgentProxy == null || !trcAgentProxy.isToProfileFile()) {
            return;
        }
        final TIDelegateHelper.ACDataProcessorAdapter dataProcessor = (TIDelegateHelper.ACDataProcessorAdapter)LoadersUtils.locateDataProcessor((TRCAgentProxy)trcAgentProxy);
        if (dataProcessor != null && dataProcessor.getProfileFileName() == null) {
            dataProcessor.cleanUp();
        }
        if (dataProcessor != null && dataProcessor.getProfileFileName() != null) {
            dataProcessor.setProcessAlive(false);
            new Thread(new Runnable(){

                public void run() {
                    int currentActivityLevel = dataProcessor.getActivity();
                    int numOfWaits = 0;
                    do {
                        ++numOfWaits;
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    } while (numOfWaits < 5 && currentActivityLevel != dataProcessor.getActivity());
                    dataProcessor.setEnabled(false);
                    dataProcessor.endTrace(dataProcessor.getWriter());
                }
            }).start();
        }
    }

    public static void terminateProcessProxy(TRCProcessProxy processProxy) {
        processProxy.setActive(false);
        LauncherUtility.sendProfileEvent((int)16, (Object)processProxy);
    }

    public static TRCOption[] getAgentOptions(TRCAgentProxy agentProxy, String optionName) {
        EList agentProxyConf = agentProxy.getConfigurations();
        ArrayList<TRCOption> optionList = new ArrayList<TRCOption>();
        int i = 0;
        int confCount = agentProxyConf.size();
        while (i < confCount) {
            TRCConfiguration config = (TRCConfiguration)agentProxyConf.get(i);
            EList options = config.getOptions();
            int opt = 0;
            while (opt < options.size()) {
                TRCOption option = (TRCOption)options.get(opt);
                if (option.getKey().indexOf(optionName) != -1) {
                    optionList.add(option);
                }
                ++opt;
            }
            ++i;
        }
        TRCOption[] optionsFound = new TRCOption[optionList.size()];
        optionList.toArray(optionsFound);
        return optionsFound;
    }

    public static void addElement(StringBuffer stringBuffer, String elementName, boolean close, boolean end) {
        stringBuffer.append(OPEN_ANGLE_BRACKET);
        stringBuffer.append(close ? FORWARD_SLASH : EMPTY_STRING);
        stringBuffer.append(elementName);
        stringBuffer.append(end ? CLOSE_ANGLE_BRACKET : EMPTY_STRING);
    }

    public static void addAttribute(StringBuffer stringBuffer, String[] attributeNames, String[] attributeValues, boolean close, boolean end) {
        int i = 0;
        while (i < attributeValues.length) {
            if (attributeValues[i] != null) {
                stringBuffer.append(SINGLE_SPACE);
                stringBuffer.append(attributeNames[i]);
                stringBuffer.append(EQUAL_SIGN);
                stringBuffer.append(DOUBLE_QUOTE);
                stringBuffer.append(attributeValues[i]);
                stringBuffer.append(DOUBLE_QUOTE);
            }
            ++i;
        }
        stringBuffer.append(close ? FORWARD_SLASH : EMPTY_STRING);
        stringBuffer.append(end ? CLOSE_ANGLE_BRACKET : EMPTY_STRING);
    }
}

