/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.jvmti.client.internal.analysistypes;

import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tptp.platform.jvmti.client.internal.ITILaunchConfigurationConstants;
import org.eclipse.tptp.platform.jvmti.client.internal.TIMessages;
import org.eclipse.tptp.platform.jvmti.client.internal.TIPlugin;
import org.eclipse.tptp.platform.jvmti.client.internal.analysistypes.TIHeapAnalysisUI;
import org.eclipse.tptp.platform.jvmti.client.provisional.extension.ICustomAnalysisProvider;
import org.eclipse.tptp.trace.ui.internal.launcher.application.AbstractConfiguration;
import org.eclipse.tptp.trace.ui.internal.launcher.application.PIMemoryAnalysisConf;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherMessages;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherUtility;
import org.eclipse.tptp.trace.ui.provisional.launcher.DataCollectionEngineAttribute;

public class TIHeapAnalysisConfig
extends AbstractConfiguration {
    public TIHeapAnalysisConfig() {
        super(new Class[]{TIHeapAnalysisOpt.class});
    }

    public static class TIHeapAnalysisOpt
    extends PIMemoryAnalysisConf.MemoryConfigurationPage {
        private TIHeapAnalysisUI execHeapAnalysisUI = new TIHeapAnalysisUI();
        private boolean collectObjectAllocationSite;
        private ICustomAnalysisProvider[] providers = TIPlugin.getProviders();
        private boolean controlsCreated;

        public TIHeapAnalysisOpt() {
            this.execHeapAnalysisUI.setProviders(this.providers);
        }

        public void reset(ILaunchConfiguration launchConfiguration) {
            try {
                this.collectObjectAllocationSite = launchConfiguration.getAttribute(ITILaunchConfigurationConstants.ATTR_EXEC_OBJ_ALLOC_SITE, false);
                if (this.providers != null) {
                    int provider = 0;
                    while (provider < this.providers.length) {
                        this.providers[provider].resetAttribute(launchConfiguration);
                        ++provider;
                    }
                }
            }
            catch (CoreException e) {
                LauncherUtility.openErrorWithDetail((String)LauncherMessages.LAUNCHER_COMMON_ERROR_TITLE, (String)TIMessages.ERROR_TI_CONFIGURATION_RESET, (Throwable)e);
            }
        }

        public Vector getAttributes() {
            Vector<DataCollectionEngineAttribute> options = null;
            options = new Vector<DataCollectionEngineAttribute>();
            options.add(new DataCollectionEngineAttribute(ITILaunchConfigurationConstants.ATTR_EXEC_OBJ_ALLOC_SITE, String.valueOf(this.collectObjectAllocationSite)));
            if (this.providers != null) {
                int provider = 0;
                while (provider < this.providers.length) {
                    DataCollectionEngineAttribute additionalOption = this.providers[provider].getAttribute();
                    if (additionalOption != null) {
                        options.add(additionalOption);
                    }
                    ++provider;
                }
            }
            options.add(new DataCollectionEngineAttribute(ITILaunchConfigurationConstants.ATTR_HEAP_COLLECT_INSTANCE, "true"));
            return options;
        }

        public boolean storeAttributes(ILaunchConfigurationWorkingCopy configurationWC) {
            if (this.controlsCreated) {
                this.collectObjectAllocationSite = this.execHeapAnalysisUI.isCollectObjectAllocationSiteSelected();
            }
            configurationWC.setAttribute(ITILaunchConfigurationConstants.ATTR_EXEC_OBJ_ALLOC_SITE, this.collectObjectAllocationSite);
            if (this.providers != null) {
                int provider = 0;
                while (provider < this.providers.length) {
                    if (this.controlsCreated) {
                        this.providers[provider].updateAnalysisOption();
                    }
                    configurationWC.setAttribute(this.providers[provider].getLaunchConfigurationAttribute(), this.providers[provider].getCollectAnalysisOption());
                    ++provider;
                }
            }
            configurationWC.setAttribute(ITILaunchConfigurationConstants.ATTR_HEAP_COLLECT_INSTANCE, true);
            return true;
        }

        public void createControl(Composite parent) {
            this.controlsCreated = true;
            this.execHeapAnalysisUI.createControl(parent);
            this.execHeapAnalysisUI.setCollectObjectAllocationSite(this.collectObjectAllocationSite);
        }

        public String getDescription() {
            String desc = TIPlugin.getResourceString("JVMTI_ANALYSIS_TYPE_HEAP_DESC");
            return desc;
        }

        public String getTitle() {
            String title = TIPlugin.getResourceString("JVMTI_ANALYSIS_TYPE_HEAP_NAME");
            return title;
        }
    }
}

