/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.jvmti.client.internal.analysistypes;

import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tptp.platform.jvmti.client.internal.ITILaunchConfigurationConstants;
import org.eclipse.tptp.platform.jvmti.client.internal.TIMessages;
import org.eclipse.tptp.platform.jvmti.client.internal.analysistypes.TITimeAnalysisUI;
import org.eclipse.tptp.trace.ui.internal.launcher.application.AbstractConfiguration;
import org.eclipse.tptp.trace.ui.internal.launcher.application.PITimeAnalysisConf;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherMessages;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherUtility;
import org.eclipse.tptp.trace.ui.provisional.launcher.DataCollectionEngineAttribute;
import org.eclipse.tptp.trace.ui.provisional.launcher.IStatusListener;

public class TITimeAnalysisConfig
extends AbstractConfiguration {
    public TITimeAnalysisConfig() {
        super(new Class[]{TIExecutionTimeAnalysisOpt.class});
    }

    public static class TIExecutionTimeAnalysisOpt
    extends PITimeAnalysisConf.ExecutionTimeConfigurationPage {
        private TITimeAnalysisUI execTimeAnalysisUI = new TITimeAnalysisUI();
        private ILaunchConfiguration launchConfiguration;
        private boolean collectCPUTime;
        private boolean showExecutionFlow;
        private boolean autoPolling;
        private boolean manualPolling;
        private int pollingFrequency;

        public void reset(ILaunchConfiguration launchConfiguration) {
            this.launchConfiguration = launchConfiguration;
            try {
                this.collectCPUTime = launchConfiguration.getAttribute(ITILaunchConfigurationConstants.ATTR_EXEC_CPU_TIME, false);
                this.showExecutionFlow = launchConfiguration.getAttribute(ITILaunchConfigurationConstants.ATTR_EXEC_FLOW, true);
                this.autoPolling = launchConfiguration.getAttribute(ITILaunchConfigurationConstants.ATTR_EXEC_AUTO_POLLING, false);
                this.manualPolling = launchConfiguration.getAttribute(ITILaunchConfigurationConstants.ATTR_EXEC_MANUAL_POLLING, false);
                this.pollingFrequency = launchConfiguration.getAttribute(ITILaunchConfigurationConstants.ATTR_EXEC_POLLING_FREQ, 60);
            }
            catch (CoreException e) {
                LauncherUtility.openErrorWithDetail((String)LauncherMessages.LAUNCHER_COMMON_ERROR_TITLE, (String)TIMessages.ERROR_TI_CONFIGURATION_RESET, (Throwable)e);
            }
        }

        public Vector getAttributes() {
            Vector<DataCollectionEngineAttribute> options = null;
            try {
                options = new Vector<DataCollectionEngineAttribute>();
                options.add(new DataCollectionEngineAttribute("CPU_TIME", String.valueOf(this.launchConfiguration.getAttribute(ITILaunchConfigurationConstants.ATTR_EXEC_CPU_TIME, false))));
                options.add(new DataCollectionEngineAttribute("STACK_INFORMATION", "normal"));
                options.add(new DataCollectionEngineAttribute(ITILaunchConfigurationConstants.ATTR_EXEC_DATA, "true"));
                options.add(new DataCollectionEngineAttribute(ITILaunchConfigurationConstants.ATTR_EXEC_FLOW, String.valueOf(this.launchConfiguration.getAttribute(ITILaunchConfigurationConstants.ATTR_EXEC_FLOW, true))));
                options.add(new DataCollectionEngineAttribute(ITILaunchConfigurationConstants.ATTR_EXEC_AUTO_POLLING, String.valueOf(this.launchConfiguration.getAttribute(ITILaunchConfigurationConstants.ATTR_EXEC_AUTO_POLLING, false))));
                options.add(new DataCollectionEngineAttribute(ITILaunchConfigurationConstants.ATTR_EXEC_MANUAL_POLLING, String.valueOf(this.launchConfiguration.getAttribute(ITILaunchConfigurationConstants.ATTR_EXEC_MANUAL_POLLING, false))));
                options.add(new DataCollectionEngineAttribute(ITILaunchConfigurationConstants.ATTR_EXEC_POLLING_FREQ, String.valueOf(this.launchConfiguration.getAttribute(ITILaunchConfigurationConstants.ATTR_EXEC_POLLING_FREQ, 60))));
            }
            catch (CoreException e) {
                LauncherUtility.openErrorWithDetail((String)LauncherMessages.LAUNCHER_COMMON_ERROR_TITLE, (String)LauncherMessages.ERROR_LAUNCH_ATTRIBUTES, (Throwable)e);
            }
            return options;
        }

        public boolean storeAttributes(ILaunchConfigurationWorkingCopy configurationWC) {
            configurationWC.setAttribute(ITILaunchConfigurationConstants.ATTR_EXEC_CPU_TIME, this.execTimeAnalysisUI.isCollectCPUTimeSelected());
            configurationWC.setAttribute(ITILaunchConfigurationConstants.ATTR_EXEC_FLOW, this.execTimeAnalysisUI.isShowExecutionFlowSelected());
            configurationWC.setAttribute(ITILaunchConfigurationConstants.ATTR_EXEC_AUTO_POLLING, this.execTimeAnalysisUI.isAutoPollingSelected());
            configurationWC.setAttribute(ITILaunchConfigurationConstants.ATTR_EXEC_MANUAL_POLLING, this.execTimeAnalysisUI.isManualPollingSelected());
            configurationWC.setAttribute(ITILaunchConfigurationConstants.ATTR_EXEC_POLLING_FREQ, this.execTimeAnalysisUI.getPollingFrequency());
            return true;
        }

        public void addErrorListener(IStatusListener statusListener) {
        }

        public void createControl(Composite parent) {
            this.execTimeAnalysisUI.createControl(parent);
            this.execTimeAnalysisUI.setCollectCPUTime(this.collectCPUTime);
            this.execTimeAnalysisUI.setShowExecutionFlow(this.showExecutionFlow);
            this.execTimeAnalysisUI.setAutoPolling(this.autoPolling);
            this.execTimeAnalysisUI.setManualPolling(this.manualPolling);
            this.execTimeAnalysisUI.setPollingFrequency(this.pollingFrequency);
        }
    }
}

