/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.jvmti.client.internal.controlproviders;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.trace.ui.internal.core.TraceUIImages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.platform.execution.client.agent.ICollector;
import org.eclipse.tptp.platform.execution.client.core.IAgentController;
import org.eclipse.tptp.platform.execution.exceptions.InactiveAgentException;
import org.eclipse.tptp.platform.jvmti.client.internal.TIMessages;
import org.eclipse.tptp.platform.jvmti.client.internal.TIPlugin;
import org.eclipse.tptp.platform.jvmti.client.internal.TIUtility;
import org.eclipse.tptp.platform.jvmti.client.internal.actions.RunGCActionDelegate;
import org.eclipse.tptp.platform.jvmti.client.internal.controlproviders.TIProcessControlProvider;
import org.eclipse.tptp.platform.jvmti.client.internal.launcher.TIDelegateHelper;
import org.eclipse.tptp.platform.jvmti.client.internal.launcher.util.AgentControllerDelegate;
import org.eclipse.tptp.trace.ui.internal.control.provider.application.ControlMessages;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherMessages;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherUtility;
import org.eclipse.tptp.trace.ui.provisional.control.provider.AbstractAgentControlProvider;
import org.eclipse.tptp.trace.ui.provisional.control.provider.ControlItem;
import org.eclipse.tptp.trace.ui.provisional.control.provider.IAgentStateModifier;
import org.eclipse.tptp.trace.ui.provisional.control.provider.IControlItem;
import org.eclipse.tptp.trace.ui.provisional.control.provider.IProcessStateModifier;

public class TIAgentControlProvider
extends AbstractAgentControlProvider {
    private static final String RUNGC_ITEM = "org.eclipse.tptp.trace.jvmti.client.internal.popupMenu.RunGCAction";
    private IControlItem runGCControlItem;

    protected void initializeControlItems() {
        super.initializeControlItems();
        this.addControlItem(this.createRunGCControlItem());
    }

    protected IControlItem createRunGCControlItem() {
        if (this.runGCControlItem != null) {
            return this.runGCControlItem;
        }
        this.runGCControlItem = new RunGCControlItem();
        return this.runGCControlItem;
    }

    public IAgentStateModifier getAgentStateModifier() {
        return TIAgentStateModifier.getInstance();
    }

    public IProcessStateModifier getProcessStateModifier() {
        return TIProcessControlProvider.TIProcessStateModifier.getInstance();
    }

    static class RunGCControlItem
    extends ControlItem {
        private RunGCActionDelegate gcAction;

        public RunGCControlItem() {
            super(TIAgentControlProvider.RUNGC_ITEM, "gcGroup", ControlMessages.CONTROL_ITEM_GC_ACTION, TraceUIImages.INSTANCE.getImageDescriptor("c", "rungc_co.gif"));
            this.setDisabledImageDescriptor(TraceUIImages.INSTANCE.getImageDescriptor("d", "rungc_co.gif"));
            this.gcAction = new RunGCActionDelegate();
        }

        public void run() {
            try {
                Iterator agents = this.input.iterator();
                while (agents.hasNext()) {
                    this.gcAction.doAction(agents.next());
                }
            }
            catch (Exception e) {
                LauncherUtility.openMessageWithDetail((int)4, (String)"", (String)e.getMessage(), (Throwable)e);
            }
        }

        public boolean isEnabled() {
            if (this.input == null || this.input.size() == 0) {
                return false;
            }
            boolean isEnable = true;
            Iterator agents = this.input.iterator();
            while (isEnable && agents.hasNext()) {
                boolean bl = isEnable = isEnable && this.gcAction.isEnabledFor(agents.next());
            }
            return isEnable;
        }
    }

    public static class TIAgentStateModifier
    implements IAgentStateModifier {
        private static final byte CAN_ATTACH = 1;
        private static final byte CAN_DETACH = 2;
        private static final byte CAN_RESUME = 3;
        private static final byte CAN_PAUSE = 4;
        private static final byte ATTACH = 5;
        private static final byte DETACH = 6;
        private static final byte RESUME = 7;
        private static final byte PAUSE = 8;
        private static TIAgentStateModifier agentStateModifier = new TIAgentStateModifier();
        private StructuredSelection input;
        private Iterator inputIterator;

        private TIAgentStateModifier() {
        }

        public static TIAgentStateModifier getInstance() {
            return agentStateModifier;
        }

        /*
         * Unable to fully structure code
         */
        private TRCAgentProxy getNextAgent() {
            if (this.inputIterator != null) ** GOTO lbl6
            return null;
lbl-1000:
            // 1 sources

            {
                object = this.inputIterator.next();
                if (!(object instanceof TRCAgentProxy)) continue;
                return (TRCAgentProxy)object;
lbl6:
                // 2 sources

                ** while (this.inputIterator.hasNext())
            }
lbl7:
            // 1 sources

            return null;
        }

        public synchronized boolean canAttach() {
            return this.performCollectiveAction((byte)1);
        }

        public synchronized boolean canDetach() {
            return this.performCollectiveAction((byte)2);
        }

        public synchronized boolean canPause() {
            return this.performCollectiveAction((byte)4);
        }

        public synchronized boolean canResume() {
            return this.performCollectiveAction((byte)3);
        }

        public synchronized void attach() throws CoreException {
            this.performCollectiveAction((byte)5);
        }

        public synchronized void detach() throws CoreException {
            this.performCollectiveAction((byte)6);
        }

        public synchronized void pauseMonitoring() throws CoreException {
            this.performCollectiveAction((byte)8);
        }

        public synchronized void startMonitoring() throws CoreException {
            this.performCollectiveAction((byte)7);
        }

        public synchronized void setInput(StructuredSelection input) {
            this.input = input;
        }

        private boolean performCollectiveAction(byte operation) {
            TRCAgentProxy currentAgentProxy;
            this.inputIterator = this.input == null ? null : this.input.iterator();
            boolean status = true;
            boolean agentSelected = false;
            while ((currentAgentProxy = this.getNextAgent()) != null) {
                agentSelected = true;
                status = status && currentAgentProxy.isActive();
                switch (operation) {
                    case 1: {
                        status = status && !currentAgentProxy.isAttached() && !currentAgentProxy.isMonitored();
                        break;
                    }
                    case 2: {
                        status = status && currentAgentProxy.isAttached();
                        break;
                    }
                    case 3: {
                        status = status && !currentAgentProxy.isMonitored();
                        break;
                    }
                    case 4: {
                        status = status && currentAgentProxy.isAttached() && currentAgentProxy.isMonitored();
                        break;
                    }
                    default: {
                        this.doAction(currentAgentProxy, operation);
                    }
                }
            }
            return status && agentSelected;
        }

        private void doAction(TRCAgentProxy agentProxy, byte operation) {
            agentProxy.setMonitored(operation == 7);
            agentProxy.setAttached(operation != 6);
            agentProxy.setActive(true);
            TRCNode trcNode = agentProxy.getProcessProxy().getNode();
            IAgentController agentController = null;
            try {
                agentController = AgentControllerDelegate.getInstance().getConnection(trcNode.getName(), trcNode.getPort());
            }
            catch (Exception e) {
                LauncherUtility.openErrorWithDetail((String)LauncherMessages.LAUNCHER_COMMON_ERROR_TITLE, (String)NLS.bind((String)TIMessages.ERROR_TI_AC_UNAVAILABLE, (Object)String.valueOf(trcNode.getPort())), (Throwable)e);
            }
            ICollector tiAgent = null;
            if (agentController != null) {
                tiAgent = TIDelegateHelper.locateTIAgent(agentController, agentProxy.getProcessProxy().getPid());
            }
            if (tiAgent == null) {
                TIUtility.terminateAgentProxy(agentProxy, true);
                MessageDialog.openWarning((Shell)TIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)LauncherMessages.LAUNCHER_COMMON_WARNING_TITLE, (String)TIMessages.ERROR_TI_AGENT_INACTIVE);
            } else {
                switch (operation) {
                    case 5: {
                        final ICollector ctiAgent = tiAgent;
                        final TRCAgentProxy cagentProxy = agentProxy;
                        final IAgentController cagentController = agentController;
                        TIUtility.terminateAgentProxy(agentProxy, false);
                        new Job(TIMessages.TASK_CONNECTING_TO_AGENT){

                            protected IStatus run(IProgressMonitor monitor) {
                                TIDelegateHelper.getInstance().attachToAgent(cagentController, cagentProxy, ctiAgent.getProcess(), (IProgressMonitor)new NullProgressMonitor());
                                TIDelegateHelper.getInstance().startPolling(ctiAgent);
                                return Status.OK_STATUS;
                            }
                        }.schedule();
                        break;
                    }
                    case 6: {
                        TIUtility.closeFileStream(agentProxy);
                        LauncherUtility.sendProfileEvent((int)8, (Object)agentProxy);
                        tiAgent.stop();
                        tiAgent.cancel();
                        try {
                            Thread.sleep(500L);
                            tiAgent.stopMonitoring();
                        }
                        catch (InactiveAgentException inactiveAgentException) {
                        }
                        catch (Exception exception) {}
                        break;
                    }
                    case 7: {
                        LauncherUtility.sendProfileEvent((int)1, (Object)agentProxy);
                        tiAgent.resume();
                        break;
                    }
                    case 8: {
                        LauncherUtility.sendProfileEvent((int)2, (Object)agentProxy);
                        tiAgent.pause();
                        break;
                    }
                }
            }
        }
    }
}

