/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.jvmti.client.internal.launcher;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.util.ULocale;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.hyades.execution.core.IDataProcessor;
import org.eclipse.hyades.trace.ui.internal.util.ProcessAdapter;
import org.eclipse.tptp.platform.execution.client.core.IProcess;
import org.eclipse.tptp.platform.execution.client.core.internal.IProcessListener;
import org.eclipse.tptp.platform.execution.exceptions.InactiveAgentException;
import org.eclipse.tptp.platform.execution.exceptions.InactiveProcessException;
import org.eclipse.tptp.platform.execution.exceptions.NotConnectedException;
import org.eclipse.tptp.platform.jvmti.client.internal.launcher.IOProxy;

public class ACProcessToDebugProcessAdapter
extends ProcessAdapter {
    private Map attributes = new HashMap();
    private boolean isAlive = false;
    private String label;
    private IProcess process;
    private IOProxy proxy;
    private ILaunch launch;
    protected int launchMode = 1;

    public ACProcessToDebugProcessAdapter(ILaunch launch, IProcess process, int launchMode, boolean isAlive) {
        super(launch, (Object)process);
        process.addProcessListener((IProcessListener)new ProcessListener());
        DateFormat format = DateFormat.getDateTimeInstance((int)1, (int)2, (ULocale)ULocale.getDefault());
        this.launchMode = launchMode;
        this.label = String.valueOf(process.getExecutable()) + " " + "(" + format.format(new Date(System.currentTimeMillis())) + ")";
        this.launch = launch;
        this.process = process;
        this.isAlive = isAlive;
    }

    public Object getAdapter(Class adapter) {
        if (IDataProcessor.class.equals((Object)adapter)) {
            return this.proxy;
        }
        return null;
    }

    public String getAttribute(String key) {
        return (String)this.attributes.get(key);
    }

    public void setAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    public int getExitValue() throws DebugException {
        return 0;
    }

    public String getLabel() {
        return this.label;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public IStreamsProxy getStreamsProxy() {
        if (this.proxy == null) {
            this.proxy = new IOProxy(this.process, this.launch.getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_ENCODING"));
        }
        return this.proxy;
    }

    public boolean canTerminate() {
        return this.isAlive && this.getLaunchMode() != 0;
    }

    public boolean isTerminated() {
        return !this.isAlive;
    }

    public void terminate() throws DebugException {
        if (this.canTerminate()) {
            try {
                this.process.kill();
            }
            catch (InactiveProcessException e) {
                e.printStackTrace();
            }
            catch (NotConnectedException e) {
                e.printStackTrace();
            }
            catch (InactiveAgentException e) {
                e.printStackTrace();
            }
            this.isAlive = false;
        }
    }

    public int getLaunchMode() {
        return this.launchMode;
    }

    public void setLaunchMode(int launchMode) {
        this.launchMode = launchMode;
    }

    class ProcessListener
    implements IProcessListener {
        ProcessListener() {
        }

        public void processLaunched(IProcess p) {
            ACProcessToDebugProcessAdapter.this.isAlive = true;
        }

        public void processExited(IProcess p) {
            ACProcessToDebugProcessAdapter.this.isAlive = false;
        }
    }
}

