/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.jvmti.client.internal.launcher;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIPlugin;
import org.eclipse.tptp.platform.execution.client.agent.ICollector;
import org.eclipse.tptp.platform.execution.client.core.IAgentController;
import org.eclipse.tptp.platform.execution.client.core.IProcess;
import org.eclipse.tptp.platform.execution.client.core.internal.IProcessListener;
import org.eclipse.tptp.platform.execution.exceptions.NotConnectedException;
import org.eclipse.tptp.platform.jvmti.client.internal.TIMessages;
import org.eclipse.tptp.platform.jvmti.client.internal.TIPlugin;
import org.eclipse.tptp.platform.jvmti.client.internal.launcher.TIDelegateHelper;
import org.eclipse.tptp.platform.jvmti.client.internal.launcher.util.AgentControllerDelegate;
import org.eclipse.tptp.trace.ui.provisional.launcher.IAvailabilityTester;

public class AgentAvailibilityTester
implements IAvailabilityTester {
    private String hostName;
    private int port;
    private ILaunchConfiguration configuration;
    private boolean isAgentAvailable;

    public void reset(ILaunchConfiguration configuration) {
        if (configuration == null || configuration.equals(this.configuration)) {
            return;
        }
        try {
            this.configuration = configuration;
            this.hostName = configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_HOSTNAME, null);
            this.port = configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PORT, -1);
            if (this.hostName == null) {
                this.hostName = "127.0.0.1";
            }
            if (this.port == -1) {
                IPreferenceStore store = CommonUIPlugin.getDefault().getPreferenceStore();
                this.port = store.getInt("localhost_port");
            }
        }
        catch (CoreException coreException) {
            this.hostName = null;
        }
    }

    public IStatus isServiceAvailable() {
        Status status;
        this.isAgentAvailable = false;
        if (this.hostName == null) {
            return new Status(4, TIPlugin.getId(), 4, TIMessages.ERROR_TI_AC_UNKNOWN_HOST, null);
        }
        AgentControllerDelegate acDelegate = AgentControllerDelegate.getInstance();
        try {
            final IAgentController ac = acDelegate.getConnection(this.hostName, this.port);
            final IProcess process = ac.createProcess();
            process.setExecutable("java.exe");
            process.setParameter(" " + TIDelegateHelper.TI_JVM_FLAG + " " + "org.eclipse.tptp.martini.HeapProxy");
            process.setLocation(".");
            process.addProcessListener(new IProcessListener(){

                public void processLaunched(IProcess process) {
                    try {
                        ICollector tiAgent = (ICollector)ac.getAgent("org.eclipse.tptp.jvmti", ICollector.class.getName(), process.getProcessId());
                        int retrycount = 0;
                        while (tiAgent == null && retrycount <= 100) {
                            tiAgent = (ICollector)ac.getAgent("org.eclipse.tptp.jvmti", ICollector.class.getName(), process.getProcessId());
                            Thread.sleep(100L);
                            ++retrycount;
                        }
                        if (tiAgent != null) {
                            AgentAvailibilityTester.this.isAgentAvailable = true;
                        }
                        process.kill();
                    }
                    catch (Exception exception) {}
                }

                public void processExited(IProcess process) {
                }
            });
            new Thread(new Runnable(){

                public void run() {
                    try {
                        process.launch();
                    }
                    catch (Exception exception) {}
                }
            }).start();
            int totalWaits = 0;
            while (!this.isAgentAvailable && totalWaits < 100) {
                ++totalWaits;
                Thread.sleep(100L);
            }
            if (!this.isAgentAvailable) {
                return new Status(4, TIPlugin.getId(), 4, NLS.bind((String)TIMessages.ERROR_TI_AGENT_UNAVAILABLE, (Object)"org.eclipse.tptp.jvmti"), null);
            }
            status = new Status(0, TIPlugin.getId(), 0, TIMessages.TI_AGNET_CONNECTION_SUCCESS, null);
        }
        catch (NotConnectedException e) {
            status = new Status(4, TIPlugin.getId(), 4, TIMessages.ERROR_TI_AC_NOT_CONNECTED, (Throwable)e);
        }
        catch (Exception e) {
            status = new Status(4, TIPlugin.getId(), 4, TIMessages.ERROR_TI_AC_UNKNOWN, (Throwable)e);
        }
        return status;
    }
}

