/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.jvmti.client.internal.launcher;

import com.ibm.icu.text.DateFormat;
import java.util.Date;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCConfiguration;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCOption;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.util.SaveUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.tptp.platform.execution.client.agent.IAgent;
import org.eclipse.tptp.platform.execution.client.core.IProcess;
import org.eclipse.tptp.platform.execution.client.core.internal.IProcessListener;
import org.eclipse.tptp.platform.execution.exceptions.InactiveProcessException;

public class HierarchicalModelFactory {
    public static TRCProcessProxy createTRCProcessProxy(TRCNode trcNode, IProcess process) {
        try {
            boolean isProcessLaunched;
            long processId = process.getProcessId();
            String processUUID = process.getUUID();
            boolean bl = isProcessLaunched = processId > 0L && process.isActive();
            if (isProcessLaunched) {
                for (TRCProcessProxy currentTRCProcessProxy : trcNode.getProcessProxies()) {
                    if (currentTRCProcessProxy.eIsProxy() || (long)currentTRCProcessProxy.getPid() != processId) continue;
                    return currentTRCProcessProxy;
                }
            }
            TRCMonitor monitor = trcNode.getMonitor();
            StringBuffer processName = new StringBuffer(monitor.getName()).append("_").append(trcNode.getName()).append("_").append(processId);
            EList pExt = HierarchicalModelFactory.createResource((EObject)trcNode, processName, "trcpxmi");
            HierarchyFactory factory = UIPlugin.getDefault().getPerftraceFactory();
            final TRCProcessProxy trcProcessProxy = factory.createTRCProcessProxy();
            if (isProcessLaunched) {
                trcProcessProxy.setPid((int)processId);
                trcProcessProxy.setRuntimeId(processUUID);
            } else {
                process.addProcessListener(new IProcessListener(){
                    private boolean enabled = true;

                    public void processLaunched(IProcess process) {
                        if (this.enabled) {
                            trcProcessProxy.setRuntimeId(process.getUUID());
                            try {
                                trcProcessProxy.setPid((int)process.getProcessId());
                            }
                            catch (InactiveProcessException e) {
                                e.printStackTrace();
                            }
                        }
                    }

                    public void processExited(IProcess process) {
                        this.enabled = false;
                    }
                });
            }
            String executionProcessName = process.getName();
            if (executionProcessName != null) {
                trcProcessProxy.setName(executionProcessName);
            } else {
                trcProcessProxy.setName(process.getExecutable());
            }
            trcProcessProxy.setLocation(process.getLocation());
            trcProcessProxy.setActive(true);
            trcProcessProxy.setLaunchMode(0);
            trcProcessProxy.setNode(trcNode);
            pExt.add((Object)trcProcessProxy);
            return trcProcessProxy;
        }
        catch (InactiveProcessException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static TRCAgentProxy createTRCAgentProxy(TRCProcessProxy processProxy, IAgent agent, String agentType) {
        for (TRCAgentProxy currentAgentProxy : processProxy.getAgentProxies()) {
            if (currentAgentProxy.eIsProxy() || !currentAgentProxy.getName().equals(agent.getName()) || !agentType.equals(currentAgentProxy.getType()) || !currentAgentProxy.isActive() || !currentAgentProxy.isMonitored()) continue;
            return currentAgentProxy;
        }
        TRCNode trcNode = processProxy.getNode();
        StringBuffer resourceName = new StringBuffer(trcNode.getMonitor().getName()).append("_").append(trcNode.getName()).append("_").append(processProxy.getPid()).append("_").append(agent.getName());
        EList agExt = HierarchicalModelFactory.createResource((EObject)processProxy, resourceName, "trcaxmi");
        HierarchyFactory factory = UIPlugin.getDefault().getPerftraceFactory();
        TRCAgentProxy trcAgentProxy = factory.createTRCAgentProxy();
        trcAgentProxy.setName(agent.getName());
        trcAgentProxy.setType(agentType);
        trcAgentProxy.setProcessProxy(processProxy);
        TRCAgent iAgent = factory.createTRCAgent();
        iAgent.setAgentProxy(trcAgentProxy);
        agExt.add((Object)iAgent);
        PDCoreUtil.markModifiedResources((EObject)iAgent, (boolean)true);
        iAgent.setName(agent.getName());
        iAgent.setType(agentType);
        return trcAgentProxy;
    }

    private static EList createResource(EObject eobject, StringBuffer resourceName, String resourceExtension) {
        String timestamp;
        String rID = timestamp = DateFormat.getDateTimeInstance((int)0, (int)0).format(new Date());
        rID = TString.change((String)rID, (String)" ", (String)"");
        rID = TString.change((String)rID, (String)":", (String)"");
        String pPath = eobject.eResource().getURI().toString();
        Path path = new Path(pPath);
        if (path.segmentCount() > 1) {
            pPath = path.removeLastSegments(1).toString();
        }
        String fileName = String.valueOf(resourceName.append("_").append(rID).toString()) + "." + resourceExtension;
        IPath filePath = new Path(pPath).append(fileName);
        URI uri = SaveUtil.createURI((String)(String.valueOf(filePath.toString()) + "#")).trimFragment();
        Resource agDoc = Resource.Factory.Registry.INSTANCE.getFactory(uri).createResource(uri);
        EList agExt = agDoc.getContents();
        UIPlugin.getDefault().getResourceSet().getResources().add((Object)agDoc);
        return agExt;
    }

    public static TRCConfiguration createTRCConfiguration(TRCAgentProxy trcAgentProxy, String configuraitonName) {
        EList configurations = trcAgentProxy.getConfigurations();
        int i = 0;
        int configurationCount = configurations.size();
        while (i < configurationCount) {
            TRCConfiguration currentConfiguration = (TRCConfiguration)configurations.get(i);
            if (configuraitonName.equals(currentConfiguration.getName())) {
                return currentConfiguration;
            }
            ++i;
        }
        TRCConfiguration agentProxyConfiguration = UIPlugin.getDefault().getPerftraceFactory().createTRCConfiguration();
        agentProxyConfiguration.setName(configuraitonName);
        agentProxyConfiguration.setActive(true);
        agentProxyConfiguration.setAgentProxy(trcAgentProxy);
        trcAgentProxy.getConfigurations().add((Object)agentProxyConfiguration);
        return agentProxyConfiguration;
    }

    public static TRCOption createOption(TRCConfiguration configuration, String optionName, String optionValue) {
        TRCOption trcAgentProxyOption = UIPlugin.getDefault().getPerftraceFactory().createTRCOption();
        trcAgentProxyOption.setKey(optionName);
        trcAgentProxyOption.setValue(optionValue);
        trcAgentProxyOption.setConfiguration(configuration);
        return trcAgentProxyOption;
    }
}

