/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.jvmti.client.internal.launcher;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.tptp.platform.execution.client.core.IConsole;
import org.eclipse.tptp.platform.execution.client.core.IDataProcessor;
import org.eclipse.tptp.platform.execution.client.core.IProcess;

class IOProxy
implements IStreamsProxy,
IStreamMonitor,
IDataProcessor {
    private List listeners;
    private StringBuffer buffer;
    private IConsole console;
    private String encoding;

    public IOProxy(IProcess process, String consoleEncoding) {
        this.console = process.getConsole();
        this.console.setDataProcessor((IDataProcessor)this);
        this.encoding = consoleEncoding;
        this.buffer = new StringBuffer();
        this.listeners = new ArrayList();
    }

    public IStreamMonitor getErrorStreamMonitor() {
        return null;
    }

    public IStreamMonitor getOutputStreamMonitor() {
        return this;
    }

    public void write(String input) throws IOException {
        this.console.write(input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IStreamListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IStreamListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    public String getContents() {
        return this.buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incomingData(byte[] buffer, int length, InetAddress peer) {
        String str = null;
        try {
            str = new String(buffer, 0, length, this.encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            str = new String(buffer, 0, length);
        }
        this.buffer.append(str);
        List list = this.listeners;
        synchronized (list) {
            Iterator i = this.listeners.iterator();
            while (i.hasNext()) {
                ((IStreamListener)i.next()).streamAppended(str, (IStreamMonitor)this);
            }
        }
    }

    public void incomingData(char[] buffer, int length, InetAddress peer) {
        byte[] buf = new String(buffer).getBytes();
        this.incomingData(buf, buf.length, peer);
    }

    public void invalidDataType(byte[] arg0, int arg1, InetAddress arg2) {
    }

    public void waitingForData() {
    }
}

