/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.jvmti.client.internal.launcher.util;

import java.net.InetAddress;
import org.eclipse.tptp.platform.execution.client.agent.internal.AgentStatePool;
import org.eclipse.tptp.platform.execution.client.core.IAgentController;
import org.eclipse.tptp.platform.execution.client.core.IConsole;
import org.eclipse.tptp.platform.execution.client.core.IDataProcessor;
import org.eclipse.tptp.platform.execution.client.core.IProcess;
import org.eclipse.tptp.platform.execution.client.core.internal.IProcessListener;
import org.eclipse.tptp.platform.execution.util.internal.AgentControllerPool;
import org.eclipse.tptp.platform.jvmti.client.internal.launcher.ILauncherParameterProvider;

public class AgentControllerDelegate {
    private static AgentControllerDelegate instance = new AgentControllerDelegate();
    private static boolean isTigerAndHigher = false;

    private AgentControllerDelegate() {
    }

    public static AgentControllerDelegate getInstance() {
        return instance;
    }

    public IAgentController getConnection(String hostName, int portNumber, boolean reuseExistingConnection) throws Exception {
        return AgentControllerPool.getInstance().getConnection(hostName, portNumber);
    }

    public IAgentController getConnection(String hostName, int portNumber) throws Exception {
        return this.getConnection(hostName, portNumber, true);
    }

    public static String getUnifiedHostName(String hostName) {
        return AgentStatePool.getUnifiedHostName((String)hostName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkVMVersion(String hostName, int portNumber, String location) {
        try {
            IAgentController ac = AgentControllerPool.getInstance().getConnection(hostName, portNumber);
            IProcess process = ac.createProcess();
            process.setExecutable("java.exe");
            process.setParameter("-version");
            process.setLocation(location);
            IConsole console = process.getConsole();
            DataProcessor dp = new DataProcessor();
            console.setDataProcessor((IDataProcessor)dp, 1);
            process.addProcessListener(new IProcessListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void processExited(IProcess process) {
                    IProcess iProcess = process;
                    synchronized (iProcess) {
                        process.notify();
                    }
                }

                public void processLaunched(IProcess process) {
                }
            });
            process.launch();
            IProcess iProcess = process;
            synchronized (iProcess) {
                process.wait();
            }
            return isTigerAndHigher;
        }
        catch (Exception exp) {
            exp.printStackTrace();
            System.out.println("Error occurred while connecting to " + hostName + ":" + exp);
            return false;
        }
    }

    public static boolean checkVMVersion(ILauncherParameterProvider launcher) {
        String hostName = launcher.getHostName();
        int portNumber = launcher.getPortNumber();
        String location = launcher.getLocation();
        return AgentControllerDelegate.checkVMVersion(hostName, portNumber, location);
    }

    static class DataProcessor
    implements IDataProcessor {
        private static final String JAVA_VERSION = "java version";

        DataProcessor() {
        }

        public void incomingData(byte[] buffer, int length, InetAddress peer) {
            String line = new String(buffer, 0, length);
            int index = line.indexOf(JAVA_VERSION);
            if (index >= 0 && (index = line.indexOf("\"")) >= 0 && line.length() >= index + 4) {
                int version = Integer.parseInt(line.substring(index + 3, index + 4));
                isTigerAndHigher = version >= 5;
            }
        }

        public void incomingData(char[] buffer, int length, InetAddress peer) {
        }

        public void invalidDataType(byte[] data, int length, InetAddress peer) {
        }

        public void waitingForData() {
        }
    }
}

