/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.martini.analysis;

import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * Exception performing whole class analysis ignored.
 */
public class HeapObjectData {
    private static ConcurrentHashMap<Long, WeakReference<Object>> tidInstDataMap;
    private static boolean initialized;
    private static final String PRIMITIVE_TAG = "primitiveResult";
    private static final String ARRAY_COMPLEX_TAG = "complexArrayList";
    private static final String ARRAY_PRIMITIVE_TAG = "primitiveArrayList";
    private static final String COMPLEX_TYPE_TAG = "complexType";
    private static final String COMPLEX_MEMBER_TAG = "complexMember";
    private static final String COMPLEX_PRIMITIVE_MEMBER_TAG = "primitiveComplexMember";
    private static final String VERSION_TAG = "version";
    private static final String VERSION = "4.7.0";
    private static long previousRunTime;
    private static final boolean IS_DEBUG_ENABLED;

    public static void addToInstDataMap(long l, Object object) {
        if (!initialized || HeapObjectData.class == object) {
            return;
        }
        Long l2 = new Long(l);
        tidInstDataMap.put(l2, new WeakReference<Object>(object));
    }

    public static Object getObjectFromInstDataMap(long l) {
        Long l2 = new Long(l);
        if (tidInstDataMap == null) {
            return null;
        }
        WeakReference weakReference = (WeakReference)tidInstDataMap.get(l2);
        if (weakReference == null) {
            return null;
        }
        Object t = weakReference.get();
        return t;
    }

    public static native long getObjectTId(Object var0);

    public static Long getObjectFromInstDataMap(Object object) {
        long l = HeapObjectData.getObjectTId((Object)object);
        if (l == 0L) {
            return null;
        }
        return new Long(l);
    }

    public static String getObjectValuesFromInstDataMap(long l) {
        Long l2 = new Long(l);
        Object var3_2 = null;
        if (tidInstDataMap == null || l == 0L) {
            return new String();
        }
        WeakReference weakReference = (WeakReference)tidInstDataMap.get(l2);
        String string = new String();
        if (weakReference == null) {
            return string;
        }
        var3_2 = weakReference.get();
        if (var3_2 != null) {
            string = HeapObjectData.analyzeObject(var3_2);
        }
        return string;
    }

    public static void removeUnusedObjectsFromInstDataMap() {
        if (tidInstDataMap == null) {
            return;
        }
        long l = System.currentTimeMillis();
        if (l - previousRunTime > 60000L) {
            previousRunTime = l;
            Iterator iterator = tidInstDataMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (entry.getKey() == null || entry.getValue() == null || ((WeakReference)entry.getValue()).get() != null) continue;
                iterator.remove();
            }
        }
    }

    private static String analyzeObject(Object object) {
        StringBuilder stringBuilder = new StringBuilder("<");
        stringBuilder.append("version");
        stringBuilder.append(">");
        stringBuilder.append("4.7.0");
        stringBuilder.append("</");
        stringBuilder.append("version");
        stringBuilder.append(">");
        if (object == null) {
            return stringBuilder.toString();
        }
        Class<?> clazz = object.getClass();
        if (HeapObjectData.isPrimitiveObject((Object)object)) {
            stringBuilder.append("<");
            stringBuilder.append("primitiveResult");
            stringBuilder.append(">");
            stringBuilder.append(object.getClass().getSimpleName());
            stringBuilder.append(":");
            stringBuilder.append(object.toString());
            stringBuilder.append("</");
            stringBuilder.append("primitiveResult");
            stringBuilder.append(">");
        } else if (clazz.isArray()) {
            Object object2;
            int n = Array.getLength(object);
            if (n > 0 && (object2 = Array.get(object, 0)) != null) {
                if (HeapObjectData.isPrimitiveObject((Object)object2)) {
                    stringBuilder.append("<");
                    stringBuilder.append("primitiveArrayList");
                    stringBuilder.append(">");
                    stringBuilder.append(object2.getClass().getSimpleName());
                    stringBuilder.append(":");
                    for (int i = 0; i < n; ++i) {
                        Object object3 = Array.get(object, i);
                        if (object3 == null) continue;
                        if (i != 0) {
                            stringBuilder.append(",");
                        }
                        stringBuilder.append(object3.toString());
                    }
                    stringBuilder.append("</");
                    stringBuilder.append("primitiveArrayList");
                    stringBuilder.append(">");
                } else {
                    stringBuilder.append("<");
                    stringBuilder.append("complexArrayList");
                    stringBuilder.append(">");
                    for (int i = 0; i < n; ++i) {
                        if (i != 0) {
                            stringBuilder.append(",");
                        }
                        stringBuilder.append(HeapObjectData.getObjectFromInstDataMap((Object)Array.get(object, i)));
                    }
                    stringBuilder.append("</");
                    stringBuilder.append("complexArrayList");
                    stringBuilder.append(">");
                }
            }
        } else if (object != null) {
            Field[] fieldArray = clazz.getDeclaredFields();
            stringBuilder.append("<");
            stringBuilder.append("complexType");
            stringBuilder.append(">");
            for (int i = 0; i < fieldArray.length; ++i) {
                Object object4;
                block21: {
                    if (fieldArray[i] == null) continue;
                    object4 = null;
                    fieldArray[i].setAccessible(true);
                    try {
                        object4 = fieldArray[i].get(object);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if (IS_DEBUG_ENABLED) {
                            System.err.println("Failed to obtain the member.");
                            illegalArgumentException.printStackTrace();
                        }
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        if (!IS_DEBUG_ENABLED) break block21;
                        System.err.println("Unable to access the member.");
                        illegalAccessException.printStackTrace();
                    }
                }
                if (object4 == null) continue;
                if (HeapObjectData.isPrimitiveObject((Object)object4)) {
                    stringBuilder.append("<");
                    stringBuilder.append("primitiveComplexMember");
                    stringBuilder.append(">");
                    stringBuilder.append(object4.getClass().getSimpleName());
                    stringBuilder.append(":");
                    stringBuilder.append(fieldArray[i].getName());
                    stringBuilder.append("=");
                    stringBuilder.append(object4.toString());
                    stringBuilder.append("</");
                    stringBuilder.append("primitiveComplexMember");
                    stringBuilder.append(">");
                    continue;
                }
                Long l = HeapObjectData.getObjectFromInstDataMap((Object)object4);
                stringBuilder.append("<");
                stringBuilder.append("complexMember");
                stringBuilder.append(">");
                stringBuilder.append(object4.getClass().getSimpleName());
                stringBuilder.append(":");
                stringBuilder.append(fieldArray[i].getName());
                stringBuilder.append("=");
                stringBuilder.append(l);
                stringBuilder.append("</");
                stringBuilder.append("complexMember");
                stringBuilder.append(">");
            }
            stringBuilder.append("</");
            stringBuilder.append("complexType");
            stringBuilder.append(">");
        } else if (IS_DEBUG_ENABLED) {
            System.err.println("Unrecongized type passed");
        }
        return stringBuilder.toString();
    }

    private static boolean isPrimitiveObject(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass().isPrimitive()) {
            return true;
        }
        return object instanceof Boolean || object instanceof Byte || object instanceof Character || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof String;
    }

    private static boolean showDebug() {
        String string = System.getenv("HEAP_OBJ_DATA_DEBUG");
        return string != null && string.equalsIgnoreCase("true");
    }

    static {
        previousRunTime = 0L;
        IS_DEBUG_ENABLED = HeapObjectData.showDebug();
        initialized = false;
        tidInstDataMap = new ConcurrentHashMap();
        initialized = true;
    }
}

