/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.hierarchy;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.loaders.hierarchy.IgnoredXMLFragmentLoader;
import org.eclipse.hyades.loaders.util.AgentsContext;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.models.hierarchy.util.SaveUtil;
import org.eclipse.hyades.models.hierarchy.util.StringUtil;
import org.eclipse.hyades.models.util.ModelDebugger;

public class XMLagentCreateLoader
extends IgnoredXMLFragmentLoader {
    protected String agentId;
    protected String agentName;
    protected String agentType;
    protected double time;

    public void addAttribute(String name, String value) {
        if (name.equals("agentId")) {
            this.agentId = value;
        } else if (name.equals("agentName")) {
            this.agentName = value;
        } else if (name.equals("agentType")) {
            this.agentType = value;
        } else if (name.equals("time")) {
            this.time = Double.parseDouble(value);
        }
    }

    public void addYourselfInContext() {
        TRCAgent agent = this.context.getAgent();
        TRCAgentProxy agentProxy = this.context.getAgentProxy();
        if (agent != null) {
            String rId = agent.getRuntimeId();
            if (this.agentId != null && rId != null && rId.equals(this.agentId)) {
                this.setSessionStartTime(this.time, agentProxy);
                return;
            }
            agent = null;
        }
        if (this.agentName == null || this.agentId == null) {
            return;
        }
        LoadersUtils.setDefaultContext(this.context);
        TRCProcessProxy process = this.context.getProcessProxy();
        TRCMonitor monitor = this.context.getMonitor();
        TRCNode node = this.context.getNode();
        agent = LoadersUtils.locateAgentFromProcess(process, this.agentName, this.agentId);
        if (agent != null) {
            if (this.agentId != null) {
                agent.setRuntimeId(this.agentId);
                if (agentProxy != null) {
                    agentProxy.setRuntimeId(this.agentId);
                }
            } else {
                agent.setRuntimeId("0");
                if (agentProxy != null) {
                    agentProxy.setRuntimeId("0");
                }
            }
            agent.setCollectionMode(this.context.getCollectionMode());
            this.setSessionStartTime(this.time, agentProxy);
            if (agent.eResource() != null) {
                this.registerAgent(agent);
                if (this.context.getAgent() == null) {
                    this.context.setAgent(agent);
                    this.context.setContextURI(agent.eResource().getURI().toString());
                    LookupServiceExtensions.getInstance().register(null, this.context);
                }
                if (this.context.getAgentProxy() == null && (agentProxy = agent.getAgentProxy()) != null) {
                    this.context.setAgentProxy(agentProxy);
                    agentProxy.setCollectionMode(this.context.getCollectionMode());
                }
                return;
            }
        }
        String monitorFolder = LoadersUtils.getMonitorFolder(monitor);
        Resource agDoc = null;
        if (monitorFolder != null) {
            String aName = String.valueOf(monitor.getName()) + "_" + node.getName().trim() + "_" + process.getPid() + "_" + process.getRuntimeId() + "_" + StringUtil.change(this.agentName.trim(), " ", "");
            String pFileName = String.valueOf(monitorFolder) + aName;
            String rName = ModelDebugger.INSTANCE.debugDatabaseResourcePostfix != null && ModelDebugger.INSTANCE.debugDatabaseResourcePostfix.length() > 0 ? String.valueOf(pFileName) + ModelDebugger.INSTANCE.debugDatabaseResourcePostfix : String.valueOf(pFileName) + ".trcaxmi";
            URI uri = SaveUtil.createURI(String.valueOf(rName) + "#").trimFragment();
            agDoc = Resource.Factory.Registry.INSTANCE.getFactory(uri).createResource(uri);
            agDoc.setModified(true);
            HierarchyResourceSetImpl.getInstance().getResources().add((Object)agDoc);
        }
        if (agent == null) {
            agent = HierarchyFactory.eINSTANCE.createTRCAgent();
            agent.setCollectionMode(this.context.getCollectionMode());
            agentProxy = null;
        }
        if (agent.getAgentProxy() != null) {
            agentProxy = agent.getAgentProxy();
        }
        if (this.agentType == null) {
            this.agentType = "Logging";
        }
        if (agentProxy == null) {
            agentProxy = HierarchyFactory.eINSTANCE.createTRCAgentProxy();
            agentProxy.setName(this.agentName);
            agentProxy.setStartTime(this.time);
            agentProxy.setType(this.agentType);
            agentProxy.setProcessProxy(process);
            agentProxy.setCollectionMode(this.context.getCollectionMode());
        }
        agent.setName(this.agentName);
        this.setSessionStartTime(this.time, agentProxy);
        if (this.agentType != null) {
            agent.setType(this.agentType);
            agentProxy.setType(this.agentType);
        }
        agent.setRuntimeId(this.agentId);
        agentProxy.setRuntimeId(this.agentId);
        agent.setAgentProxy(agentProxy);
        agentProxy.setProcessProxy(this.context.getProcessProxy());
        this.context.setAgent(agent);
        this.context.setAgentProxy(agentProxy);
        this.context.setContextURI(agDoc.getURI().toString());
        LookupServiceExtensions.getInstance().register(null, this.context);
        this.registerAgent(agent);
        agDoc.getContents().add((Object)agent);
    }

    protected void registerAgent(TRCAgent agent) {
        AgentsContext agentsContext = (AgentsContext)LookupServiceExtensions.getInstance().locate(null, AgentsContext.class, LoadersUtils.getLookUpKey(agent.getRuntimeId()));
        if (agentsContext == null) {
            agentsContext = new AgentsContext(agent.getRuntimeId());
            LookupServiceExtensions.getInstance().register(null, agentsContext);
        }
        agentsContext.registerAgent(agent);
    }

    public void initialize(HierarchyContext context, String name) {
        super.initialize(context, name);
        this.agentId = null;
        this.agentName = null;
        this.agentType = null;
        this.time = 0.0;
    }

    public void setSessionStartTime(double time, TRCAgentProxy agentProxy) {
        if (agentProxy == null) {
            return;
        }
        agentProxy.setStartTime(time);
        TRCAgent agent = (TRCAgent)agentProxy.eGet((EStructuralFeature)HierarchyPackage.eINSTANCE.getTRCAgentProxy_Agent(), false);
        if (agent != null && !agent.eIsProxy()) {
            agent.setStartTime(time);
        }
    }
}

