/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.hierarchy;

import org.eclipse.hyades.loaders.hierarchy.IgnoredXMLFragmentLoader;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCConfiguration;
import org.eclipse.hyades.models.hierarchy.TRCFilter;
import org.eclipse.hyades.models.hierarchy.util.EMFUtil;

public class XMLfilterLoader
extends IgnoredXMLFragmentLoader {
    protected String genericPattern;
    protected String mode;
    protected String pattern;
    protected String methodPattern;
    protected String methodMode;
    protected String methodGenericPattern;

    public void addAttribute(String name, String value) {
        if (name.equals("genericPattern")) {
            this.genericPattern = value;
        } else if (name.equals("mode")) {
            this.mode = value;
        } else if (name.equals("pattern")) {
            this.pattern = value;
        } else if (name.equals("methodPattern")) {
            this.methodPattern = value;
        } else if (name.equals("methodMode")) {
            this.methodMode = value;
        } else if (name.equals("methodGenericPattern")) {
            this.methodGenericPattern = value;
        }
    }

    public void addYourselfInContext() {
        TRCAgentProxy agentProxy;
        TRCAgent agent = this.context.getAgent();
        if (agent == null) {
            LoadersUtils.createAgent(this.context);
        }
        if ((agentProxy = this.context.getAgentProxy()) == null) {
            agentProxy = agent.getAgentProxy();
        }
        TRCConfiguration config = null;
        Object[] configList = agentProxy.getConfigurations().toArray();
        int idx = 0;
        while (idx < configList.length) {
            TRCConfiguration c = (TRCConfiguration)configList[idx];
            if (c.getName() != null && c.getName().equals("__JVMPI__")) {
                config = c;
                break;
            }
            ++idx;
        }
        if (config == null) {
            config = HierarchyFactory.eINSTANCE.createTRCConfiguration();
            config.setName("__JVMPI__");
            config.setActive(true);
            config.setAgentProxy(agentProxy);
        }
        TRCFilter filter = HierarchyFactory.eINSTANCE.createTRCFilter();
        if (this.methodPattern == null || this.methodPattern.trim().length() == 0) {
            filter.setOperation("*");
        } else if (this.methodGenericPattern != null && this.methodGenericPattern.trim().length() > 0) {
            filter.setOperation(String.valueOf(this.methodGenericPattern.equals("PREFIX") ? "*" : "") + this.methodPattern + (this.methodGenericPattern.equals("SUFFIX") ? "*" : ""));
        } else {
            filter.setOperation("*");
        }
        if (this.genericPattern != null && this.genericPattern.trim().length() > 0) {
            filter.setPattern(String.valueOf(this.genericPattern.equals("PREFIX") ? "*" : "") + this.pattern + (this.genericPattern.equals("SUFFIX") ? "*" : ""));
        } else {
            filter.setPattern("*");
        }
        if (this.methodMode != null && this.methodMode.trim().length() > 0) {
            filter.setMode(this.methodMode);
        }
        if (this.mode != null && this.mode.trim().length() > 0) {
            filter.setType(this.mode);
        }
        filter.setActive(Boolean.TRUE);
        if (!EMFUtil.containsObjectUsingSpecialEqual(filter, config)) {
            filter.setConfiguration(config);
        }
    }

    public void initialize(HierarchyContext context, String name) {
        super.initialize(context, name);
        this.pattern = null;
        this.genericPattern = null;
        this.mode = null;
        this.methodPattern = null;
        this.methodMode = null;
        this.methodGenericPattern = null;
    }
}

