/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.internal.binary;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.hyades.loaders.internal.binary.BFReader;
import org.eclipse.hyades.loaders.internal.binary.Offset;

public class BFHeader {
    public static final int LENGTH = 12;
    private Magic magic = Magic.TBF_INDENT;
    private Version version = Version.VERSION_1_0;
    private Platform platform = Platform.IA32;
    private Endianness endianness = Endianness.BIG_ENDIAN;

    public boolean parse(InputStream inputStream, Offset offset) throws IOException {
        byte[] header = new byte[12];
        if (inputStream.read(header) < 0) {
            throw new IllegalArgumentException("Malformed header");
        }
        return this.parse(header, 0, offset);
    }

    public boolean parse(byte[] header, int start, Offset offset) {
        Offset marker = new Offset(start, 12L);
        marker.increaseOffset(1);
        this.magic = Magic.read(header, marker);
        if (this.magic == null) {
            return false;
        }
        this.version = Version.read(header, marker);
        if (this.version == null) {
            throw new IllegalArgumentException("Version is not supported");
        }
        this.platform = Platform.read(header, marker);
        if (this.platform == null) {
            throw new IllegalArgumentException("Platform is not supported");
        }
        this.endianness = Endianness.read(header, marker);
        if (this.endianness == null) {
            throw new IllegalArgumentException("Endianness is not supported");
        }
        offset.increaseOffset(12);
        return true;
    }

    public Magic getMagic() {
        return this.magic;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public Endianness getEndianness() {
        return this.endianness;
    }

    public Version getVersion() {
        return this.version;
    }

    public BFReader visit(BFReader reader) {
        if (Platform.IA32.equals(this.platform) && Endianness.LITTLE_ENDIAN.equals(this.endianness)) {
            reader.setNumberReader(BFReader.LE_64_READER);
        } else if (Platform.IA64.equals(this.platform) && Endianness.LITTLE_ENDIAN.equals(this.endianness)) {
            reader.setNumberReader(BFReader.LE_64_READER);
        } else if (Endianness.BIG_ENDIAN.equals(this.endianness)) {
            reader.setNumberReader(BFReader.BE_64_READER);
        }
        return reader;
    }

    public static class Encoding {
        private static Map entries = new HashMap();
        public static final Encoding UTF8 = new Encoding(0);
        public static final Encoding ASCII = new Encoding(1);
        private final int code;

        public Encoding(int code) {
            this.code = code;
            entries.put(new Integer(code), this);
        }

        public int getCode() {
            return this.code;
        }

        public static Encoding read(byte[] header, Offset offset) {
            byte code = header[offset.increaseOffset(1)];
            return (Encoding)entries.get(new Integer(code));
        }
    }

    public static class Endianness {
        private static Map entries = new HashMap();
        public static final Endianness BIG_ENDIAN = new Endianness(1);
        public static final Endianness LITTLE_ENDIAN = new Endianness(0);
        private final int code;

        public Endianness(int code) {
            this.code = code;
            entries.put(new Integer(code), this);
        }

        public int getCode() {
            return this.code;
        }

        public static Endianness read(byte[] header, Offset offset) {
            byte code = header[offset.increaseOffset(1)];
            return (Endianness)entries.get(new Integer(code));
        }
    }

    public static class Magic {
        private static Map entries = new HashMap();
        public static int LENGTH = 3;
        public static final Magic TBF_INDENT = new Magic("TBF");
        private final String magic;

        public Magic(String magic) {
            this.magic = magic;
            entries.put(magic, this);
        }

        public String getMagic() {
            return this.magic;
        }

        public static Magic read(byte[] header, Offset offset) {
            String magic = new String(header, offset.increaseOffset(LENGTH), LENGTH);
            return (Magic)entries.get(magic);
        }
    }

    public static class Platform {
        private static Map entries = new HashMap();
        public static final Platform IA32 = new Platform(0);
        public static final Platform IA64 = new Platform(1);
        private final int code;

        public Platform(int code) {
            this.code = code;
            entries.put(new Integer(code), this);
        }

        public int getCode() {
            return this.code;
        }

        public static Platform read(byte[] header, Offset offset) {
            byte code = header[offset.increaseOffset(1)];
            return (Platform)entries.get(new Integer(code));
        }
    }

    public static class Version {
        private static Map entries = new HashMap();
        public static final Version VERSION_1_0 = new Version(1.0);
        private final double version;

        public Version(double version) {
            this.version = version;
            entries.put(new Double(version), this);
        }

        public double getVersion() {
            return this.version;
        }

        public static Version read(byte[] header, Offset offset) {
            byte major = header[offset.increaseOffset(1)];
            byte minor = header[offset.increaseOffset(1)];
            double ver = (double)major + (double)minor * 0.1;
            return (Version)entries.get(new Double(ver));
        }
    }
}

