/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.internal.binary;

import java.io.UnsupportedEncodingException;
import org.eclipse.hyades.loaders.internal.binary.NumberReader;
import org.eclipse.hyades.loaders.internal.binary.Offset;
import org.eclipse.hyades.loaders.internal.binary.StringReader;

public class BFReader
implements NumberReader,
StringReader {
    public static final StringReader ASCII_READER = new StringReader(){
        private static final char EOS = '\u0000';
        private static final String DEFAULT_ENCODING = "UTF-8";
        private String encoding = "UTF-8";

        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public String readString(byte[] b, Offset offset) {
            int start = offset.getOffset();
            int end = -1;
            int i = start;
            while (i < b.length) {
                char c = (char)b[i];
                if (c == '\u0000') {
                    end = i;
                    break;
                }
                ++i;
            }
            if (end >= 0) {
                int stringOffset = end - start + 1;
                if (offset.increaseOffset(stringOffset) < 0) {
                    return null;
                }
                try {
                    return new String(b, start, stringOffset - 1, this.encoding);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    this.setEncoding(DEFAULT_ENCODING);
                    return new String(b, start, stringOffset - 1);
                }
            }
            return null;
        }

        public String[] readStringArray(byte[] b, int length, Offset offset) {
            String[] res = new String[length];
            int i = 0;
            while (i < length) {
                res[i] = this.readString(b, offset);
                ++i;
            }
            return res;
        }
    };
    public static final NumberReader BE_64_READER = new NumberReader(){
        private long cpuFrequency;

        public short readShort(byte[] b, Offset offset) {
            int start = offset.getOffset();
            if (offset.increaseOffset(2) < 0) {
                return 0;
            }
            byte ch1 = b[start];
            byte ch2 = b[start + 1];
            return (short)((ch2 << 0) + (ch1 << 8));
        }

        public int readUnsignedShort(byte[] b, Offset offset) {
            int start = offset.getOffset();
            if (offset.increaseOffset(2) < 0) {
                return 0;
            }
            int ch1 = b[start] & 0xFF;
            int ch2 = b[start + 1] & 0xFF;
            return (ch2 << 0) + (ch1 << 8);
        }

        public int readInt(byte[] b, Offset offset) {
            int start = offset.getOffset();
            if (offset.increaseOffset(4) < 0) {
                return 0;
            }
            byte ch1 = b[start];
            byte ch2 = b[start + 1];
            byte ch3 = b[start + 2];
            byte ch4 = b[start + 3];
            return (ch4 << 0) + (ch3 << 8) + (ch2 << 16) + (ch1 << 24);
        }

        public long readUnsignedInt(byte[] b, Offset offset) {
            int start = offset.getOffset();
            if (offset.increaseOffset(4) < 0) {
                return 0L;
            }
            int ch1 = b[start] & 0xFF;
            int ch2 = b[start + 1] & 0xFF;
            int ch3 = b[start + 2] & 0xFF;
            int ch4 = b[start + 3] & 0xFF;
            return (ch4 << 0) + (ch3 << 8) + (ch2 << 16) + (ch1 << 24);
        }

        public long readLong(byte[] b, Offset offset) {
            int start = offset.getOffset();
            if (offset.increaseOffset(8) < 0) {
                return 0L;
            }
            byte ch1 = b[start];
            byte ch2 = b[start + 1];
            byte ch3 = b[start + 2];
            byte ch4 = b[start + 3];
            byte ch5 = b[start + 4];
            byte ch6 = b[start + 5];
            byte ch7 = b[start + 6];
            byte ch8 = b[start + 7];
            return ((long)(ch8 & 0xFF) << 0) + ((long)(ch7 & 0xFF) << 8) + ((long)(ch6 & 0xFF) << 16) + ((long)(ch5 & 0xFF) << 24) + ((long)(ch4 & 0xFF) << 32) + ((long)(ch3 & 0xFF) << 40) + ((long)(ch2 & 0xFF) << 48) + ((long)ch1 << 56);
        }

        public Long[] readLongArray(byte[] b, int length, Offset offset) {
            Long[] res = new Long[length];
            int i = 0;
            while (i < length) {
                res[i] = new Long(this.readLong(b, offset));
                ++i;
            }
            return res;
        }

        public void setCpuFrequency(long frequency) {
            this.cpuFrequency = frequency;
        }

        public double readTimestamp(byte[] b, Offset offset) {
            long value = this.readLong(b, offset);
            if (this.cpuFrequency > 0L) {
                value /= this.cpuFrequency;
            }
            double high = value / 1000000000L;
            double low = (double)(value % 1000000000L) * 1.0E-9;
            double result = high + low;
            return result;
        }

        public String readTimestampAsString(byte[] b, Offset offset) {
            long value = this.readLong(b, offset);
            String integer = Long.toString(value / 1000000000L);
            String remainder = Long.toString(Math.abs(value % 1000000000L));
            remainder = new StringBuffer().append("000000000").replace(9 - remainder.length(), 10, remainder).toString();
            return String.valueOf(integer) + "." + remainder;
        }
    };
    public static final NumberReader LE_64_READER = new NumberReader(){
        private long cpuFrequency;

        public short readShort(byte[] b, Offset offset) {
            int start = offset.getOffset();
            if (offset.increaseOffset(2) < 0) {
                return 0;
            }
            byte ch1 = b[start];
            byte ch2 = b[start + 1];
            return (short)((ch2 << 8) + (ch1 << 0));
        }

        public int readUnsignedShort(byte[] b, Offset offset) {
            int start = offset.getOffset();
            if (offset.increaseOffset(2) < 0) {
                return 0;
            }
            int ch1 = b[start] & 0xFF;
            int ch2 = b[start + 1] & 0xFF;
            return (ch2 << 8) + (ch1 << 0);
        }

        public int readInt(byte[] b, Offset offset) {
            int start = offset.getOffset();
            if (offset.increaseOffset(4) < 0) {
                return 0;
            }
            byte ch1 = b[start];
            byte ch2 = b[start + 1];
            byte ch3 = b[start + 2];
            byte ch4 = b[start + 3];
            return (ch4 << 24) + (ch3 << 16) + (ch2 << 8) + (ch1 << 0);
        }

        public long readUnsignedInt(byte[] b, Offset offset) {
            int start = offset.getOffset();
            if (offset.increaseOffset(4) < 0) {
                return 0L;
            }
            int ch1 = b[start] & 0xFF;
            int ch2 = b[start + 1] & 0xFF;
            int ch3 = b[start + 2] & 0xFF;
            int ch4 = b[start + 3] & 0xFF;
            return (ch4 << 24) + (ch3 << 16) + (ch2 << 8) + (ch1 << 0);
        }

        public long readLong(byte[] b, Offset offset) {
            int start = offset.getOffset();
            if (offset.increaseOffset(8) < 0) {
                return 0L;
            }
            byte ch1 = b[start];
            byte ch2 = b[start + 1];
            byte ch3 = b[start + 2];
            byte ch4 = b[start + 3];
            byte ch5 = b[start + 4];
            byte ch6 = b[start + 5];
            byte ch7 = b[start + 6];
            byte ch8 = b[start + 7];
            return ((long)ch8 << 56) + ((long)(ch7 & 0xFF) << 48) + ((long)(ch6 & 0xFF) << 40) + ((long)(ch5 & 0xFF) << 32) + ((long)(ch4 & 0xFF) << 24) + (long)((ch3 & 0xFF) << 16) + (long)((ch2 & 0xFF) << 8) + (long)((ch1 & 0xFF) << 0);
        }

        public Long[] readLongArray(byte[] b, int length, Offset offset) {
            Long[] res = new Long[length];
            int i = 0;
            while (i < length) {
                res[i] = new Long(this.readLong(b, offset));
                ++i;
            }
            return res;
        }

        public void setCpuFrequency(long frequency) {
            this.cpuFrequency = frequency;
        }

        public double readTimestamp(byte[] b, Offset offset) {
            long value = this.readLong(b, offset);
            if (this.cpuFrequency > 0L) {
                value /= this.cpuFrequency;
            }
            double high = value / 1000000000L;
            double low = (double)(value % 1000000000L) * 1.0E-9;
            double result = high + low;
            return result;
        }

        public String readTimestampAsString(byte[] b, Offset offset) {
            long value = this.readLong(b, offset);
            String integer = Long.toString(value / 1000000000L);
            String remainder = Long.toString(Math.abs(value % 1000000000L));
            remainder = new StringBuffer().append("000000000").replace(9 - remainder.length(), 10, remainder).toString();
            return String.valueOf(integer) + "." + remainder;
        }
    };
    private NumberReader numberReader;
    private StringReader stringReader;

    public BFReader(NumberReader numberReader, StringReader stringReader) {
        this.numberReader = numberReader;
        this.stringReader = stringReader;
    }

    public BFReader() {
        this(LE_64_READER, ASCII_READER);
    }

    public NumberReader getNumberReader() {
        return this.numberReader;
    }

    public void setNumberReader(NumberReader numberReader) {
        this.numberReader = numberReader;
    }

    public StringReader getStringReader() {
        return this.stringReader;
    }

    public void setStringReader(StringReader stringReader) {
        this.stringReader = stringReader;
    }

    public String readString(byte[] b, Offset offset) {
        return this.stringReader.readString(b, offset);
    }

    public String[] readStringArray(byte[] b, int length, Offset offset) {
        return this.stringReader.readStringArray(b, length, offset);
    }

    public byte readByte(byte[] b, Offset offset) {
        int start = offset.getOffset();
        if (offset.increaseOffset(1) < 0) {
            return 0;
        }
        return b[start];
    }

    public short readShort(byte[] b, Offset offset) {
        return this.numberReader.readShort(b, offset);
    }

    public int readUnsignedShort(byte[] b, Offset offset) {
        return this.numberReader.readUnsignedShort(b, offset);
    }

    public int readInt(byte[] b, Offset offset) {
        return this.numberReader.readInt(b, offset);
    }

    public long readUnsignedInt(byte[] b, Offset offset) {
        return this.numberReader.readUnsignedInt(b, offset);
    }

    public long readLong(byte[] b, Offset offset) {
        return this.numberReader.readLong(b, offset);
    }

    public Long[] readLongArray(byte[] b, int length, Offset offset) {
        return this.numberReader.readLongArray(b, length, offset);
    }

    public double readTimestamp(byte[] b, Offset offset) {
        return this.numberReader.readTimestamp(b, offset);
    }

    public String readTimestampAsString(byte[] b, Offset offset) {
        return this.numberReader.readTimestampAsString(b, offset);
    }

    public void setCpuFrequency(long frequency) {
        this.numberReader.setCpuFrequency(frequency);
    }

    public void setEncoding(String encoding) {
        this.stringReader.setEncoding(encoding);
    }
}

