/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.internal.binary.v1;

import org.eclipse.hyades.loaders.internal.binary.BFReader;
import org.eclipse.hyades.loaders.internal.binary.BinaryFragment;
import org.eclipse.hyades.loaders.internal.binary.BinaryFragmentParser;
import org.eclipse.hyades.loaders.internal.binary.Offset;
import org.eclipse.hyades.loaders.util.BinaryFragmentLoader;

public class BFMonNotifyCalledParser
extends BinaryFragmentParser {
    public static final Short ID = new Short(1042);
    public static final String NAME = "monNotifyCalled";

    public BFMonNotifyCalledParser() {
        super(ID, NAME);
    }

    protected BFMonNotifyCalledParser(Short id, String name) {
        super(id, name);
    }

    public boolean parse(BinaryFragment fragment, Offset offset, BFReader reader) {
        byte[] data = fragment.getBody();
        BinaryFragmentLoader loader = this.getLoader();
        loader.addAttribute("threadIdRef", (int)reader.readLong(data, offset));
        loader.addAttribute("time", reader.readTimestampAsString(data, offset));
        loader.addAttribute("objIdRef", reader.readLong(data, offset));
        loader.addAttribute("isNotifyAll", reader.readByte(data, offset));
        long stackDepth = reader.readUnsignedInt(data, offset);
        Object[] stackMethods = reader.readStringArray(data, (int)stackDepth, offset);
        this.addAnnotation(loader, stackMethods, "callStackDumpMethods");
        Object[] stackLines = reader.readLongArray(data, (int)stackDepth, offset);
        this.addAnnotation(loader, stackLines, "callStackDumpLineNumbers");
        return true;
    }
}

