/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.hyades.loaders.util.GenericLookUpEntry;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LookupService;
import org.eclipse.hyades.models.hierarchy.util.IntToObjectMap;
import org.eclipse.hyades.models.hierarchy.util.LongToObjectMap;
import org.eclipse.hyades.models.util.ModelDebugger;

public abstract class GenericLookupService
extends HashMap
implements LookupService {
    protected static final long serialVersionUID = 751323724557818365L;
    protected HashSet types = new HashSet();

    public final Set getSupportedTypes() {
        return this.types;
    }

    public boolean deregister(HierarchyContext context, Class type, Object key) {
        Map map = this.getTypeMap(context, type, false);
        if (map == null) {
            return false;
        }
        return map.remove(key) != null;
    }

    public final boolean deregister(HierarchyContext context, Object object) {
        if (object == null) {
            return false;
        }
        return this.processObject(context, object, true, false);
    }

    public Object locate(HierarchyContext context, Class type, Object key) {
        Map map = this.getTypeMap(context, type, false);
        if (map == null) {
            return null;
        }
        return map.get(key);
    }

    public Object locate(HierarchyContext context, Object key) {
        Map contextMap;
        Object o;
        block4: {
            o = null;
            contextMap = this.getContextMap(context, false);
            if (contextMap != null) break block4;
            return null;
        }
        try {
            for (Map typeMap : contextMap.values()) {
                o = typeMap.get(key);
                if (o == null) continue;
                return o;
            }
        }
        catch (Exception e) {
            ModelDebugger.log(e);
        }
        return o;
    }

    public final boolean register(HierarchyContext context, Object object) {
        if (object == null) {
            return false;
        }
        return this.processObject(context, object, false, true);
    }

    public boolean deregister(HierarchyContext context, Class type) {
        Map typeMap = this.getTypeMap(context, type, false);
        if (typeMap != null) {
            typeMap.clear();
            return true;
        }
        return false;
    }

    public boolean deregister(HierarchyContext context) {
        Map contextMap = this.getContextMap(context, false);
        if (contextMap != null) {
            contextMap.clear();
            return true;
        }
        return false;
    }

    protected Map getContextMap(HierarchyContext context, boolean createMap) {
        if (context == null) {
            return this;
        }
        HashMap contextMap = null;
        try {
            contextMap = (HashMap)this.get(context.getContextURI());
            if (contextMap == null && createMap) {
                contextMap = new HashMap();
                this.put(context.getContextURI(), contextMap);
            }
        }
        catch (Exception exception) {}
        return contextMap;
    }

    protected abstract boolean doProcessObject(Map var1, Class var2, Object var3, boolean var4);

    protected final void addOrRemove(Map map, Object key, Object object, boolean remove) {
        if (remove) {
            map.remove(key);
        } else {
            map.put(key, object);
        }
    }

    protected final void addOrRemove(IntToObjectMap map, int key, Object object, boolean remove) {
        if (remove) {
            map.remove(key);
        } else {
            map.put(key, object);
        }
    }

    protected final void addOrRemove(LongToObjectMap map, long key, Object object, boolean remove) {
        if (remove) {
            map.remove(key);
        } else {
            map.put(key, object);
        }
    }

    protected Map getTypeMap(HierarchyContext context, Class type, boolean create) {
        Class equivalentType = null;
        if (!this.types.contains(type)) {
            equivalentType = this.getEquivalentClass(type);
            if (equivalentType == type) {
                return null;
            }
            create = true;
            this.types.add(type);
        }
        Map typeMap = null;
        try {
            Map contextMap = this.getContextMap(context, create);
            if (contextMap != null && (typeMap = (Map)contextMap.get(type)) == null && create) {
                if (equivalentType != null) {
                    typeMap = (Map)contextMap.get(equivalentType);
                    if (typeMap == null) {
                        typeMap = this.createMap(equivalentType);
                        contextMap.put(equivalentType, typeMap);
                    }
                    contextMap.put(type, typeMap);
                } else {
                    equivalentType = this.getEquivalentClass(type);
                    if (equivalentType != type) {
                        typeMap = (Map)contextMap.get(equivalentType);
                        if (typeMap == null) {
                            typeMap = this.createMap(equivalentType);
                            contextMap.put(equivalentType, typeMap);
                        }
                    } else {
                        typeMap = this.createMap(type);
                    }
                    contextMap.put(type, typeMap);
                }
            }
        }
        catch (Exception e) {
            ModelDebugger.log(e);
        }
        return typeMap;
    }

    protected Map createMap(Class equivalentType) {
        return new HashMap();
    }

    protected Class getEquivalentClass(Class type) {
        return type;
    }

    protected boolean processObject(HierarchyContext context, Object object, boolean remove, boolean createMap) {
        boolean ret = false;
        Class<?> theClass = object.getClass();
        if (theClass == GenericLookUpEntry.class) {
            GenericLookUpEntry entry = (GenericLookUpEntry)object;
            Map typeMap = this.getTypeMap(context, entry.getValue().getClass(), createMap);
            if (typeMap == null) {
                return false;
            }
            if (typeMap instanceof IntToObjectMap) {
                this.addOrRemove((IntToObjectMap)typeMap, (Integer)entry.getKey(), entry.getValue(), remove);
            } else if (typeMap instanceof LongToObjectMap) {
                this.addOrRemove((LongToObjectMap)typeMap, (Long)entry.getKey(), entry.getValue(), remove);
            } else {
                this.addOrRemove(typeMap, entry.getKey(), entry.getValue(), remove);
            }
            return true;
        }
        Map typeMap = this.getTypeMap(context, theClass, createMap);
        if (typeMap == null) {
            return false;
        }
        try {
            ret = this.doProcessObject(typeMap, theClass, object, remove);
        }
        catch (Exception e) {
            ModelDebugger.log(e);
        }
        return ret;
    }
}

