/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.Random;

public final class Guid {
    protected int timeLow = 0;
    protected short timeMiddle = 0;
    protected short timeHighWithVersion = 0;
    protected byte clockSequenceHighWithReserved = 0;
    protected byte clockSequenceLow = 0;
    protected static long lastTimeStamp = 0L;
    protected static long clockSequence = 0L;
    protected static int clockSequenceAdjustment = 0;
    protected static byte[] pseudoIEEE802MACAddress = null;
    protected static Random randomNumberGenerator = null;
    protected static boolean isInitialized = false;
    protected static final char[] HEXADECIMAL_CHARACTERS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    protected static final Object LOCK = new Object();
    protected static final String TEMPORARY_DIRECTORY = System.getProperty("java.io.tmpdir");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Guid() {
        long adjustedTimestamp = 0L;
        Object object = LOCK;
        synchronized (object) {
            if (!isInitialized) {
                long uniqueTimeStamp = this.getUniqueTimeStamp();
                pseudoIEEE802MACAddress = this.getPseudoIEEE802MACAddress(uniqueTimeStamp);
                try {
                    randomNumberGenerator = SecureRandom.getInstance("MD5");
                    randomNumberGenerator.setSeed(uniqueTimeStamp);
                }
                catch (Throwable throwable) {
                    randomNumberGenerator = new Random(uniqueTimeStamp);
                }
                clockSequence = randomNumberGenerator.nextLong();
                isInitialized = true;
            }
            boolean timeIsValid = true;
            do {
                if ((adjustedTimestamp = this.getAdjustedTimestamp()) < lastTimeStamp) {
                    clockSequence = randomNumberGenerator.nextLong();
                    clockSequenceAdjustment = 0;
                }
                if (adjustedTimestamp > lastTimeStamp) {
                    clockSequenceAdjustment = 0;
                }
                if (adjustedTimestamp != lastTimeStamp) continue;
                if (clockSequenceAdjustment < 9999) {
                    ++clockSequenceAdjustment;
                    continue;
                }
                timeIsValid = false;
            } while (!timeIsValid);
            lastTimeStamp = adjustedTimestamp;
            if (clockSequenceAdjustment != 0) {
                adjustedTimestamp += (long)clockSequenceAdjustment;
            }
            this.timeLow = (int)(adjustedTimestamp & 0xFFFFFFFFFFFFFFFFL);
            this.timeMiddle = (short)(adjustedTimestamp >>> 32 & 0xFFFFL);
            this.timeHighWithVersion = (short)((short)(adjustedTimestamp >>> 48 & 0xFFFL) | 0xFFFFA000);
            this.clockSequenceLow = (byte)(clockSequence & 0xFFL);
            this.clockSequenceHighWithReserved = (byte)((byte)((clockSequence & 0x3F00L) >>> 8) | 0xFFFFFFC0);
        }
    }

    public String toString() {
        char[] stringBuffer = new char[32];
        int pos = 0;
        int shift = 12;
        while (pos < 4) {
            stringBuffer[pos] = HEXADECIMAL_CHARACTERS[this.timeHighWithVersion >>> shift & 0xF];
            shift -= 4;
            ++pos;
        }
        shift = 12;
        while (pos < 8) {
            stringBuffer[pos] = HEXADECIMAL_CHARACTERS[this.timeMiddle >>> shift & 0xF];
            shift -= 4;
            ++pos;
        }
        shift = 28;
        while (pos < 16) {
            stringBuffer[pos] = HEXADECIMAL_CHARACTERS[this.timeLow >>> shift & 0xF];
            shift -= 4;
            ++pos;
        }
        stringBuffer[pos++] = HEXADECIMAL_CHARACTERS[this.clockSequenceHighWithReserved >>> 4 & 0xF];
        stringBuffer[pos++] = HEXADECIMAL_CHARACTERS[this.clockSequenceHighWithReserved & 0xF];
        stringBuffer[pos++] = HEXADECIMAL_CHARACTERS[this.clockSequenceLow >>> 4 & 0xF];
        stringBuffer[pos++] = HEXADECIMAL_CHARACTERS[this.clockSequenceLow & 0xF];
        int i = 0;
        while (pos < 32) {
            stringBuffer[pos] = HEXADECIMAL_CHARACTERS[pseudoIEEE802MACAddress[i] >>> 4 & 0xF];
            stringBuffer[pos + 1] = HEXADECIMAL_CHARACTERS[pseudoIEEE802MACAddress[i] & 0xF];
            ++i;
            pos += 2;
        }
        return new String(stringBuffer).trim();
    }

    protected synchronized byte[] getPseudoIEEE802MACAddress(long uniqueTimeStamp) {
        byte[] ieee802Addr = new byte[6];
        byte[] currentTime = String.valueOf(uniqueTimeStamp).getBytes();
        byte[] localHostAddress = null;
        try {
            localHostAddress = InetAddress.getLocalHost().getAddress();
        }
        catch (UnknownHostException unknownHostException) {
            byte[] byArray = new byte[4];
            byArray[0] = 127;
            byArray[3] = 1;
            localHostAddress = byArray;
        }
        byte[] inMemoryObject = Integer.toHexString(new Object().hashCode()).getBytes();
        byte[] freeMemory = String.valueOf(Runtime.getRuntime().freeMemory()).getBytes();
        byte[] totalMemory = String.valueOf(Runtime.getRuntime().totalMemory()).getBytes();
        byte[] messageDigestInput = new byte[currentTime.length + localHostAddress.length + inMemoryObject.length + freeMemory.length + totalMemory.length];
        int messageDigestInputIndex = 0;
        System.arraycopy(currentTime, 0, messageDigestInput, messageDigestInputIndex, currentTime.length);
        System.arraycopy(localHostAddress, 0, messageDigestInput, messageDigestInputIndex += currentTime.length, localHostAddress.length);
        System.arraycopy(inMemoryObject, 0, messageDigestInput, messageDigestInputIndex += localHostAddress.length, inMemoryObject.length);
        System.arraycopy(freeMemory, 0, messageDigestInput, messageDigestInputIndex += inMemoryObject.length, freeMemory.length);
        System.arraycopy(totalMemory, 0, messageDigestInput, messageDigestInputIndex += freeMemory.length, totalMemory.length);
        int hashCode = 0;
        int counter = 0;
        while (counter < messageDigestInput.length) {
            byte[] hashCodeBytes = Integer.toHexString(hashCode = 31 * hashCode + messageDigestInput[counter]).getBytes();
            if (hashCodeBytes.length < 6) {
                System.arraycopy(hashCodeBytes, 0, ieee802Addr, 6 - hashCodeBytes.length, hashCodeBytes.length);
            } else {
                System.arraycopy(hashCodeBytes, hashCodeBytes.length - 6, ieee802Addr, 0, 6);
            }
            ++counter;
        }
        ieee802Addr[0] = (byte)(ieee802Addr[0] | 0x80);
        return ieee802Addr;
    }

    protected synchronized long getAdjustedTimestamp() {
        return System.currentTimeMillis() * 10000L + 122192928000000000L;
    }

    /*
     * Exception decompiling
     */
    protected synchronized long getUniqueTimeStamp() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String generate() {
        return new Guid().toString();
    }
}

