/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.util;

import java.util.Map;
import org.eclipse.hyades.loaders.util.AgentProxyContext;
import org.eclipse.hyades.loaders.util.AgentsContext;
import org.eclipse.hyades.loaders.util.GenericLookupService;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.CorrelationEngine;
import org.eclipse.hyades.models.hierarchy.UnresolvedCorrelation;
import org.eclipse.hyades.models.hierarchy.impl.UnresolvedCorrelationImpl;

public class HierarchyLookupService
extends GenericLookupService {
    protected static final long serialVersionUID = 3258128059566405431L;

    public HierarchyLookupService() {
        this.types.add(AgentsContext.class);
        this.types.add(AgentProxyContext.class);
        this.types.add(HierarchyContext.class);
        this.types.add(UnresolvedCorrelationImpl.class);
        this.types.add(CorrelationEngine.class);
    }

    protected boolean doProcessObject(Map typeMap, Class type, Object object, boolean remove) {
        if (object == null) {
            return false;
        }
        if (type == HierarchyContext.class) {
            HierarchyContext c = (HierarchyContext)object;
            String uri = c.getContextURI();
            if (uri != null) {
                this.addOrRemove(typeMap, uri, object, remove);
                return true;
            }
        } else {
            if (type == AgentsContext.class) {
                this.addOrRemove(typeMap, LoadersUtils.getLookUpKey(((AgentsContext)object).getId()), object, remove);
                return true;
            }
            if (type == AgentProxyContext.class) {
                AgentProxyContext c = (AgentProxyContext)object;
                if (c.getAgentProxy() != null) {
                    this.addOrRemove(typeMap, LoadersUtils.getLookUpKey(c.getAgentProxy().hashCode()), object, remove);
                    return true;
                }
            } else {
                UnresolvedCorrelation c;
                if (type == CorrelationEngine.class) {
                    CorrelationEngine c2 = (CorrelationEngine)object;
                    this.addOrRemove(typeMap, c2.getId(), object, remove);
                    return true;
                }
                if (type == UnresolvedCorrelationImpl.class && (c = (UnresolvedCorrelation)object).getContextId() != null) {
                    this.addOrRemove(typeMap, c.getContextId(), object, remove);
                    return true;
                }
            }
        }
        return false;
    }
}

