/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.util;

import org.eclipse.hyades.loaders.util.HyadesConfigurationElement;
import org.eclipse.hyades.loaders.util.IHyadesPluginClassDescriptor;
import org.eclipse.hyades.loaders.util.LoaderExtensions;
import org.eclipse.hyades.loaders.util.RegistryReader;
import org.eclipse.hyades.loaders.util.XMLFragmentLoader;

class LoaderRegistryReader
extends RegistryReader {
    static final String TAG_LOADER = "loader";
    static final String ATT_ELEMENT_NAME = "elementName";

    public LoaderRegistryReader() {
        super("fragment_loader");
    }

    protected boolean readElement(HyadesConfigurationElement element) {
        if (element.getName().equals(TAG_LOADER)) {
            String elementName = element.getAttribute(ATT_ELEMENT_NAME);
            if (elementName == null) {
                this.logMissingAttribute(element, ATT_ELEMENT_NAME);
            } else if (element.getAttribute("class") == null) {
                this.logMissingAttribute(element, "class");
            } else {
                float priority = 0.0f;
                if (element.getAttribute("priority") != null) {
                    priority = Float.parseFloat(element.getAttribute("priority"));
                }
                if (LoaderExtensions.getInstance().containsKey(elementName) && ((Float)this.getPriorities().get(elementName)).floatValue() >= priority) {
                    this.logError(element, "A loader for this element with a higher or equal priority already exists, loader \"" + element.getAttribute("class") + "\" will be ignored for elementName \"" + elementName + "\".");
                } else {
                    try {
                        IHyadesPluginClassDescriptor classDescriptor = this.createPluginClassDescriptor(element, "class");
                        LoaderExtensions.getInstance().put(elementName, (XMLFragmentLoader)classDescriptor.createInstance());
                        this.getPriorities().put(elementName, new Float(priority));
                    }
                    catch (Exception e) {
                        this.logError(element, e.getLocalizedMessage());
                    }
                }
                return true;
            }
        }
        return false;
    }
}

