/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.loaders.util.HyadesConfigurationElement;
import org.eclipse.hyades.loaders.util.IHyadesPluginClassDescriptor;
import org.eclipse.hyades.loaders.util.PlatformPluginClassDescriptor;
import org.eclipse.hyades.loaders.util.StandalonePluginClassDescriptor;
import org.eclipse.hyades.models.hierarchy.util.XMLUtil;
import org.eclipse.hyades.models.util.ModelDebugger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class RegistryReader {
    public static final String ECLIPSE_TPTP_APPLICATION_WORKSPACE_MODE = "eclipse.tptp.application.workspace.mode";
    public static StandaloneConfiguration standaloneConfiguration;
    protected static int platformMode;
    protected static int workspaceMode;
    protected static int rcpMode;
    protected static final String TAG_DESCRIPTION = "description";
    protected static final String LOADER_PPID = "fragment_loader";
    protected static final String HANDLER_PPID = "fragment_handler";
    protected static final String LOADERS_FACTORY_PPID = "fragment_loaders_factory";
    protected static final String RESOURCE_LOADER_PPID = "resource_loader";
    protected static final String LOOKUP_SERVICE_PPID = "lookup_service";
    protected static final String HYADES_RESOURCE_EXTENSION_PPID = "hyades_resource_extension";
    protected static final String DATABASE_EXTENSIONS_PPID = "database_extensions";
    protected static final String GENERIC_HANDLER_PPID = "handler";
    protected String thisPluginId = "org.eclipse.tptp.platform.models";
    protected Map priorities;
    protected static final String ATT_PRIORITY = "priority";
    protected static final String ATT_CLASS = "class";
    protected List alreadyProcessedEclipseFolders;
    protected String extensionPointID;
    protected Properties pluginCustomization;

    static {
        platformMode = 0;
        workspaceMode = 0;
        rcpMode = 0;
    }

    public RegistryReader(String extensionPointID) {
        this.extensionPointID = extensionPointID;
    }

    public RegistryReader(String pluginId, String extensionPointID) {
        this.extensionPointID = extensionPointID;
        this.thisPluginId = pluginId;
    }

    public Map getPriorities() {
        if (this.priorities == null) {
            this.priorities = new HashMap();
        }
        return this.priorities;
    }

    public static synchronized boolean isPlatformMode() {
        if (platformMode == 0) {
            RegistryReader.setPlatformMode();
            if (platformMode == 1) {
                RegistryReader.setWorkspaceMode();
            } else {
                workspaceMode = 2;
            }
        }
        return platformMode == 1;
    }

    public static synchronized void setPlatformMode(int mode) {
        platformMode = mode;
    }

    public static synchronized boolean isWorkspaceMode() {
        if (workspaceMode == 0) {
            RegistryReader.setPlatformMode();
            if (platformMode == 1) {
                RegistryReader.setWorkspaceMode();
            } else {
                workspaceMode = 2;
            }
        }
        return workspaceMode == 1;
    }

    public static synchronized boolean isRCPMode() {
        if (rcpMode == 0) {
            String app;
            rcpMode = RegistryReader.isPlatformMode() ? ((app = System.getProperty("eclipse.application")) != null && !app.equalsIgnoreCase("org.eclipse.ui.ide.workbench") ? 1 : (workspaceMode != 1 ? 1 : 2)) : 2;
        }
        return rcpMode == 1;
    }

    protected static void setWorkspaceMode() {
        try {
            String applicationMode = System.getProperty(ECLIPSE_TPTP_APPLICATION_WORKSPACE_MODE);
            if ("false".equalsIgnoreCase(applicationMode)) {
                workspaceMode = 2;
                return;
            }
            Class<?> resourcePlugin = Class.forName("org.eclipse.core.resources.ResourcesPlugin");
            Method getWorkspace = resourcePlugin.getMethod("getWorkspace", null);
            Object workspace = getWorkspace.invoke(null, null);
            Method getRoot = workspace.getClass().getMethod("getRoot", null);
            Object root = getRoot.invoke(workspace, null);
            workspaceMode = root != null ? 1 : 2;
        }
        catch (ClassNotFoundException classNotFoundException) {
            workspaceMode = 2;
        }
        catch (SecurityException securityException) {
            workspaceMode = 2;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            workspaceMode = 2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            workspaceMode = 2;
        }
        catch (IllegalAccessException illegalAccessException) {
            workspaceMode = 2;
        }
        catch (InvocationTargetException invocationTargetException) {
            workspaceMode = 2;
        }
        catch (NullPointerException nullPointerException) {
            workspaceMode = 2;
        }
    }

    public IHyadesPluginClassDescriptor createPluginClassDescriptor(HyadesConfigurationElement element, String attribute) {
        if (RegistryReader.isPlatformMode()) {
            return new PlatformPluginClassDescriptor((IConfigurationElement)element.getElement(), attribute);
        }
        return new StandalonePluginClassDescriptor((Node)element.getElement(), attribute);
    }

    public void readRegistry() {
        if (RegistryReader.isPlatformMode()) {
            this.platformReadRegistry();
        } else {
            this.standaloneReadRegistry();
        }
    }

    protected void logError(HyadesConfigurationElement element, String text) {
        ModelDebugger.log("Plugin " + element.getDeclaringExtensionName() + ", extension " + element.getAttribute(ATT_CLASS) + "\n" + text);
    }

    protected void logMissingAttribute(HyadesConfigurationElement element, String attributeName) {
        this.logError(element, "The required attribute '" + attributeName + "' not defined");
    }

    protected abstract boolean readElement(HyadesConfigurationElement var1);

    protected static void setPlatformMode() {
        try {
            Class<?> platform = Class.forName("org.eclipse.core.runtime.Platform");
            Method isRunning = platform.getMethod("isRunning", null);
            Boolean value = (Boolean)isRunning.invoke(null, null);
            platformMode = value != false ? 1 : 2;
        }
        catch (ClassNotFoundException classNotFoundException) {
            platformMode = 2;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            platformMode = 2;
        }
        catch (SecurityException securityException) {
            platformMode = 2;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            platformMode = 2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            platformMode = 2;
        }
        catch (IllegalAccessException illegalAccessException) {
            platformMode = 2;
        }
        catch (InvocationTargetException invocationTargetException) {
            platformMode = 2;
        }
        catch (NullPointerException nullPointerException) {
            platformMode = 2;
        }
    }

    protected void addPackageExtensionPoints() {
        for (HyadesConfigurationElement element : standaloneConfiguration.getExtensionsList()) {
            if (!element.getDeclaringExtensionName().equals("org.eclipse.emf.ecore.generated_package")) continue;
            try {
                String emfPackageClassName = element.getAttribute(ATT_CLASS);
                if (standaloneConfiguration.getEmfPackageClassesList().contains(emfPackageClassName)) continue;
                standaloneConfiguration.getEmfPackageClassesList().add(emfPackageClassName);
            }
            catch (RuntimeException e) {
                ModelDebugger.log(e);
            }
        }
    }

    protected void internalReadElement(HyadesConfigurationElement element) {
        boolean recognized = this.readElement(element);
        if (recognized) {
            HyadesConfigurationElement[] children = element.getChildren();
            int i = 0;
            while (i < children.length) {
                this.internalReadElement(children[i]);
                ++i;
            }
        } else {
            this.logError(element, "Error processing extension: " + element.getDeclaringExtensionName());
        }
    }

    protected void platformReadRegistry() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(this.thisPluginId, this.extensionPointID);
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                this.internalReadElement(new HyadesConfigurationElement(elements[i]));
                ++i;
            }
        }
    }

    protected void processEMFpackages() {
        this.addPackageExtensionPoints();
        for (String element : standaloneConfiguration.getEmfPackageClassesList()) {
            try {
                Class<?> clazz = Class.forName(element);
                try {
                    Field field = clazz.getField("eINSTANCE");
                    field.get(null);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    Method method = clazz.getMethod("init", null);
                    method.invoke(null, null);
                }
            }
            catch (ClassNotFoundException e) {
                ModelDebugger.log(e);
            }
            catch (SecurityException e) {
                ModelDebugger.log(e);
            }
            catch (NoSuchMethodException e) {
                ModelDebugger.log(e);
            }
            catch (IllegalArgumentException e) {
                ModelDebugger.log(e);
            }
            catch (IllegalAccessException e) {
                ModelDebugger.log(e);
            }
            catch (InvocationTargetException e) {
                ModelDebugger.log(e);
            }
        }
    }

    protected void processEclipseFolder() {
        String eclipseFolder = standaloneConfiguration.getEclipseFolder();
        this.processEclipseFolder(eclipseFolder);
        File linksFolder = new File(String.valueOf(eclipseFolder) + "/links");
        if (linksFolder.exists()) {
            this.processLinksFolder(linksFolder);
        }
    }

    protected void processEclipseFolder(String eclipseFolder) {
        if (eclipseFolder != null) {
            if (this.alreadyProcessedEclipseFolders.contains(eclipseFolder)) {
                return;
            }
            this.alreadyProcessedEclipseFolders.add(eclipseFolder);
            File folder = new File(String.valueOf(eclipseFolder) + "/plugins");
            if (folder.exists()) {
                File[] folders = folder.listFiles();
                int i = folders.length - 1;
                while (i >= 0) {
                    File pluginFile = new File(String.valueOf(folders[i].getAbsolutePath()) + "/plugin.xml");
                    if (pluginFile.exists()) {
                        String pluginXMLFileName = pluginFile.getAbsolutePath();
                        if (!standaloneConfiguration.getPluginsXMLFiles().contains(pluginXMLFileName)) {
                            standaloneConfiguration.getPluginsXMLFiles().add(pluginXMLFileName);
                        }
                    }
                    --i;
                }
            }
        }
    }

    protected void processExtensions() {
        for (HyadesConfigurationElement element : standaloneConfiguration.getExtensionsList()) {
            if (!element.getDeclaringExtensionName().endsWith("." + this.extensionPointID)) continue;
            this.internalReadElement(element);
        }
    }

    protected void processLinksFolder(File linksFolder) {
        File[] files = linksFolder.listFiles(new FilenameFilter(){

            public boolean accept(File arg0, String arg1) {
                return arg1.endsWith(".link");
            }
        });
        int i = files.length - 1;
        while (i >= 0) {
            try {
                String line;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(files[i]));
                while ((line = bufferedReader.readLine()) != null) {
                    if (!line.startsWith("path=")) continue;
                    line = line.substring("path=".length()).trim();
                    this.processEclipseFolder(String.valueOf(line) + "/eclipse");
                }
                bufferedReader.close();
            }
            catch (FileNotFoundException e) {
                ModelDebugger.log(e);
            }
            catch (IOException e) {
                ModelDebugger.log(e);
            }
            --i;
        }
    }

    protected void processPluginXMLFiles() {
        ArrayList<String> alredyProcessed = new ArrayList<String>();
        Iterator iter = standaloneConfiguration.getPluginsXMLFiles().iterator();
        while (iter.hasNext()) {
            try {
                String element = (String)iter.next();
                if (alredyProcessed.contains(element)) continue;
                alredyProcessed.add(element);
                Document document = XMLUtil.getXmlDom(element);
                NodeList nodeList = document.getElementsByTagName("extension");
                int i = nodeList.getLength() - 1;
                while (i >= 0) {
                    Node extension = nodeList.item(i);
                    standaloneConfiguration.getExtensionsList().add(new HyadesConfigurationElement(extension));
                    --i;
                }
            }
            catch (RuntimeException e) {
                ModelDebugger.log(e);
            }
        }
    }

    protected synchronized void standaloneReadRegistry() {
        if (standaloneConfiguration != null) {
            if (!standaloneConfiguration.isAlreadyProcessed()) {
                this.alreadyProcessedEclipseFolders = new ArrayList();
                this.processEclipseFolder();
                this.processPluginXMLFiles();
                this.processEMFpackages();
                this.processPluginCustomization();
                RegistryReader.standaloneConfiguration.alreadyProcessed = true;
            }
            this.processExtensions();
        }
    }

    protected void processPluginCustomization() {
        if (standaloneConfiguration.getPluginCustomizationLocation() != null) {
            try {
                this.pluginCustomization = new Properties();
                this.pluginCustomization.load(new FileInputStream(standaloneConfiguration.getPluginCustomizationLocation()));
            }
            catch (Exception e) {
                ModelDebugger.log(e, "Error parsing plugin_cusomization.ini file: " + standaloneConfiguration.getPluginCustomizationLocation());
            }
        }
    }

    public String getPluginCustomizationString(String bundleSymbolicId, String key) {
        if (this.pluginCustomization != null) {
            return this.pluginCustomization.getProperty(String.valueOf(bundleSymbolicId) + "/" + key);
        }
        return Platform.getPreferencesService().getString(bundleSymbolicId, key, null, null);
    }

    public String getThisPluginId() {
        return this.thisPluginId;
    }

    public void setThisPluginId(String thisPluginId) {
        this.thisPluginId = thisPluginId;
    }

    public String getExtensionPointID() {
        return this.extensionPointID;
    }

    public void setExtensionPointID(String extensionPointID) {
        this.extensionPointID = extensionPointID;
    }

    public static final class StandaloneConfiguration {
        protected List emfPackageClassesList = new ArrayList();
        protected List extensionsList = new ArrayList();
        protected List pluginsXMLFiles = new ArrayList();
        protected String eclipseFolder;
        protected boolean alreadyProcessed = false;
        protected String pluginCustomizationLocation;

        public boolean isAlreadyProcessed() {
            return this.alreadyProcessed;
        }

        public void setEclipseFolder(String string) {
            this.eclipseFolder = string;
        }

        public String getEclipseFolder() {
            return this.eclipseFolder;
        }

        public List getEmfPackageClassesList() {
            return this.emfPackageClassesList;
        }

        public List getExtensionsList() {
            return this.extensionsList;
        }

        public List getPluginsXMLFiles() {
            return this.pluginsXMLFiles;
        }

        public String getPluginCustomizationLocation() {
            return this.pluginCustomizationLocation;
        }

        public void setPluginCustomizationLocation(String pluginCustomizationLocation) {
            this.pluginCustomizationLocation = pluginCustomizationLocation;
        }
    }
}

