/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.util;

import org.eclipse.hyades.loaders.util.HyadesConfigurationElement;
import org.eclipse.hyades.loaders.util.IHyadesPluginClassDescriptor;
import org.eclipse.hyades.loaders.util.RegistryReader;
import org.eclipse.hyades.loaders.util.ResourceExtensions;
import org.eclipse.hyades.loaders.util.XMLResourceLoader;

class ResourceRegistryReader
extends RegistryReader {
    static final String TAG_RESOURCE_LOADER = "resourceLoader";
    static final String ATT_FILE_EXTENSION = "fileExtension";
    static final String ATT_CLASS = "class";

    public ResourceRegistryReader() {
        super("resource_loader");
    }

    protected boolean readElement(HyadesConfigurationElement element) {
        if (element.getName().equals(TAG_RESOURCE_LOADER)) {
            String fileExtension = element.getAttribute(ATT_FILE_EXTENSION);
            if (fileExtension == null) {
                this.logMissingAttribute(element, ATT_FILE_EXTENSION);
            } else if (element.getAttribute(ATT_CLASS) == null) {
                this.logMissingAttribute(element, ATT_CLASS);
            } else if (ResourceExtensions.getInstance().containsKey(fileExtension)) {
                this.logError(element, "A resource loader for this element already exists, this loader will be ignored.");
            } else {
                try {
                    IHyadesPluginClassDescriptor classDescriptor = this.createPluginClassDescriptor(element, ATT_CLASS);
                    ResourceExtensions.getInstance().put(fileExtension, (XMLResourceLoader)classDescriptor.createInstance());
                }
                catch (Exception e) {
                    this.logError(element, e.getLocalizedMessage());
                }
                return true;
            }
        }
        return false;
    }
}

