/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.util;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.eclipse.hyades.loaders.util.IXMLLoader;
import org.eclipse.hyades.loaders.util.InvalidXMLException;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.XMLFragmentHandler;
import org.eclipse.hyades.loaders.util.XMLLoader;
import org.eclipse.hyades.models.util.ModelDebugger;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class SAXFragmentHandler
implements XMLFragmentHandler {
    protected static final char[] END_ELEMENT = "endElement=".toCharArray();
    protected static final char[] START_ELEMENT = "startElement=".toCharArray();
    protected static final char[] START_DOCUMENT = "startDocument=".toCharArray();
    protected static final char[] END_DOCUMENT = "endDocument=".toCharArray();
    protected static final char[] CHARACTERS = "characters=".toCharArray();
    protected InputSource inputSource = null;
    protected InputStream xmlStream = null;
    protected ParserPipedInputStream pipedXmlStream = null;
    protected SAXParser parser;
    protected Thread parseThread;
    protected IXMLLoader handler;
    protected int depth;
    protected boolean initRequired;
    protected static final int WAIT_TIME = 500;
    protected static final char[] WB_IN = "wB>".toCharArray();
    protected static final char[] WB_OUT = "wB<".toCharArray();

    public void setXMLLoader(IXMLLoader loader) {
        this.handler = loader;
        this.initRequired = true;
    }

    public void init() {
        try {
            this.depth = -1;
            this.parser = this.makeParser();
            this.pipedXmlStream = new ParserPipedInputStream(this);
            this.xmlStream = this.pipedXmlStream;
            this.parseThread = new Thread(Thread.currentThread().getThreadGroup(), "xmlParserThread"){

                public void run() {
                    if (SAXFragmentHandler.this.xmlStream == null) {
                        return;
                    }
                    try {
                        SAXFragmentHandler.this.parse(SAXFragmentHandler.this.xmlStream, new RegularHandler());
                    }
                    catch (Exception exception) {}
                    SAXFragmentHandler.this.xmlStream = null;
                }
            };
            this.parseThread.start();
        }
        catch (Exception e) {
            throw new InvalidXMLException(e);
        }
    }

    public void scanContent(byte[] fragment, int offset, int length) throws InvalidXMLException {
        if (this.pipedXmlStream == null) {
            if (this.initRequired) {
                this.init();
            } else {
                return;
            }
        }
        this.pipedXmlStream.writeBuf(fragment, offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminateParser() {
        block10: {
            this.depth = -1;
            if (this.xmlStream != null) {
                try {
                    if (this.pipedXmlStream != null) {
                        if (ModelDebugger.INSTANCE.debug) {
                            ModelDebugger.log("SAXFragmentHandler.terminateParser() - close ParserPipedInputStream");
                        }
                        ParserPipedInputStream temp = this.pipedXmlStream;
                        this.pipedXmlStream = null;
                        temp.makeClosed();
                    }
                    this.xmlStream = null;
                }
                catch (Exception e) {
                    if (!ModelDebugger.INSTANCE.debug) break block10;
                    ModelDebugger.log(e, "SAXFragmentHandler.terminateParser()");
                }
            }
        }
        SAXFragmentHandler sAXFragmentHandler = this;
        synchronized (sAXFragmentHandler) {
            this.notifyAll();
            if (this.parseThread != null) {
                this.parseThread.interrupt();
            }
            if (ModelDebugger.INSTANCE.debug) {
                ModelDebugger.log("SAXFragmentHandler.terminateParser() - done");
            }
        }
    }

    protected SAXParser makeParser() throws ParserConfigurationException, SAXException {
        return XMLLoader.makeParser();
    }

    protected synchronized void parse(InputStream inputStream, DefaultHandler theHandler) throws InvalidXMLException {
        try {
            this.inputSource = new InputSource(inputStream);
            this.parser.parse(this.inputSource, theHandler);
        }
        catch (Exception e) {
            InvalidXMLException i = e instanceof InvalidXMLException ? (InvalidXMLException)e : new InvalidXMLException(e);
            this.handler.error(i);
        }
    }

    public void scanContent(InputStream inputStream, long offset, long length) {
        try {
            this.initRequired = false;
            this.depth = -1;
            this.parser = this.makeParser();
            this.xmlStream = inputStream;
            this.parse(this.xmlStream, new RegularHandler());
        }
        catch (Exception e) {
            InvalidXMLException i = e instanceof InvalidXMLException ? (InvalidXMLException)e : new InvalidXMLException(e);
            this.handler.error(i);
        }
    }

    public class ParserPipedInputStream
    extends InputStream {
        protected byte[] inBuf;
        protected boolean closed = false;
        protected int inCount = 0;
        protected long inTotalLength;
        protected int inPos = 0;
        protected StringBuffer sb = new StringBuffer();

        public ParserPipedInputStream(SAXFragmentHandler handler) {
        }

        protected synchronized void makeOpened() {
            this.inBuf = null;
            this.inCount = 0;
            this.inPos = 0;
            this.closed = false;
            this.notifyAll();
        }

        public synchronized int available() throws IOException {
            this.waitForNewData();
            return this.inCount;
        }

        public void close() throws IOException {
            super.close();
            this.closed = true;
        }

        public synchronized boolean hasEmptyBuffer() {
            return this.inCount == 0;
        }

        public synchronized void mark(int arg0) {
            super.mark(arg0);
        }

        public boolean markSupported() {
            return false;
        }

        public synchronized int read() throws IOException {
            if (this.available() == 0) {
                return -1;
            }
            --this.inCount;
            return this.inBuf[this.inPos++];
        }

        public synchronized int read(byte[] outBuf, int offset, int length) throws IOException {
            if (this.available() == 0) {
                return -1;
            }
            int readBytes = Math.min(this.inCount, length);
            System.arraycopy(this.inBuf, this.inPos, outBuf, offset, readBytes);
            this.inPos += readBytes;
            this.inCount -= readBytes;
            return readBytes;
        }

        public int read(byte[] arg0) throws IOException {
            return this.read(arg0, 0, arg0.length);
        }

        public synchronized void reset() throws IOException {
            super.reset();
        }

        public synchronized long skip(long arg0) throws IOException {
            if ((arg0 += (long)this.inPos) < this.inTotalLength) {
                this.inPos = (int)arg0;
                return arg0;
            }
            return -1L;
        }

        public synchronized void writeBuf(byte[] buf, int offset, int length) {
            if (buf == null || length == 0) {
                return;
            }
            this.inBuf = buf;
            this.inPos = offset;
            this.inTotalLength += (long)length;
            this.inCount = length;
            if (ModelDebugger.INSTANCE.debugEventFlow) {
                System.out.print(WB_IN);
                this.sb.setLength(0);
                this.sb.append(length);
                System.out.println(LoadersUtils.getChars(this.sb));
                System.out.write(buf, offset, length);
                System.out.write(buf, offset, length);
                System.out.println();
            }
            this.notifyAll();
            this.waitForEmptyBuffer();
            if (ModelDebugger.INSTANCE.debugEventFlow) {
                System.out.println(WB_OUT);
            }
        }

        protected synchronized void makeClosed() {
            this.inBuf = null;
            this.inCount = 0;
            this.inPos = 0;
            this.closed = true;
            this.notifyAll();
        }

        protected void waitForEmptyBuffer() {
            while (!this.hasEmptyBuffer() && !this.closed) {
                try {
                    this.wait(500L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    if (!this.hasEmptyBuffer() && !this.closed) continue;
                    return;
                }
            }
        }

        protected synchronized void waitForNewData() {
            boolean notify = true;
            while (this.hasEmptyBuffer()) {
                if (notify) {
                    this.notifyAll();
                    notify = false;
                }
                if (this.closed) {
                    return;
                }
                try {
                    this.wait(500L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    if (!this.closed) continue;
                    return;
                }
            }
        }
    }

    public class RegularHandler
    extends DefaultHandler {
        public void setDocumentLocator(Locator locator) {
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            SAXFragmentHandler.this.handler.characters(ch, start, length);
            if (ModelDebugger.INSTANCE.debugEventFlow) {
                System.out.print(CHARACTERS);
                System.out.println(String.valueOf(length) + "=" + new String(ch, start, length));
            }
        }

        public void endDocument() throws SAXException {
            if (SAXFragmentHandler.this.depth == 0 && SAXFragmentHandler.this.xmlStream != null) {
                if (SAXFragmentHandler.this.pipedXmlStream != null) {
                    SAXFragmentHandler.this.pipedXmlStream.makeClosed();
                    SAXFragmentHandler.this.pipedXmlStream = null;
                }
                SAXFragmentHandler.this.xmlStream = null;
            }
            SAXFragmentHandler.this.depth = -1;
            if (ModelDebugger.INSTANCE.debugEventFlow) {
                System.out.print(END_DOCUMENT);
                System.out.println();
            }
            SAXFragmentHandler.this.handler.endDocument(null, 0);
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (ModelDebugger.INSTANCE.debugEventFlow) {
                System.out.print(END_ELEMENT);
                System.out.println(qName);
            }
            SAXFragmentHandler.this.handler.endElement(qName, 0);
            --SAXFragmentHandler.this.depth;
            if (SAXFragmentHandler.this.depth == 0 && SAXFragmentHandler.this.xmlStream != null) {
                if (SAXFragmentHandler.this.pipedXmlStream != null) {
                    SAXFragmentHandler.this.pipedXmlStream.makeClosed();
                    SAXFragmentHandler.this.pipedXmlStream = null;
                }
                SAXFragmentHandler.this.xmlStream = null;
            }
        }

        public void endPrefixMapping(String prefix) throws SAXException {
        }

        public void error(SAXParseException e) throws SAXException {
            throw e;
        }

        public void fatalError(SAXParseException e) throws SAXException {
            throw e;
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        }

        public void processingInstruction(String target, String data) throws SAXException {
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            return null;
        }

        public void skippedEntity(String name) throws SAXException {
        }

        public void startDocument() throws SAXException {
            SAXFragmentHandler.this.depth = 0;
            if (ModelDebugger.INSTANCE.debugEventFlow) {
                System.out.print(START_DOCUMENT);
                System.out.println();
            }
            SAXFragmentHandler.this.handler.startDocument();
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            ++SAXFragmentHandler.this.depth;
            if (ModelDebugger.INSTANCE.debugEventFlow) {
                System.out.print(START_ELEMENT);
                System.out.println(qName);
            }
            SAXFragmentHandler.this.handler.startElement(qName, false, attributes.getLength() == 0);
            int i = 0;
            while (i < attributes.getLength()) {
                SAXFragmentHandler.this.handler.attributeName(attributes.getQName(i));
                SAXFragmentHandler.this.handler.attributeValueCharacters(attributes.getValue(i));
                ++i;
            }
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        }

        public void warning(SAXParseException e) throws SAXException {
        }
    }
}

