/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.util;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.loaders.hierarchy.IgnoredXMLFragmentLoader;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.InvalidXMLException;
import org.eclipse.hyades.loaders.util.LoaderExtensions;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.loaders.util.SAXFragmentHandler;
import org.eclipse.hyades.loaders.util.XMLFragmentHandler;
import org.eclipse.hyades.loaders.util.XMLFragmentHandlerExtensions;
import org.eclipse.hyades.loaders.util.XMLFragmentLoader;
import org.eclipse.hyades.models.hierarchy.CorrelationSourceInfo;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCCollectionMode;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.UnresolvedCorrelation;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.models.hierarchy.util.MonitoredInputStream;
import org.eclipse.hyades.models.hierarchy.util.PerfUtil;
import org.eclipse.hyades.models.hierarchy.util.SaveUtil;
import org.eclipse.hyades.models.hierarchy.util.StringUtil;
import org.eclipse.hyades.models.hierarchy.util.internal.CrimsonFragmentHandler;
import org.eclipse.hyades.models.hierarchy.util.internal.IExtendedLoader;
import org.eclipse.hyades.models.hierarchy.util.internal.InvalidEventException;
import org.eclipse.hyades.models.hierarchy.util.internal.SimpleFragmentHandler;
import org.eclipse.hyades.models.util.ModelDebugger;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLLoader
implements IExtendedLoader {
    protected BufferedOutputStream file;
    protected HierarchyContext context;
    protected InvalidXMLException error;
    protected Map loaders = new HashMap();
    protected String currentAttributeName;
    protected String currentElementName;
    protected XMLFragmentHandler scanner;
    protected XMLFragmentLoader currentLoader;
    protected XMLFragmentLoader defaultLoader = new IgnoredXMLFragmentLoader();
    protected boolean startDocument;
    protected int depth = 0;
    protected int fragmentsCount;
    protected PerfUtil p;
    protected boolean debug;
    protected static final char[] LE_IN = new char[]{'l', 'E', '>'};
    protected static final char[] LE_OUT = new char[]{'l', 'E', '<'};
    protected StringBuffer sb = new StringBuffer();
    protected String rootElement;

    public XMLLoader(TRCAgentProxy agentProxy) {
        this.makeScanner();
        TRCAgent agent = agentProxy.getAgent();
        if (agent != null && agent.eResource() != null) {
            this.context = LoadersUtils.locateHierarchyContext(agent);
        }
        if (this.context == null) {
            this.context = new HierarchyContext();
            this.context.setMonitor(agentProxy.getProcessProxy().getNode().getMonitor());
            this.context.setNode(agentProxy.getProcessProxy().getNode());
            this.context.setProcessProxy(agentProxy.getProcessProxy());
            this.context.setAgentProxy(agentProxy);
            LookupServiceExtensions.getInstance().register(null, this.context);
        } else {
            if (this.context.getAgentProxy() == null) {
                this.context.setAgentProxy(agentProxy);
            }
            if (this.context.getProcessProxy() == null) {
                this.context.setProcessProxy(agentProxy.getProcessProxy());
            }
            if (this.context.getMonitor() == null) {
                this.context.setMonitor(agentProxy.getProcessProxy().getNode().getMonitor());
            }
            if (this.context.getNode() == null) {
                this.context.setNode(agentProxy.getProcessProxy().getNode());
            }
        }
        this.defaultLoader = this.getLoader("DefaultXMLFragmentLoader");
    }

    public XMLLoader(TRCAgent agent) {
        this.makeScanner();
        if (agent != null) {
            this.context = LoadersUtils.locateHierarchyContext(agent);
        }
        if (this.context == null) {
            this.context = new HierarchyContext();
            this.context.setMonitor(agent.getAgentProxy().getProcessProxy().getNode().getMonitor());
            this.context.setNode(agent.getAgentProxy().getProcessProxy().getNode());
            this.context.setProcessProxy(agent.getAgentProxy().getProcessProxy());
            this.context.setAgentProxy(agent.getAgentProxy());
            this.context.setAgent(agent);
            if (agent.eResource() == null) {
                try {
                    this.addToResource(agent, this.context);
                }
                catch (Exception exception) {}
            }
            LookupServiceExtensions.getInstance().register(null, this.context);
        } else if (this.context.getAgentProxy() == null) {
            this.context.setAgentProxy(agent.getAgentProxy());
            if (this.context.getProcessProxy() == null) {
                this.context.setProcessProxy(agent.getAgentProxy().getProcessProxy());
            }
            if (this.context.getMonitor() == null) {
                this.context.setMonitor(agent.getAgentProxy().getProcessProxy().getNode().getMonitor());
            }
            if (this.context.getNode() == null) {
                this.context.setNode(agent.getAgentProxy().getProcessProxy().getNode());
            }
        }
        this.defaultLoader = this.getLoader("DefaultXMLFragmentLoader");
    }

    public XMLLoader(TRCMonitor monitor) {
        if (this.context == null) {
            this.context = new HierarchyContext();
            this.context.setMonitor(monitor);
        }
        this.makeScanner();
        this.defaultLoader = this.getLoader("DefaultXMLFragmentLoader");
    }

    public void setCollectionMode(int collectionMode) {
        this.context.setCollectionMode(TRCCollectionMode.get(collectionMode));
    }

    public HierarchyContext getContext() {
        return this.context;
    }

    public int getProcessedFragments() {
        return this.fragmentsCount;
    }

    public void attributeName(String name) {
        if (this.isIgnoredElement()) {
            return;
        }
        this.currentAttributeName = name;
    }

    public void attributeValueCharacters(String attributeValue) {
        if (this.isIgnoredElement()) {
            return;
        }
        try {
            this.currentLoader.addAttribute(this.currentAttributeName, attributeValue);
        }
        catch (Exception e) {
            this.log(e);
        }
    }

    public void characters(char[] ch, int start, int length) {
        if (this.isIgnoredElement()) {
            String s = new String(ch, start, length).trim();
            if (s.length() == 0) {
                return;
            }
            if (this.currentElementName != null && this.getContext().getAgent() == null) {
                LoadersUtils.createAgent(this.getContext());
            }
            return;
        }
        try {
            if (this.currentLoader != null) {
                this.currentLoader.addCharacters(ch, start, length);
            }
        }
        catch (Exception e) {
            this.log(e);
        }
    }

    public synchronized void cleanUp() {
        if (this.scanner == null) {
            return;
        }
        if (ModelDebugger.INSTANCE.debug) {
            System.out.println("XMLLoader.cleanUp()");
        }
        this.printLoadInfo("cleanup()");
        try {
            this.scanner.terminateParser();
        }
        catch (Exception e) {
            this.log(e);
        }
        this.scanner = null;
        if (this.file != null) {
            try {
                this.file.close();
            }
            catch (IOException e) {
                this.log(e);
            }
        }
        this.file = null;
        this.error = null;
        this.depth = 0;
        this.startDocument = true;
        this.fragmentsCount = 0;
        ArrayList processed = new ArrayList();
        for (Map.Entry entry : this.loaders.entrySet()) {
            if (processed.contains(entry.getValue())) continue;
            ((XMLFragmentLoader)entry.getValue()).cleanUp();
            processed.add(entry.getValue());
        }
        this.loaders.clear();
        if (this.getContext().getGlobalForwardReferences().size() > 0) {
            this.processGlobalForwardReferences();
        }
    }

    protected void printLoadInfo(String prefix) {
        String contextInfo = "contextInfo=";
        if (this.context != null) {
            contextInfo = String.valueOf(contextInfo) + this.context.getContextURI();
        }
        this.p.stopAndPrintStatus(String.valueOf(prefix) + ", fragmentsCount=" + this.fragmentsCount + ", " + contextInfo);
        this.p.setMessage("XMLLoader loadEvents +++");
    }

    public void endDocument(Object object, int i) {
        this.printLoadInfo("endDocument()");
    }

    public void endElement(String elementName, int currentOffset) {
        this.currentElementName = elementName;
        try {
            --this.depth;
            if (this.depth == 0) {
                this.currentLoader.addYourselfInContext();
                if (this.getContext().getAgent() != null && this.getContext().getAgent().eResource() != null && !this.getContext().getAgent().eResource().isModified()) {
                    this.getContext().getAgent().eResource().setModified(true);
                }
                this.currentElementName = this.rootElement;
            } else if (this.depth > 0) {
                this.currentLoader.endChild(this.currentElementName);
            }
        }
        catch (Exception e) {
            this.log(e, "fragmentsCount=" + this.fragmentsCount);
            this.error = new InvalidXMLException(e);
            throw this.error;
        }
    }

    public void error(InvalidXMLException exception) {
        this.error = exception;
        this.error.fillInStackTrace();
        throw this.error;
    }

    public void loadEvent(byte[] buffer, int offset, int length, boolean loadToModel, boolean toProfileFile) throws InvalidXMLException {
        this.checkForStopProcessing();
        if (toProfileFile) {
            if (ModelDebugger.INSTANCE.debugEventsToFile) {
                this.writeToBinaryOutputFile(buffer, 0, length);
            }
        } else {
            this.loadEvent(buffer, offset, length, loadToModel);
        }
    }

    public void loadEvent(byte[] buffer, int offset, int length, boolean loadToModel) throws InvalidXMLException {
        block8: {
            this.checkForStopProcessing();
            this.setLoadToModel(loadToModel);
            try {
                if (ModelDebugger.INSTANCE.debugEventFlow) {
                    System.out.print(LE_IN);
                    this.sb.setLength(0);
                    this.sb.append(this.fragmentsCount);
                    System.out.println(LoadersUtils.getChars(this.sb));
                }
                if (ModelDebugger.INSTANCE.debugEventsToFile) {
                    this.writeToBinaryOutputFile(buffer, offset, length);
                } else {
                    this.scanner.scanContent(buffer, offset, length);
                }
                if (ModelDebugger.INSTANCE.debugEventFlow) {
                    System.out.println(LE_OUT);
                }
            }
            catch (Exception e) {
                if (ModelDebugger.INSTANCE.debugEventFlow) {
                    System.out.print(LE_OUT);
                    System.out.println(" = " + e.getLocalizedMessage());
                }
                if (this.error != null) break block8;
                this.log(e);
            }
        }
        if (this.error != null) {
            throw this.error;
        }
    }

    protected void checkForStopProcessing() {
        if (this.error != null) {
            ModelDebugger.log(this.error);
            throw this.error;
        }
    }

    public void loadEvent(byte[] buffer, int offset, int length) throws InvalidXMLException {
        this.loadEvent(buffer, offset, length, true);
    }

    public void restartParser() {
        if (this.scanner != null) {
            try {
                this.scanner.terminateParser();
            }
            catch (Exception e) {
                this.log(e);
            }
        }
        this.error = null;
        this.startDocument = true;
        this.depth = 0;
        this.makeScanner();
    }

    public void startDocument() {
        this.startDocument = true;
    }

    public void startElement(String elementName, boolean hasAttributes, boolean isEmpty) {
        this.currentElementName = elementName;
        if (this.isIgnoredElement()) {
            return;
        }
        if (this.depth == 0) {
            this.currentLoader = this.getLoader(this.getName(this.currentElementName));
            this.currentLoader.initialize(this.getContext(), this.currentElementName);
            ++this.fragmentsCount;
        } else {
            try {
                this.currentLoader.startChild(this.currentElementName);
            }
            catch (Exception e) {
                this.log(e);
                this.error = new InvalidXMLException(e);
                throw this.error;
            }
        }
        ++this.depth;
    }

    protected boolean isIgnoredElement() {
        if (this.startDocument) {
            if (this.currentElementName == this.rootElement) {
                return true;
            }
            if (this.rootElement != null) {
                return false;
            }
            this.rootElement = this.currentElementName;
            if (this.currentElementName.equals("TRACE") || this.currentElementName.equals("CommonBaseEvents") || this.currentElementName.equals("Statistic")) {
                return true;
            }
            this.startDocument = false;
        } else if (this.depth == 0 && this.currentElementName == this.rootElement) {
            return true;
        }
        return false;
    }

    protected XMLFragmentLoader getLoader(String currentElementName) {
        XMLFragmentLoader loader = (XMLFragmentLoader)this.loaders.get(currentElementName);
        if (loader == null) {
            loader = (XMLFragmentLoader)LoaderExtensions.getInstance().get(currentElementName);
            if (loader != null) {
                try {
                    loader = (XMLFragmentLoader)loader.getClass().newInstance();
                    this.loaders.put(currentElementName, loader);
                    return loader;
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
            loader = this.defaultLoader;
        }
        return loader;
    }

    protected String getName(String currentElementName) {
        int column = currentElementName.lastIndexOf(":");
        if (column != -1) {
            return currentElementName.substring(column);
        }
        return currentElementName;
    }

    protected void log(Exception e) {
        this.log(e, null);
    }

    protected void log(Exception e, String msg) {
        if (e instanceof SAXParseException) {
            SAXParseException spx = (SAXParseException)e;
            System.err.println(spx.getLocalizedMessage());
            System.err.println("at line: " + spx.getLineNumber());
            System.err.println("at column: " + spx.getColumnNumber());
            spx.fillInStackTrace();
            ModelDebugger.log(spx, msg);
        } else {
            ModelDebugger.log(e, msg);
        }
    }

    protected void makeScanner() {
        this.p = PerfUtil.createInstance("XMLLoader loadEvents", true);
        try {
            String s = System.getProperties().getProperty("XMLLoader.debug");
            this.debug = Boolean.valueOf(s);
            if (!this.debug) {
                this.debug = ModelDebugger.INSTANCE.debug;
            }
        }
        catch (Exception exception) {}
        this.scanner = (XMLFragmentHandler)XMLFragmentHandlerExtensions.getInstance().get("handler");
        if (this.scanner != null) {
            try {
                this.scanner = (XMLFragmentHandler)this.scanner.getClass().newInstance();
                this.scanner.setXMLLoader(this);
            }
            catch (Exception e) {
                this.log(e);
                this.scanner = new SAXFragmentHandler();
                this.scanner.setXMLLoader(this);
            }
        } else {
            if (ModelDebugger.INSTANCE.debugUseOptimizedScanner) {
                this.scanner = new SimpleFragmentHandler();
            } else {
                SAXParser p = null;
                try {
                    p = XMLLoader.makeParser();
                }
                catch (Exception exception) {}
                this.scanner = p != null && p.getClass().getName().equals("org.apache.crimson.jaxp.SAXParserImpl") ? new CrimsonFragmentHandler() : new SAXFragmentHandler();
            }
            this.scanner.setXMLLoader(this);
        }
    }

    public static SAXParser makeParser() throws ParserConfigurationException, SAXException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setFeature("http://xml.org/sax/features/string-interning", true);
        factory.setValidating(false);
        return factory.newSAXParser();
    }

    protected void processGlobalForwardReferences() {
        Iterator iter = this.context.getAgent().getUnresolvedCorrelations().iterator();
        while (iter.hasNext()) {
            UnresolvedCorrelation unresolvedCorrelation = (UnresolvedCorrelation)iter.next();
            Iterator iterator = unresolvedCorrelation.getSourceInfos().iterator();
            while (iterator.hasNext()) {
                CorrelationSourceInfo correlationSourceInfo = (CorrelationSourceInfo)iterator.next();
                EObject owner = correlationSourceInfo.getOwner();
                EReference reference = correlationSourceInfo.getReference();
                EObject o = (EObject)LookupServiceExtensions.getInstance().locate(null, reference.getEReferenceType().getInstanceClass(), LoadersUtils.getLookUpKey(unresolvedCorrelation.getContextId()));
                if (o == null) continue;
                if (reference.isMany()) {
                    ((EList)owner.eGet((EStructuralFeature)reference)).add((Object)o);
                } else {
                    owner.eSet((EStructuralFeature)reference, (Object)o);
                }
                iterator.remove();
            }
            if (unresolvedCorrelation.getSourceInfos().size() != 0) continue;
            iter.remove();
        }
    }

    protected void setLoadToModel(boolean loadToModel) {
        if (this.context.isLoadToModel() != loadToModel) {
            this.context.setLoadToModel(loadToModel);
        }
    }

    protected void addToResource(TRCAgent agent, HierarchyContext context) {
        String monitorFolder = LoadersUtils.getMonitorFolder(context.getMonitor());
        Resource agDoc = null;
        if (agent.getName() == null) {
            agent.setName("unknown");
        }
        String aName = String.valueOf(StringUtil.change(context.getMonitor().getName().trim(), " ", "")) + "_" + context.getNode().getName().trim() + "_" + context.getProcessProxy().getPid() + "_" + context.getProcessProxy().getRuntimeId() + "_" + StringUtil.change(agent.getName().trim(), " ", "");
        String pFileName = String.valueOf(monitorFolder) + aName;
        agDoc = Resource.Factory.Registry.INSTANCE.getFactory(SaveUtil.createURI(String.valueOf(pFileName) + ".trcaxmi")).createResource(SaveUtil.createURI(String.valueOf(pFileName) + ".trcaxmi"));
        agDoc.setModified(true);
        HierarchyResourceSetImpl.getInstance().getResources().add((Object)agDoc);
        agDoc.getContents().add((Object)agent);
    }

    protected void writeToTextOutputFile(String xml) {
        try {
            if (this.createOutputFile()) {
                this.file.write(xml.getBytes(), 0, xml.getBytes().length);
                this.file.write(10);
                this.file.flush();
            }
        }
        catch (IOException e) {
            this.error = new InvalidXMLException(e);
            throw this.error;
        }
    }

    protected void writeToBinaryOutputFile(byte[] buffer, int offset, int length) {
        try {
            if (this.createOutputFile()) {
                this.file.write(buffer, offset, length);
                this.file.write(10);
                this.file.flush();
            }
        }
        catch (IOException e) {
            this.error = new InvalidXMLException(e);
            ModelDebugger.log(e);
            throw this.error;
        }
    }

    protected boolean createOutputFile() {
        try {
            if (this.file == null) {
                String fileName = "/XMLLoader_toFile_" + new Date().getTime() + ".out";
                if (this.context != null && this.context.getAgentProxy() != null) {
                    this.context.getAgentProxy().setProfileFile(fileName);
                }
                this.file = new BufferedOutputStream(new FileOutputStream(fileName));
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public void loadEvent(byte[] buffer, int length, boolean loadToModel, boolean toProfileFile) throws InvalidXMLException {
        this.loadEvent(buffer, 0, length, loadToModel, toProfileFile);
    }

    public void loadEvent(byte[] buffer, int length, boolean loadToModel) throws InvalidXMLException {
        this.loadEvent(buffer, 0, length, loadToModel);
    }

    public void loadEvent(byte[] buffer, int length) throws InvalidXMLException {
        this.loadEvent(buffer, 0, length);
    }

    public void attributeName(int nameId) {
    }

    public void attributeValueCharacters(char[] attributeValue) {
    }

    public void endElement(int elementNameId, int currentOffset) {
    }

    public void error(InvalidEventException exception) {
    }

    public void startElement(int elementNameId, boolean hasAttributes, boolean isEmpty) {
    }

    public void loadEvents(InputStream inputStream, long offset, long length) throws InvalidEventException {
        if (this.scanner != null) {
            if (!(inputStream instanceof MonitoredInputStream || offset == 0L && length == -1L)) {
                final long startPos = offset;
                final long endPos = offset + length;
                if (startPos > 0L) {
                    this.getContext().setLoadToModel(false);
                }
                inputStream = new MonitoredInputStream(inputStream){
                    int state;
                    long totalBytesRead;
                    {
                        super($anonymous0);
                        this.state = 0;
                    }

                    protected int afterRead(int readBytes) {
                        if (this.state == 2) {
                            return -1;
                        }
                        this.totalBytesRead += (long)readBytes;
                        return readBytes;
                    }

                    protected int beforeRead(int maxBytesToRead) {
                        if (this.state == 2) {
                            return 0;
                        }
                        switch (this.state) {
                            case 0: {
                                if (this.totalBytesRead == startPos) {
                                    XMLLoader.this.getContext().setLoadToModel(true);
                                    ++this.state;
                                    break;
                                }
                                if (this.totalBytesRead + (long)maxBytesToRead <= startPos) break;
                                maxBytesToRead = (int)(startPos - this.totalBytesRead);
                                break;
                            }
                            case 1: {
                                if (this.totalBytesRead == endPos) {
                                    XMLLoader.this.getContext().setLoadToModel(false);
                                    maxBytesToRead = 0;
                                    ++this.state;
                                    break;
                                }
                                if (this.totalBytesRead + (long)maxBytesToRead <= endPos) break;
                                maxBytesToRead = (int)(endPos - this.totalBytesRead);
                                break;
                            }
                        }
                        return maxBytesToRead;
                    }

                    protected boolean isCanceled() {
                        return this.state == 2;
                    }
                };
            }
            this.scanner.scanContent(inputStream, offset, length);
        }
    }

    public String toString() {
        return String.valueOf(super.toString()) + ", fragmentsProcessed=" + this.fragmentsCount;
    }
}

