/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.hierarchy.extensions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ArithmeticOperators implements Enumerator
{
    ADD_LITERAL(0, "ADD", "ADD"),
    SUBSTRACT_LITERAL(1, "SUBSTRACT", "SUBSTRACT"),
    MULTIPLY_LITERAL(2, "MULTIPLY", "MULTIPLY"),
    DIVIDE_LITERAL(3, "DIVIDE", "DIVIDE"),
    INTEGER_DIVIDE_LITERAL(4, "INTEGER_DIVIDE", "INTEGER_DIVIDE"),
    MOD_LITERAL(5, "MOD", "MOD");

    public static final int ADD = 0;
    public static final int SUBSTRACT = 1;
    public static final int MULTIPLY = 2;
    public static final int DIVIDE = 3;
    public static final int INTEGER_DIVIDE = 4;
    public static final int MOD = 5;
    private static final ArithmeticOperators[] VALUES_ARRAY;
    public static final List<ArithmeticOperators> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ArithmeticOperators[]{ADD_LITERAL, SUBSTRACT_LITERAL, MULTIPLY_LITERAL, DIVIDE_LITERAL, INTEGER_DIVIDE_LITERAL, MOD_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ArithmeticOperators get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ArithmeticOperators result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ArithmeticOperators getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ArithmeticOperators result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ArithmeticOperators get(int value) {
        switch (value) {
            case 0: {
                return ADD_LITERAL;
            }
            case 1: {
                return SUBSTRACT_LITERAL;
            }
            case 2: {
                return MULTIPLY_LITERAL;
            }
            case 3: {
                return DIVIDE_LITERAL;
            }
            case 4: {
                return INTEGER_DIVIDE_LITERAL;
            }
            case 5: {
                return MOD_LITERAL;
            }
        }
        return null;
    }

    private ArithmeticOperators(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

