/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.hierarchy.extensions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum LogicalOperators implements Enumerator
{
    NOT_LITERAL(0, "NOT", "NOT"),
    AND_LITERAL(1, "AND", "AND"),
    OR_LITERAL(2, "OR", "OR");

    public static final int NOT = 0;
    public static final int AND = 1;
    public static final int OR = 2;
    private static final LogicalOperators[] VALUES_ARRAY;
    public static final List<LogicalOperators> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new LogicalOperators[]{NOT_LITERAL, AND_LITERAL, OR_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static LogicalOperators get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LogicalOperators result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LogicalOperators getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LogicalOperators result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LogicalOperators get(int value) {
        switch (value) {
            case 0: {
                return NOT_LITERAL;
            }
            case 1: {
                return AND_LITERAL;
            }
            case 2: {
                return OR_LITERAL;
            }
        }
        return null;
    }

    private LogicalOperators(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

