/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.hierarchy.util;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.hyades.models.util.ModelDebugger;

public class PerfUtil {
    protected long startTime;
    protected long stopTime;
    protected long startTotMem;
    protected long startFreeMem;
    protected long stopTotMem;
    protected long stopFreeMem;
    protected String msg;
    protected boolean debug = false;
    protected static Map registry = new HashMap();
    protected static PerfUtil staticInactiveInstance = new PerfUtil("PerfUtil- disabled", false);

    public PerfUtil() {
        this.setDebugFlag();
    }

    public PerfUtil(String msg, boolean start) {
        this.setDebugFlag();
        if (!this.debug) {
            return;
        }
        this.msg = msg;
        if (start) {
            this.start();
        }
    }

    public static PerfUtil createInstance(String msg, boolean start) {
        if (ModelDebugger.INSTANCE.debugPerfUtil) {
            return new PerfUtil(msg, start);
        }
        return staticInactiveInstance;
    }

    public static PerfUtil createInstance() {
        if (ModelDebugger.INSTANCE.debugPerfUtil) {
            return new PerfUtil();
        }
        return staticInactiveInstance;
    }

    protected void setDebugFlag() {
        try {
            String s = System.getProperties().getProperty("ModelDebugger.debugPerfUtil");
            if (Boolean.valueOf(s).booleanValue()) {
                this.debug = true;
            }
            if (!this.debug) {
                this.debug = ModelDebugger.INSTANCE.debugPerfUtil;
            }
        }
        catch (Exception exception) {}
    }

    public void start() {
        if (!this.debug) {
            return;
        }
        this.stopTime = this.startTime = System.currentTimeMillis();
        this.startTotMem = Runtime.getRuntime().totalMemory();
        this.startFreeMem = Runtime.getRuntime().freeMemory();
    }

    public void stop() {
        if (!this.debug) {
            return;
        }
        this.stopTime = System.currentTimeMillis();
        this.stopTotMem = Runtime.getRuntime().totalMemory();
        this.stopFreeMem = Runtime.getRuntime().freeMemory();
    }

    public long getTime() {
        return this.stopTime - this.startTime;
    }

    public void printStatus() {
        this.printStatus(System.out);
    }

    public void printStatus(String m) {
        if (!this.debug) {
            return;
        }
        this.msg = String.valueOf(this.msg) + ", " + m;
        this.printStatus(System.out);
    }

    public void printStatus(PrintStream out) {
        if (this.debug) {
            out.println(String.valueOf(this.msg) + ": deltaTime=" + this.getTime() + " - stopTime=" + this.stopTime + " - usedMemoryDelta=" + this.getUsedMemoryDelta() + " - freeMemoryDelta=" + this.getFreeMemoryDelta() + " - totalMemoryDelta=" + this.getTotalMemoryDelta() + " - usedMemoryAfter=" + (this.stopTotMem - this.stopFreeMem) + " - freeMemoryAfter=" + this.stopFreeMem + " - totalMemoryAfter=" + this.stopTotMem);
            ModelDebugger.logCallstackWithLimit(new Throwable("PerfUtil"), ModelDebugger.INSTANCE.exceptionDepth, out);
        }
    }

    public long getUsedMemoryDelta() {
        return this.stopTotMem - this.stopFreeMem - (this.startTotMem - this.startFreeMem);
    }

    public long getTotalMemoryDelta() {
        return this.stopTotMem - this.startTotMem;
    }

    public long getFreeMemoryDelta() {
        return this.stopFreeMem - this.startFreeMem;
    }

    public long getUsedMemoryAfter() {
        return this.stopTotMem - this.stopFreeMem;
    }

    public long getFreeMemoryAfter() {
        return this.stopFreeMem;
    }

    public long getTotalMemoryAfter() {
        return this.stopTotMem;
    }

    public void setMessage(String msg) {
        if (!this.debug) {
            return;
        }
        this.msg = msg;
    }

    public String getMessage() {
        return this.msg;
    }

    public PerfUtil setMessageAndStart(String string) {
        if (!this.debug) {
            return this;
        }
        this.setMessage(string);
        this.start();
        return this;
    }

    public PerfUtil stopAndPrintStatus() {
        if (!this.debug) {
            return this;
        }
        this.stop();
        this.printStatus();
        return this;
    }

    public PerfUtil stopAndPrintStatus(String msg) {
        if (!this.debug) {
            return this;
        }
        this.msg = String.valueOf(this.msg) + ", " + msg;
        this.stop();
        this.printStatus();
        return this;
    }

    public static PerfUtil getPerfUtil(Object key) {
        PerfUtil res = (PerfUtil)registry.get(key);
        if (res == null) {
            res = new PerfUtil(key.toString(), false);
            registry.put(key, res);
        }
        return res;
    }

    public static PerfUtil removePerfUtil(Object key) {
        PerfUtil res = (PerfUtil)registry.get(key);
        if (res != null) {
            registry.remove(key);
        }
        return res;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public PerfUtil setDebug(boolean debug) {
        this.debug = debug;
        return this;
    }
}

