/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.hierarchy.util.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.eclipse.hyades.loaders.util.IXMLLoader;
import org.eclipse.hyades.loaders.util.InvalidXMLException;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.XMLFragmentHandler;
import org.eclipse.hyades.loaders.util.XMLLoader;
import org.eclipse.hyades.models.util.ModelDebugger;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class CrimsonFragmentHandler
extends DefaultHandler
implements XMLFragmentHandler {
    protected static final String IGNORED_ELEMENT_NAME = "M69";
    protected static final char[] END_ELEMENT = "endElement=".toCharArray();
    protected static final char[] START_ELEMENT = "startElement=".toCharArray();
    protected static final char[] START_DOCUMENT = "startDocument=".toCharArray();
    protected static final char[] END_DOCUMENT = "endDocument=".toCharArray();
    protected static final char[] CHARACTERS = "characters=".toCharArray();
    protected InputSource inputSource = null;
    protected InputStream xmlStream = null;
    protected ParserPipedInputStream pipedXmlStream = null;
    protected SAXParser parser;
    protected Thread parseThread;
    protected IXMLLoader handler;
    protected int depth;
    protected static final int WAIT_TIME = 1000;
    protected static final char[] WB_IN = "wB>".toCharArray();
    protected static final char[] WB_OUT = "wB<".toCharArray();
    protected char[] IGNORE_CHAR_LENGTH = "rB>ignoreCharsLength=".toCharArray();
    protected static final byte[] IGNORE_ELEMENT_PREFIX = "<M69 S88=\"".getBytes();
    protected static final byte[] IGNORE_ELEMENT_POSTFIX = "\"/>".getBytes();
    protected static final int MIN_INGNORED_ELEMENT_LENGTH = IGNORE_ELEMENT_PREFIX.length + IGNORE_ELEMENT_POSTFIX.length;
    protected int ignoredCount = 0;
    protected byte[] ignoredAttributeValue;
    protected boolean ignoreOn;
    protected boolean initRequired;
    private static final int CRIMSON_BUFSIZ = 8192;
    protected final String lockForIgnored = new String("LockForIgnoredEvents");

    public void setXMLLoader(IXMLLoader loader) {
        this.handler = loader;
        this.initRequired = true;
    }

    public void init() {
        try {
            this.initRequired = false;
            this.depth = -1;
            this.parser = this.makeParser();
            this.pipedXmlStream = new ParserPipedInputStream(this);
            this.xmlStream = this.pipedXmlStream;
            this.parseThread = new Thread(Thread.currentThread().getThreadGroup(), "xmlParserThread"){

                public void run() {
                    if (CrimsonFragmentHandler.this.xmlStream == null) {
                        return;
                    }
                    try {
                        CrimsonFragmentHandler.this.parse(CrimsonFragmentHandler.this.xmlStream, new SpecialHandler());
                    }
                    catch (Exception exception) {}
                    CrimsonFragmentHandler.this.xmlStream = null;
                }
            };
            this.parseThread.start();
        }
        catch (Exception e) {
            throw new InvalidXMLException(e);
        }
    }

    public void scanContent(byte[] fragment, int offset, int length) throws InvalidXMLException {
        if (this.pipedXmlStream == null) {
            if (this.initRequired) {
                this.init();
            } else {
                return;
            }
        }
        this.pipedXmlStream.writeBuf(fragment, offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminateParser() {
        block10: {
            this.depth = -1;
            if (this.xmlStream != null) {
                try {
                    if (ModelDebugger.INSTANCE.debug) {
                        ModelDebugger.log("SAXFragmentHandler.terminateParser() - close ParserPipedInputStream");
                    }
                    if (this.pipedXmlStream != null) {
                        ParserPipedInputStream temp = this.pipedXmlStream;
                        this.pipedXmlStream = null;
                        temp.makeClosed();
                    }
                    this.xmlStream = null;
                }
                catch (Exception e) {
                    if (!ModelDebugger.INSTANCE.debug) break block10;
                    ModelDebugger.log(e, "SAXFragmentHandler.terminateParser()");
                }
            }
        }
        CrimsonFragmentHandler crimsonFragmentHandler = this;
        synchronized (crimsonFragmentHandler) {
            this.notifyAll();
            if (this.parseThread != null) {
                this.parseThread.interrupt();
            }
            if (ModelDebugger.INSTANCE.debug) {
                ModelDebugger.log("SAXFragmentHandler.terminateParser() - done");
            }
        }
    }

    protected SAXParser makeParser() throws ParserConfigurationException, SAXException {
        this.parser = XMLLoader.makeParser();
        return this.parser;
    }

    protected synchronized void parse(InputStream inputStream, DefaultHandler theHandler) throws InvalidXMLException {
        try {
            this.parser.parse(inputStream, theHandler);
        }
        catch (Exception e) {
            if (ModelDebugger.INSTANCE.debug) {
                this.log(e, null);
            }
            InvalidXMLException i = e instanceof InvalidXMLException ? (InvalidXMLException)e : new InvalidXMLException(e);
            this.handler.error(i);
        }
    }

    protected void log(Exception e, String msg) {
        if (e instanceof SAXParseException) {
            SAXParseException spx = (SAXParseException)e;
            System.err.println(spx.getLocalizedMessage());
            System.err.println("at line: " + spx.getLineNumber());
            System.err.println("at column: " + spx.getColumnNumber());
            spx.fillInStackTrace();
            ModelDebugger.log(spx, msg);
        } else {
            ModelDebugger.log(e, msg);
        }
    }

    public void scanContent(InputStream inputStream, long offset, long length) {
        try {
            this.initRequired = false;
            this.depth = -1;
            this.parser = this.makeParser();
            this.xmlStream = inputStream;
            this.parse(this.xmlStream, new RegularHandler());
        }
        catch (Exception e) {
            InvalidXMLException i = e instanceof InvalidXMLException ? (InvalidXMLException)e : new InvalidXMLException(e);
            this.handler.error(i);
        }
    }

    public class ParserPipedInputStream
    extends InputStream {
        protected byte[] inBuf;
        protected boolean closed = false;
        protected int inCount = 0;
        protected long inTotalLength = 0L;
        protected int inPartLength = 0;
        protected int inPos = 0;
        protected StringBuffer sb = new StringBuffer();

        public ParserPipedInputStream(CrimsonFragmentHandler handler) {
            CrimsonFragmentHandler.this.ignoredAttributeValue = new byte[8192];
            Arrays.fill(CrimsonFragmentHandler.this.ignoredAttributeValue, (byte)83);
        }

        protected synchronized void makeOpened() {
            this.inPartLength = 0;
            this.inBuf = null;
            this.inCount = 0;
            this.inPos = 0;
            this.closed = false;
            this.notifyAll();
        }

        public synchronized int available() throws IOException {
            this.waitForNewData();
            return this.inCount;
        }

        public void close() throws IOException {
            super.close();
            this.closed = true;
        }

        public synchronized boolean hasEmptyBuffer() {
            return this.inCount == 0;
        }

        public synchronized void mark(int arg0) {
            super.mark(arg0);
        }

        public boolean markSupported() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read() throws IOException {
            String string = CrimsonFragmentHandler.this.lockForIgnored;
            synchronized (string) {
                block8: {
                    if (this.available() != 0) break block8;
                    return -1;
                }
                if (CrimsonFragmentHandler.this.ignoreOn) {
                    if (ModelDebugger.INSTANCE.debugEventFlow) {
                        System.out.print(CrimsonFragmentHandler.this.IGNORE_CHAR_LENGTH);
                        System.out.println("1,1");
                    }
                    this.inCount = 0;
                    this.inPartLength = 0;
                    if (ModelDebugger.INSTANCE.debugEventFlow) {
                        ModelDebugger.INSTANCE.writeBinaryLog("PARSER_READ", CrimsonFragmentHandler.this.ignoredAttributeValue, 0, 1);
                    }
                    CrimsonFragmentHandler.this.lockForIgnored.notify();
                    return CrimsonFragmentHandler.this.ignoredAttributeValue[0];
                }
                --this.inCount;
                if (ModelDebugger.INSTANCE.debugEventFlow) {
                    ModelDebugger.INSTANCE.writeBinaryLog("PARSER_READ", this.inBuf, this.inPos, 1);
                }
                return this.inBuf[this.inPos++];
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] outBuf, int offset, int length) throws IOException {
            String string = CrimsonFragmentHandler.this.lockForIgnored;
            synchronized (string) {
                block7: {
                    if (this.available() != 0) break block7;
                    return -1;
                }
                if (CrimsonFragmentHandler.this.ignoreOn) {
                    int ignoreElementLength = length;
                    if (ModelDebugger.INSTANCE.debugEventFlow) {
                        System.out.print(CrimsonFragmentHandler.this.IGNORE_CHAR_LENGTH);
                        System.out.print(ignoreElementLength);
                        System.out.print(',');
                        System.out.println(length);
                    }
                    System.arraycopy(IGNORE_ELEMENT_PREFIX, 0, outBuf, offset, IGNORE_ELEMENT_PREFIX.length);
                    if (ignoreElementLength > MIN_INGNORED_ELEMENT_LENGTH) {
                        System.arraycopy(CrimsonFragmentHandler.this.ignoredAttributeValue, 0, outBuf, offset + IGNORE_ELEMENT_PREFIX.length, ignoreElementLength - MIN_INGNORED_ELEMENT_LENGTH);
                    }
                    System.arraycopy(IGNORE_ELEMENT_POSTFIX, 0, outBuf, offset + ignoreElementLength - IGNORE_ELEMENT_POSTFIX.length, IGNORE_ELEMENT_POSTFIX.length);
                    this.inCount = 0;
                    this.inPartLength = 0;
                    ++CrimsonFragmentHandler.this.ignoredCount;
                    CrimsonFragmentHandler.this.ignoreOn = false;
                    CrimsonFragmentHandler.this.lockForIgnored.notify();
                    return ignoreElementLength;
                }
                int readBytes = Math.min(this.inCount, length);
                System.arraycopy(this.inBuf, this.inPos, outBuf, offset, readBytes);
                this.inPos += readBytes;
                this.inCount -= readBytes;
                return readBytes;
            }
        }

        public int read(byte[] arg0) throws IOException {
            return this.read(arg0, 0, arg0.length);
        }

        public synchronized void reset() throws IOException {
            super.reset();
        }

        public synchronized long skip(long arg0) throws IOException {
            if ((arg0 += (long)this.inPos) < this.inTotalLength) {
                this.inPos = (int)arg0;
                return arg0;
            }
            return -1L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public synchronized void writeBuf(byte[] buf, int offset, int length) {
            if (buf == null || length == 0) {
                return;
            }
            ParserPipedInputStream parserPipedInputStream = this;
            synchronized (parserPipedInputStream) {
                while (true) {
                    if (!CrimsonFragmentHandler.this.ignoreOn) {
                        this.inBuf = buf;
                        this.inPos = offset;
                        this.inTotalLength += (long)length;
                        this.inPartLength += length;
                        this.inCount = length;
                        break;
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            if (ModelDebugger.INSTANCE.debugEventFlow) {
                System.out.print(WB_IN);
                this.sb.setLength(0);
                this.sb.append(length);
                System.out.println(LoadersUtils.getChars(this.sb));
                System.out.write(buf, offset, length);
                System.out.write(buf, offset, length);
                System.out.println();
            }
            this.notifyAll();
            this.waitForEmptyBuffer();
            if (ModelDebugger.INSTANCE.debugEventFlow) {
                System.out.println(WB_OUT);
            }
        }

        protected synchronized void makeClosed() {
            this.inPartLength = 0;
            this.inBuf = null;
            this.inCount = 0;
            this.inPos = 0;
            this.closed = true;
            this.notifyAll();
        }

        protected void waitForEmptyBuffer() {
            while (!this.hasEmptyBuffer() && !this.closed) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    if (!this.hasEmptyBuffer() && !this.closed) continue;
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized void waitForNewData() {
            boolean notify = true;
            while (this.hasEmptyBuffer()) {
                if (notify) {
                    this.notify();
                    notify = false;
                }
                if (this.closed) {
                    return;
                }
                try {
                    this.wait(1000L);
                    ParserPipedInputStream parserPipedInputStream = this;
                    synchronized (parserPipedInputStream) {
                        if (this.hasEmptyBuffer() && !CrimsonFragmentHandler.this.ignoreOn && this.inPartLength > 0) {
                            this.inCount = Integer.MAX_VALUE;
                            CrimsonFragmentHandler.this.ignoreOn = true;
                            return;
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    if (!this.closed) continue;
                    return;
                }
            }
        }
    }

    public class RegularHandler
    extends DefaultHandler {
        public void setDocumentLocator(Locator locator) {
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            CrimsonFragmentHandler.this.handler.characters(ch, start, length);
            if (ModelDebugger.INSTANCE.debugEventFlow) {
                System.out.print(CHARACTERS);
                System.out.println(String.valueOf(length) + "=" + new String(ch, start, length));
            }
        }

        public void endDocument() throws SAXException {
            if (CrimsonFragmentHandler.this.depth == 0 && CrimsonFragmentHandler.this.xmlStream != null) {
                if (CrimsonFragmentHandler.this.pipedXmlStream != null) {
                    CrimsonFragmentHandler.this.pipedXmlStream.makeClosed();
                    CrimsonFragmentHandler.this.pipedXmlStream = null;
                }
                CrimsonFragmentHandler.this.xmlStream = null;
            }
            CrimsonFragmentHandler.this.depth = -1;
            if (ModelDebugger.INSTANCE.debugEventFlow) {
                System.out.print(END_DOCUMENT);
                System.out.println();
            }
            CrimsonFragmentHandler.this.handler.endDocument(null, 0);
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (ModelDebugger.INSTANCE.debugEventFlow) {
                System.out.print(END_ELEMENT);
                System.out.println(qName);
            }
            CrimsonFragmentHandler.this.handler.endElement(qName, 0);
            --CrimsonFragmentHandler.this.depth;
            if (CrimsonFragmentHandler.this.depth == 0 && CrimsonFragmentHandler.this.xmlStream != null) {
                if (CrimsonFragmentHandler.this.pipedXmlStream != null) {
                    CrimsonFragmentHandler.this.pipedXmlStream.makeClosed();
                    CrimsonFragmentHandler.this.pipedXmlStream = null;
                }
                CrimsonFragmentHandler.this.xmlStream = null;
            }
        }

        public void endPrefixMapping(String prefix) throws SAXException {
        }

        public void error(SAXParseException e) throws SAXException {
            throw e;
        }

        public void fatalError(SAXParseException e) throws SAXException {
            throw e;
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        }

        public void processingInstruction(String target, String data) throws SAXException {
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            return null;
        }

        public void skippedEntity(String name) throws SAXException {
        }

        public void startDocument() throws SAXException {
            CrimsonFragmentHandler.this.depth = 0;
            if (ModelDebugger.INSTANCE.debugEventFlow) {
                System.out.print(START_DOCUMENT);
                System.out.println();
            }
            CrimsonFragmentHandler.this.handler.startDocument();
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            ++CrimsonFragmentHandler.this.depth;
            if (ModelDebugger.INSTANCE.debugEventFlow) {
                System.out.print(START_ELEMENT);
                System.out.println(qName);
            }
            CrimsonFragmentHandler.this.handler.startElement(qName, false, attributes.getLength() == 0);
            int i = 0;
            while (i < attributes.getLength()) {
                CrimsonFragmentHandler.this.handler.attributeName(attributes.getQName(i));
                CrimsonFragmentHandler.this.handler.attributeValueCharacters(attributes.getValue(i));
                ++i;
            }
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        }

        public void warning(SAXParseException e) throws SAXException {
        }
    }

    public class SpecialHandler
    extends DefaultHandler {
        public void setDocumentLocator(Locator locator) {
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            CrimsonFragmentHandler.this.handler.characters(ch, start, length);
            if (ModelDebugger.INSTANCE.debugEventFlow) {
                System.out.print(CHARACTERS);
                System.out.println(String.valueOf(CrimsonFragmentHandler.this.ignoredCount) + "," + length + "=" + new String(ch, start, length));
            }
        }

        public void endDocument() throws SAXException {
            if (CrimsonFragmentHandler.this.depth == 0 && CrimsonFragmentHandler.this.xmlStream != null) {
                if (CrimsonFragmentHandler.this.pipedXmlStream != null) {
                    CrimsonFragmentHandler.this.pipedXmlStream.makeClosed();
                    CrimsonFragmentHandler.this.pipedXmlStream = null;
                }
                CrimsonFragmentHandler.this.xmlStream = null;
            }
            CrimsonFragmentHandler.this.depth = -1;
            if (ModelDebugger.INSTANCE.debugEventFlow) {
                System.out.print(END_DOCUMENT);
                System.out.println();
            }
            CrimsonFragmentHandler.this.handler.endDocument(null, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void endElement(String uri, String localName, String qName) throws SAXException {
            String string = CrimsonFragmentHandler.this.lockForIgnored;
            synchronized (string) {
                if (CrimsonFragmentHandler.this.ignoredCount > 0 && CrimsonFragmentHandler.IGNORED_ELEMENT_NAME.equals(qName)) {
                    --CrimsonFragmentHandler.this.ignoredCount;
                    if (CrimsonFragmentHandler.this.ignoredCount == 0) {
                        CrimsonFragmentHandler.this.ignoreOn = false;
                    }
                    return;
                }
                CrimsonFragmentHandler.this.lockForIgnored.notify();
            }
            if (ModelDebugger.INSTANCE.debugEventFlow) {
                System.out.print(END_ELEMENT);
                System.out.println(qName);
            }
            CrimsonFragmentHandler.this.handler.endElement(qName, 0);
            --CrimsonFragmentHandler.this.depth;
            if (CrimsonFragmentHandler.this.depth == 0 && CrimsonFragmentHandler.this.xmlStream != null) {
                if (CrimsonFragmentHandler.this.pipedXmlStream != null) {
                    CrimsonFragmentHandler.this.pipedXmlStream.makeClosed();
                    CrimsonFragmentHandler.this.pipedXmlStream = null;
                }
                CrimsonFragmentHandler.this.xmlStream = null;
            }
        }

        public void endPrefixMapping(String prefix) throws SAXException {
        }

        public void error(SAXParseException e) throws SAXException {
            throw e;
        }

        public void fatalError(SAXParseException e) throws SAXException {
            throw e;
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        }

        public void processingInstruction(String target, String data) throws SAXException {
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            return null;
        }

        public void skippedEntity(String name) throws SAXException {
        }

        public void startDocument() throws SAXException {
            CrimsonFragmentHandler.this.depth = 0;
            if (ModelDebugger.INSTANCE.debugEventFlow) {
                System.out.print(START_DOCUMENT);
                System.out.println();
            }
            CrimsonFragmentHandler.this.handler.startDocument();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String string = CrimsonFragmentHandler.this.lockForIgnored;
            synchronized (string) {
                if (CrimsonFragmentHandler.this.ignoredCount > 0 && CrimsonFragmentHandler.IGNORED_ELEMENT_NAME.equals(qName)) {
                    return;
                }
                CrimsonFragmentHandler.this.lockForIgnored.notify();
            }
            ++CrimsonFragmentHandler.this.depth;
            if (ModelDebugger.INSTANCE.debugEventFlow) {
                System.out.print(START_ELEMENT);
                System.out.println(qName);
            }
            CrimsonFragmentHandler.this.handler.startElement(qName, false, attributes.getLength() == 0);
            int i = 0;
            while (i < attributes.getLength()) {
                CrimsonFragmentHandler.this.handler.attributeName(attributes.getQName(i));
                CrimsonFragmentHandler.this.handler.attributeValueCharacters(attributes.getValue(i));
                ++i;
            }
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        }

        public void warning(SAXParseException e) throws SAXException {
        }
    }
}

