/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.hierarchy.util.internal;

import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.BasicNotifierImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.BasicEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.ECrossReferenceEList;
import org.eclipse.hyades.models.hierarchy.util.internal.TPTPVirtualMemoryManager;

public abstract class HierarchyEObjectImpl
extends BasicEObjectImpl {
    public static boolean useVirtualManager = false;
    public static boolean useStringCompression = true;
    public static final String STRING_ENCODING = "UTF8";
    public static final int DEFAULT_PROPERTIES_BASE = 0;
    public static final int CONTAINER_FEATURE_ID = -1;
    public static final int DELIVER = -2;
    public static final int DEFAULT_PRIMITIVES_PROPERTIES_COUNT = 2;
    public static final int PRIMITIVES_BYTE_ARRAY = -1;
    public static final int CONTAINER = -2;
    public static final int ADAPTERS = -3;
    public static final int DIRECT_RESOURCE = -4;
    public static final int CONTENTS = -5;
    public static final int CROSS_REFERENCES = -6;
    public static final int ECLASS = -7;
    public static final int DEFAULT_OBJECTS_PROPERTIES_COUNT = 7;
    protected Object data;
    protected int indexBits0;

    protected void cleanup() {
        if (useVirtualManager) {
            TPTPVirtualMemoryManager.INSTANCE.setData((Object)this, null);
            TPTPVirtualMemoryManager.INSTANCE.setIndexBits((Object)this, 0, 0);
        }
    }

    protected BasicEList eBasicAdapters() {
        return (BasicEList)this.eVirtualGet(-3, null);
    }

    public EList eAdapters() {
        BasicNotifierImpl.EAdapterList eAdapters = null;
        if (this.eBasicAdapters() == null) {
            eAdapters = new BasicNotifierImpl.EAdapterList((Notifier)this);
            this.eVirtualSet(-3, eAdapters);
        }
        return eAdapters;
    }

    protected void eBasicSetContainer(InternalEObject newContainer, int newContainerFeatureID) {
        this.eVirtualSet(-2, newContainer);
        this.eVirtualSet(-1, newContainerFeatureID);
    }

    public EClass eClass() {
        return this.eStaticClass();
    }

    protected int eComputeVirtualValuesCapacity(int minimumCapacity) {
        return minimumCapacity;
    }

    public EList eContents() {
        EList o = (EList)this.eVirtualGet(-5, null);
        if (o == null) {
            o = new EContentsEList((EObject)this);
            this.eVirtualSet(-5, o);
        }
        return o;
    }

    public EList eCrossReferences() {
        EList o = (EList)this.eVirtualGet(-6, null);
        if (o == null) {
            o = new ECrossReferenceEList((EObject)this);
            this.eVirtualSet(-6, o);
        }
        return o;
    }

    public Resource.Internal eDirectResource() {
        return (Resource.Internal)this.eVirtualGet(-4, null);
    }

    protected EClass eDynamicClass() {
        throw new UnsupportedOperationException("Dynamic models not supported yet");
    }

    public int eVirtualSequentialPrimitiveFeatureID(int eDerivedStructuralFeatureID) {
        return eDerivedStructuralFeatureID;
    }

    public int eVirtualSequentialObjectFeatureID(int derivedStructuralFeatureID) {
        return derivedStructuralFeatureID;
    }

    protected boolean eHasSettings() {
        throw new UnsupportedOperationException("Dynamic models not supported yet");
    }

    public InternalEObject eInternalContainer() {
        return (InternalEObject)this.eVirtualGet(-2, null);
    }

    public int eContainerFeatureID() {
        return this.eVirtualGet(-1, -1);
    }

    public boolean eDeliver() {
        return this.eVirtualGet(-2, false);
    }

    public void eSetDeliver(boolean deliver) {
        this.eVirtualSet(-2, deliver);
    }

    public boolean eIsProxy() {
        return this.eProxyURI() != null;
    }

    public URI eProxyURI() {
        Object data = this.getData();
        return data != null && data instanceof URI ? (URI)data : null;
    }

    protected Object getData() {
        if (useVirtualManager) {
            return TPTPVirtualMemoryManager.INSTANCE.getData((Object)this);
        }
        return this.data;
    }

    protected void setData(Object uri) {
        if (useVirtualManager) {
            TPTPVirtualMemoryManager.INSTANCE.setData((Object)this, uri);
        } else {
            this.data = uri;
        }
    }

    public void eSetClass(EClass eClass) {
        throw new UnsupportedOperationException("Dynamic models not supported yet");
    }

    protected void eSetDirectResource(Resource.Internal resource) {
        this.eVirtualSet(-4, resource);
    }

    public void eSetProxyURI(URI uri) {
        this.cleanup();
        this.setData(uri);
    }

    protected EStructuralFeature.Internal.DynamicValueHolder eSettings() {
        return null;
    }

    protected void eSetVirtualIndexBits(int offset, int newIndexBits) {
        switch (offset) {
            case 0: {
                this.setIndexBits(0, newIndexBits);
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("offset=" + offset);
            }
        }
    }

    protected void setIndexBits(int i, int newIndexBits) {
        if (!useVirtualManager) {
            this.indexBits0 = newIndexBits;
        }
    }

    protected int getIndexBits(int i) {
        if (useVirtualManager) {
            return TPTPVirtualMemoryManager.INSTANCE.getIndexBits((Object)this, i);
        }
        return this.indexBits0;
    }

    protected void eSetVirtualValues(Object[] newValues) {
        this.setData(newValues);
    }

    protected boolean eVirtualGet(int eDerivedStructuralFeatureID, boolean defaultValue) {
        byte[] primitives = this.getPrimitivesValues();
        if (primitives != null) {
            int index = this.eVirtualPrimitiveIndex(eDerivedStructuralFeatureID, 3, primitives);
            return index < 0 ? defaultValue : !defaultValue;
        }
        return defaultValue;
    }

    protected byte eVirtualGet(int eDerivedStructuralFeatureID, byte defaultValue) {
        byte[] primitives = this.getPrimitivesValues();
        if (primitives != null) {
            int intialSize = (this.eVirtualPrimitiveFeatureIDsCount() >>> 3) + 1;
            int index = this.eVirtualPrimitiveIndex(eDerivedStructuralFeatureID, 2, primitives);
            return index < 0 ? defaultValue : primitives[index + intialSize];
        }
        return defaultValue;
    }

    protected double eVirtualGet(int eDerivedStructuralFeatureID, double defaultValue) {
        byte[] primitives = this.getPrimitivesValues();
        if (primitives != null) {
            int intialSize = (this.eVirtualPrimitiveFeatureIDsCount() >>> 3) + 1;
            int index = this.eVirtualPrimitiveIndex(eDerivedStructuralFeatureID, 2, primitives);
            return index < 0 ? defaultValue : Double.longBitsToDouble(this.getLong(primitives, index + intialSize));
        }
        return defaultValue;
    }

    protected float eVirtualGet(int eDerivedStructuralFeatureID, float defaultValue) {
        byte[] primitives = this.getPrimitivesValues();
        if (primitives != null) {
            int intialSize = (this.eVirtualPrimitiveFeatureIDsCount() >>> 3) + 1;
            int index = this.eVirtualPrimitiveIndex(eDerivedStructuralFeatureID, 2, primitives);
            return index < 0 ? defaultValue : Float.intBitsToFloat(this.getInt(primitives, index + intialSize));
        }
        return defaultValue;
    }

    protected int eVirtualGet(int eDerivedStructuralFeatureID, int defaultValue) {
        byte[] primitives = this.getPrimitivesValues();
        if (primitives != null) {
            int intialSize = (this.eVirtualPrimitiveFeatureIDsCount() >>> 3) + 1;
            int index = this.eVirtualPrimitiveIndex(eDerivedStructuralFeatureID, 2, primitives);
            return index < 0 ? defaultValue : this.getInt(primitives, index + intialSize);
        }
        return defaultValue;
    }

    protected long eVirtualGet(int eDerivedStructuralFeatureID, long defaultValue) {
        byte[] primitives = this.getPrimitivesValues();
        if (primitives != null) {
            int intialSize = (this.eVirtualPrimitiveFeatureIDsCount() >>> 3) + 1;
            int index = this.eVirtualPrimitiveIndex(eDerivedStructuralFeatureID, 2, primitives);
            return index < 0 ? defaultValue : this.getLong(primitives, index + intialSize);
        }
        return defaultValue;
    }

    protected short eVirtualGet(int eDerivedStructuralFeatureID, short defaultValue) {
        byte[] primitives = this.getPrimitivesValues();
        if (primitives != null) {
            int intialSize = (this.eVirtualPrimitiveFeatureIDsCount() >>> 3) + 1;
            int index = this.eVirtualPrimitiveIndex(eDerivedStructuralFeatureID, 2, primitives);
            return index < 0 ? defaultValue : (short)(primitives[index + intialSize + 1] | (short)primitives[index + intialSize] << 8);
        }
        return defaultValue;
    }

    public Object eVirtualGet(int eDerivedStructuralFeatureID, String defaultValue) {
        if (!useStringCompression) {
            return super.eVirtualGet(eDerivedStructuralFeatureID, (Object)defaultValue);
        }
        try {
            Object tValue = super.eVirtualGet(eDerivedStructuralFeatureID, (Object)(defaultValue == null ? null : defaultValue));
            if (tValue == EVIRTUAL_NO_VALUE || defaultValue == tValue || tValue == null) {
                return defaultValue;
            }
            return new String((byte[])tValue, STRING_ENCODING);
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    public Object eVirtualSet(int eDerivedStructuralFeatureID, String value) {
        Object tValue;
        block4: {
            if (!useStringCompression) {
                return super.eVirtualSet(eDerivedStructuralFeatureID, (Object)value);
            }
            try {
                tValue = super.eVirtualSet(eDerivedStructuralFeatureID, value == null ? null : value.getBytes(STRING_ENCODING));
                if (tValue != EVIRTUAL_NO_VALUE && tValue != null) break block4;
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return new String((byte[])tValue, STRING_ENCODING);
    }

    protected int eVirtualIndex(int eDerivedStructuralFeatureID, int action) {
        if (eDerivedStructuralFeatureID < 0) {
            return super.eVirtualIndex(-eDerivedStructuralFeatureID - 1, action);
        }
        return super.eVirtualIndex(this.eVirtualSequentialObjectFeatureID(eDerivedStructuralFeatureID), action);
    }

    protected int eVirtualIndexBits(int offset) {
        switch (offset) {
            case 0: {
                return this.getIndexBits(0);
            }
        }
        throw new IndexOutOfBoundsException("index=" + offset);
    }

    public int eVirtualDefaultPrimitiveBitCount(int sequentialPrimitiveFeatureID, byte value) {
        if (sequentialPrimitiveFeatureID == -1) {
            return 0;
        }
        if ((value & 1) != 0) {
            return 4;
        }
        return 0;
    }

    public int eVirtualPrimitiveFeatureIDsCount() {
        return 2;
    }

    public int eVirtualObjectFeatureIDsCount() {
        return 7;
    }

    protected int eVirtualPrimitiveIndex(int eDerivedStructuralFeatureID, int action, byte[] primitives) {
        eDerivedStructuralFeatureID = eDerivedStructuralFeatureID < 0 ? -eDerivedStructuralFeatureID - 1 : this.eVirtualSequentialPrimitiveFeatureID(eDerivedStructuralFeatureID);
        int offset = eDerivedStructuralFeatureID >>> 3;
        byte bits = primitives[offset];
        int bitIndex = eDerivedStructuralFeatureID & 7;
        int bit = bits >>> bitIndex & 1;
        switch (action) {
            case 3: {
                return bit - 1;
            }
            case 2: {
                if (bit == 0) {
                    return -1;
                }
            }
            case 1: {
                if (bit != 0) break;
                return -1;
            }
        }
        int result = this.eVirtualPrimitiveBitCount(eDerivedStructuralFeatureID - 1, primitives);
        if (bit == action) {
            primitives[offset] = (byte)(bits ^ 1 << bitIndex);
        }
        return bit != 0 ? result : ~result;
    }

    public int eVirtualPrimitiveBitCount(int derivedStructuralFeatureID, byte[] primitives) {
        return this.eVirtualDefaultPrimitiveBitCount(derivedStructuralFeatureID, primitives[0]);
    }

    public boolean eVirtualPrimitiveIsSet(int eDerivedStructuralFeatureID) {
        byte[] primitives = this.getPrimitivesValues();
        if (primitives != null) {
            return this.eVirtualPrimitiveIndex(eDerivedStructuralFeatureID, 3, primitives) >= 0;
        }
        return false;
    }

    protected boolean eVirtualSet(int eDerivedStructuralFeatureID, boolean value) {
        byte[] primitives = this.getPrimitivesValues();
        if (primitives == null) {
            int intialSize = (this.eVirtualPrimitiveFeatureIDsCount() >>> 3) + 1;
            primitives = new byte[intialSize];
            this.eVirtualPrimitiveIndex(eDerivedStructuralFeatureID, value ? 0 : 1, primitives);
            this.eVirtualSet(-1, primitives);
            return value;
        }
        int bitIndex = this.eVirtualPrimitiveIndex(eDerivedStructuralFeatureID, value ? 0 : 1, primitives);
        return bitIndex < 0 ? value : !value;
    }

    protected byte eVirtualSet(int eDerivedStructuralFeatureID, byte value) {
        int intialSize = (this.eVirtualPrimitiveFeatureIDsCount() >>> 3) + 1;
        byte[] primitives = this.getPrimitivesValues();
        if (primitives == null) {
            primitives = new byte[intialSize + 1];
            this.eVirtualPrimitiveIndex(eDerivedStructuralFeatureID, 0, primitives);
            primitives[intialSize] = value;
            this.eVirtualSet(-1, primitives);
            return value;
        }
        int index = this.eVirtualPrimitiveIndex(eDerivedStructuralFeatureID, 0, primitives);
        if (index < 0) {
            index ^= 0xFFFFFFFF;
            primitives = this.resizePrimitiveArray(primitives, index += intialSize, 1);
            primitives[index] = value;
            this.eVirtualSet(-1, primitives);
            return value;
        }
        byte previousValue = primitives[index += intialSize];
        primitives[index] = value;
        return previousValue;
    }

    protected byte[] getPrimitivesValues() {
        Object o = this.eVirtualGet(-1, null);
        if (o == null || o == EVIRTUAL_NO_VALUE) {
            return null;
        }
        return (byte[])o;
    }

    protected double eVirtualSet(int eDerivedStructuralFeatureID, double value) {
        int intialSize = (this.eVirtualPrimitiveFeatureIDsCount() >>> 3) + 1;
        byte[] primitives = this.getPrimitivesValues();
        long lValue = Double.doubleToLongBits(value);
        if (primitives == null) {
            primitives = new byte[intialSize + 8];
            this.eVirtualPrimitiveIndex(eDerivedStructuralFeatureID, 0, primitives);
            this.setLong(lValue, primitives, intialSize);
            this.eVirtualSet(-1, primitives);
            return value;
        }
        int index = this.eVirtualPrimitiveIndex(eDerivedStructuralFeatureID, 0, primitives);
        if (index < 0) {
            index ^= 0xFFFFFFFF;
            primitives = this.resizePrimitiveArray(primitives, index += intialSize, 8);
            this.setLong(lValue, primitives, index);
            this.eVirtualSet(-1, primitives);
            return value;
        }
        long lPreviousValue = this.getLong(primitives, index += intialSize);
        this.setLong(lValue, primitives, index);
        return Double.longBitsToDouble(lPreviousValue);
    }

    protected float eVirtualSet(int eDerivedStructuralFeatureID, float value) {
        int intialSize = (this.eVirtualPrimitiveFeatureIDsCount() >>> 3) + 1;
        byte[] primitives = this.getPrimitivesValues();
        int iValue = Float.floatToIntBits(value);
        if (primitives == null) {
            primitives = new byte[intialSize + 4];
            this.eVirtualPrimitiveIndex(eDerivedStructuralFeatureID, 0, primitives);
            this.setInt(iValue, primitives, intialSize);
            this.eVirtualSet(-1, primitives);
            return value;
        }
        int index = this.eVirtualPrimitiveIndex(eDerivedStructuralFeatureID, 0, primitives);
        if (index < 0) {
            index ^= 0xFFFFFFFF;
            primitives = this.resizePrimitiveArray(primitives, index += intialSize, 4);
            this.setInt(iValue, primitives, index);
            this.eVirtualSet(-1, primitives);
            return value;
        }
        int previousValue = this.getInt(primitives, index += intialSize);
        this.setInt(iValue, primitives, index);
        return Float.intBitsToFloat(previousValue);
    }

    protected int eVirtualSet(int eDerivedStructuralFeatureID, int value) {
        int intialSize = (this.eVirtualPrimitiveFeatureIDsCount() >>> 3) + 1;
        byte[] primitives = this.getPrimitivesValues();
        if (primitives == null) {
            primitives = new byte[intialSize + 4];
            this.eVirtualPrimitiveIndex(eDerivedStructuralFeatureID, 0, primitives);
            this.setInt(value, primitives, intialSize);
            this.eVirtualSet(-1, primitives);
            return value;
        }
        int index = this.eVirtualPrimitiveIndex(eDerivedStructuralFeatureID, 0, primitives);
        if (index < 0) {
            index ^= 0xFFFFFFFF;
            primitives = this.resizePrimitiveArray(primitives, index += intialSize, 4);
            this.setInt(value, primitives, index);
            this.eVirtualSet(-1, primitives);
            return value;
        }
        byte previousValue = primitives[index += intialSize];
        this.setInt(value, primitives, index);
        return previousValue;
    }

    protected long eVirtualSet(int eDerivedStructuralFeatureID, long value) {
        int intialSize = (this.eVirtualPrimitiveFeatureIDsCount() >>> 3) + 1;
        byte[] primitives = this.getPrimitivesValues();
        if (primitives == null) {
            primitives = new byte[intialSize + 8];
            this.eVirtualPrimitiveIndex(eDerivedStructuralFeatureID, 0, primitives);
            this.setLong(value, primitives, intialSize);
            this.eVirtualSet(-1, primitives);
            return value;
        }
        int index = this.eVirtualPrimitiveIndex(eDerivedStructuralFeatureID, 0, primitives);
        if (index < 0) {
            index ^= 0xFFFFFFFF;
            primitives = this.resizePrimitiveArray(primitives, index += intialSize, 8);
            this.setLong(value, primitives, index);
            this.eVirtualSet(-1, primitives);
            return value;
        }
        long previousValue = this.getLong(primitives, index += intialSize);
        this.setLong(value, primitives, index);
        return previousValue;
    }

    protected short eVirtualSet(int eDerivedStructuralFeatureID, short value) {
        int intialSize = (this.eVirtualPrimitiveFeatureIDsCount() >>> 3) + 1;
        byte[] primitives = this.getPrimitivesValues();
        if (primitives == null) {
            primitives = new byte[intialSize + 2];
            this.eVirtualPrimitiveIndex(eDerivedStructuralFeatureID, 0, primitives);
            this.setShort(value, primitives, intialSize);
            this.eVirtualSet(-1, primitives);
            return value;
        }
        int index = this.eVirtualPrimitiveIndex(eDerivedStructuralFeatureID, 0, primitives);
        if (index < 0) {
            index ^= 0xFFFFFFFF;
            primitives = this.resizePrimitiveArray(primitives, index += intialSize, 2);
            this.setShort(value, primitives, index);
            this.eVirtualSet(-1, primitives);
            return value;
        }
        short previousValue = this.getShort(primitives, index += intialSize);
        this.setShort(value, primitives, index);
        return previousValue;
    }

    protected Object[] eVirtualValues() {
        Object data = this.getData();
        if (data != null && data instanceof Object[]) {
            return (Object[])data;
        }
        return null;
    }

    protected int getInt(byte[] primitives, int index) {
        return (primitives[index] << 24) + ((primitives[index + 1] & 0xFF) << 16) + ((primitives[index + 2] & 0xFF) << 8) + ((primitives[index + 3] & 0xFF) << 0);
    }

    protected long getLong(byte[] primitives, int index) {
        return ((long)primitives[index] << 56) + ((long)(primitives[index + 1] & 0xFF) << 48) + ((long)(primitives[index + 2] & 0xFF) << 40) + ((long)(primitives[index + 3] & 0xFF) << 32) + ((long)(primitives[index + 4] & 0xFF) << 24) + (long)((primitives[index + 5] & 0xFF) << 16) + (long)((primitives[index + 6] & 0xFF) << 8) + (long)((primitives[index + 7] & 0xFF) << 0);
    }

    protected short getShort(byte[] primitives, int index) {
        return (short)((primitives[index] << 8) + (primitives[index + 1] << 0));
    }

    protected byte[] resizePrimitiveArray(byte[] primitives, int index, int deltaSize) {
        byte[] temp = new byte[primitives.length + deltaSize];
        if (index > 0) {
            System.arraycopy(primitives, 0, temp, 0, index);
        }
        if (index < primitives.length) {
            System.arraycopy(primitives, index, temp, index + deltaSize, primitives.length - index);
        }
        return temp;
    }

    protected void setInt(int value, byte[] primitives, int index) {
        primitives[index] = (byte)(value >>> 24);
        primitives[index + 1] = (byte)(value >>> 16);
        primitives[index + 2] = (byte)(value >>> 8);
        primitives[index + 3] = (byte)(value >>> 0);
    }

    protected void setLong(long value, byte[] primitives, int index) {
        primitives[index] = (byte)(value >>> 56);
        primitives[index + 1] = (byte)(value >>> 48);
        primitives[index + 2] = (byte)(value >>> 40);
        primitives[index + 3] = (byte)(value >>> 32);
        primitives[index + 4] = (byte)(value >>> 24);
        primitives[index + 5] = (byte)(value >>> 16);
        primitives[index + 6] = (byte)(value >>> 8);
        primitives[index + 7] = (byte)(value >>> 0);
    }

    protected void setShort(short value, byte[] primitives, int index) {
        primitives[index] = (byte)(value >>> 8 & 0xFF);
        primitives[index + 1] = (byte)(value >>> 0 & 0xFF);
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName());
        result.append('@');
        result.append(Integer.toHexString(((Object)((Object)this)).hashCode()));
        if (this.eIsProxy()) {
            result.append(" (eProxyURI: ");
            result.append(this.eProxyURI());
            if (this.eDynamicClass() != null) {
                result.append(" eClass: ");
                result.append(this.eDynamicClass());
            }
            result.append(')');
        } else if (this.eStaticClass() != null) {
            result.append(" (eClass: ");
            result.append(this.eStaticClass());
            result.append(')');
        }
        return result.toString();
    }
}

