/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.hierarchy.util.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.util.internal.QueryUtils;
import org.eclipse.hyades.models.hierarchy.util.internal.SSQEEvalResult;
import org.eclipse.hyades.models.hierarchy.util.internal.SimpleSearchQueryEngine;

public class ImportFilterEngine
extends SimpleSearchQueryEngine {
    protected Map excludeIdsByFeatureIndex = new HashMap();
    protected HashMap evalResults = new HashMap();

    public ImportFilterEngine(SimpleSearchQuery query, ResourceSet targetResourceSet) {
        super(query, targetResourceSet);
    }

    public boolean isFiltered(EStructuralFeature sf, Object id, Object value) {
        if (this._query == null) {
            return false;
        }
        if (value != null) {
            return this.evaluateAndUpdateIndexes(sf, id, value);
        }
        return this.internalIsFiltered(sf, id);
    }

    protected boolean internalIsFiltered(EStructuralFeature sf, Object id) {
        Set ids = (Set)this.excludeIdsByFeatureIndex.get(sf);
        return ids != null && ids.contains(id);
    }

    protected boolean evaluateAndUpdateIndexes(EStructuralFeature sf, Object id, Object value) {
        if (!this.evaluate(sf, id, value)) {
            this.addExcludedId(sf, id);
            return true;
        }
        return false;
    }

    public void addExcludedId(EStructuralFeature sf, Object id) {
        HashSet<Object> ids = (HashSet<Object>)this.excludeIdsByFeatureIndex.get(sf);
        if (ids == null) {
            ids = new HashSet<Object>();
            this.excludeIdsByFeatureIndex.put(sf, ids);
        }
        ids.add(id);
    }

    protected boolean evaluate(EStructuralFeature sf, Object id, Object value) {
        SSQEEvalResult evalResult = (SSQEEvalResult)this.evalResults.get(sf);
        if (evalResult == null) {
            evalResult = this.prepareEvalResult(sf);
            this.evalResults.put(sf, evalResult);
        }
        evalResult.evalOnly(sf, value);
        if (evalResult.isComplete() && evalResult.booleanValue().booleanValue()) {
            evalResult.resetOnly(sf);
            return true;
        }
        evalResult.resetOnly(sf);
        return false;
    }

    public boolean isFiltered(EStructuralFeature sf, Object id) {
        if (this._query == null) {
            return false;
        }
        return this.internalIsFiltered(sf, id);
    }

    public void init() {
        this.prepareResult();
        this.populateRootNodesAndClasses();
        this.buildRequiredTraversalPaths();
        this.indexWhereExpression();
        this.evalResults.clear();
    }

    protected SSQEEvalResult prepareEvalResult(EStructuralFeature sf) {
        SimpleSearchQuery tempQuery = this._query;
        HashSet<EStructuralFeature> sfs = new HashSet<EStructuralFeature>();
        sfs.add(sf);
        this._query = QueryUtils.removeFeatures(this._query, sfs, false);
        SSQEEvalResult evalResult = this._queryEvaluator.prepareEvalResult();
        this._query = tempQuery;
        return evalResult;
    }
}

