/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.hierarchy.util.internal;

import org.eclipse.hyades.models.hierarchy.util.IntList;

public class IntListImpl
implements IntList {
    protected int[] data;
    protected int size;

    public IntListImpl() {
        this.data = new int[10];
        this.size = 0;
    }

    public IntListImpl(int initialCapacity) {
        this.data = new int[initialCapacity];
        this.size = 0;
    }

    public IntList compact() {
        int[] newData = new int[this.size];
        System.arraycopy(this.data, 0, newData, 0, this.size);
        this.data = newData;
        return this;
    }

    public int set(int value, int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        int oldValue = this.data[index];
        this.data[index] = value;
        return oldValue;
    }

    public int size() {
        return this.size;
    }

    public IntList add(int value) {
        this.ensureCapacity(this.size + 1);
        this.data[this.size++] = value;
        return this;
    }

    public IntList add(int value, int index) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.data, index, this.data, index + 1, this.size - index);
        this.data[index] = value;
        ++this.size;
        return this;
    }

    protected void ensureCapacity(int index) {
        int oldCapacity;
        if (index >= this.data.length && index > (oldCapacity = this.data.length)) {
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < index) {
                newCapacity = index;
            }
            int[] newData = new int[newCapacity];
            System.arraycopy(this.data, 0, newData, 0, this.size);
            this.data = newData;
        }
    }

    public int get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        return this.data[index];
    }

    public int indexOf(int value, int startIndex) {
        if (startIndex < 0) {
            throw new IndexOutOfBoundsException("Index: " + startIndex + ", Size: " + this.size);
        }
        int i = startIndex;
        while (i < this.size) {
            if (this.data[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int lastIndexOf(int value, int endIndex) {
        if (endIndex < 0) {
            throw new IndexOutOfBoundsException("Index: " + endIndex + ", Size: " + this.size);
        }
        int i = endIndex;
        while (i-- > 0) {
            if (this.data[i] != value) continue;
            return i;
        }
        return -1;
    }

    public int[] getValues() {
        return this.data;
    }

    public IntList clear() {
        this.data = new int[0];
        this.size = 0;
        return this;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        int i = 0;
        while (i < this.size) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.data[i]);
            ++i;
        }
        buf.append("]");
        return buf.toString();
    }

    public int[] toArray() {
        if (this.data == null && this.data.length == 0) {
            return new int[0];
        }
        int[] res = new int[this.size];
        System.arraycopy(this.data, 0, res, 0, this.size);
        return res;
    }
}

