/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.hierarchy.util.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.hyades.models.hierarchy.util.LongToObjectMap;
import org.eclipse.hyades.models.hierarchy.util.PerfUtil;
import org.eclipse.hyades.models.hierarchy.util.internal.SizesAsPrimes;
import org.eclipse.hyades.models.util.ModelDebugger;

public class LongToObjectMapImpl
implements LongToObjectMap {
    public static final float GROWTH_FACTOR = 1.25f;
    public static final long MASK = Long.MAX_VALUE;
    public static final long MISSING_KEY = 0L;
    public static final Object MISSING_VALUE = null;
    protected PerfUtil p = PerfUtil.createInstance();
    protected int elementSize;
    protected int putIterations;
    protected long[] keyTable;
    protected int threshold;
    protected Object[] valueTable;
    protected int getIterations;

    public static void main(String[] args) {
        int nrKeys = 25;
        LongToObjectMapImpl longMap = new LongToObjectMapImpl();
        int i = 1;
        while (i <= nrKeys) {
            try {
                longMap.put(i, (Object)new Integer(i));
            }
            catch (Exception e) {
                System.out.println("i=" + i);
                e.printStackTrace();
                System.exit(-1);
            }
            ++i;
        }
        System.out.println(longMap);
        longMap.remove(10L);
        longMap.remove(5L);
        System.out.println(longMap);
        System.out.println("List keys:");
        i = 1;
        while (i <= nrKeys) {
            try {
                System.out.println(String.valueOf(i) + " -> " + longMap.get(i));
                System.out.println(String.valueOf(i) + " -> " + longMap.get(new Integer(i)));
            }
            catch (Exception e) {
                System.out.println("i=" + i);
                e.printStackTrace();
                System.exit(-1);
            }
            ++i;
        }
        longMap.put(new Integer(10), new Integer(10));
        longMap.put(new Integer(5), new Integer(5));
        System.out.println(longMap);
        Set set = longMap.entrySet();
        System.out.println("List entrySet.size=" + set.size() + ", entries:");
        for (Map.Entry element : set) {
            System.out.println(element.getKey() + " -> " + element.getValue());
        }
        set = longMap.keySet();
        System.out.println("List keySet.size=" + set.size() + ", entries:");
        for (Map.Entry element : set) {
            System.out.println(element + " -> " + longMap.get(element));
            System.out.println(String.valueOf(((Object)element).hashCode()) + " -> " + longMap.get(((Object)element).hashCode()));
        }
        longMap.clear();
        nrKeys = 10000000;
        PerfUtil p = PerfUtil.createInstance();
        p.setDebug(true);
        p.setMessageAndStart("LongToObjectMap generate nrKeys=" + nrKeys);
        Integer[] keys = new Integer[nrKeys + 1];
        int i2 = nrKeys + 1;
        while (i2-- > 1) {
            keys[i2] = new Integer(i2);
        }
        p.stopAndPrintStatus();
        int j = 0;
        while (j < 10) {
            System.gc();
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            System.out.println("LongToObjectMapImpl.main() - j=" + j);
            p.setMessageAndStart("LongToObjectMap add long descending nrKeys=" + nrKeys);
            int i3 = nrKeys + 1;
            while (i3-- > 1) {
                longMap.put(i3, (Object)keys[i3]);
                if (nrKeys - i3 + 1 == longMap.size()) continue;
                System.out.println("Error at key=" + i3);
            }
            p.stopAndPrintStatus("keyTable.length=" + longMap.getKeys().length);
            longMap.clear();
            p.setMessageAndStart("LongToObjectMap add long ascending nrKeys=" + nrKeys);
            ++nrKeys;
            i3 = 1;
            while (i3 < nrKeys) {
                longMap.put(i3, (Object)keys[i3]);
                ++i3;
            }
            p.stopAndPrintStatus("keyTable.length=" + longMap.getKeys().length);
            p.setMessageAndStart("LongToObjectMap get long descending nrKeys=" + --nrKeys);
            i3 = nrKeys + 1;
            while (i3-- > 1) {
                Object v = longMap.get(i3);
                try {
                    if (v != null && (Integer)v == i3) continue;
                    System.out.println("Invalid entry at: " + i3);
                }
                catch (Exception e) {
                    System.err.println("Invalid entry at: " + i3);
                    e.printStackTrace();
                }
            }
            p.stopAndPrintStatus("keyTable.length=" + longMap.getKeys().length);
            p.setMessageAndStart("LongToObjectMap remove and compact long descending nrKeys=" + nrKeys);
            i3 = nrKeys + 1;
            while (i3-- > 1) {
                longMap.remove(i3);
            }
            longMap.compact();
            p.stopAndPrintStatus("keyTable.length=" + longMap.getKeys().length);
            HashMap<Integer, Integer> hMap = new HashMap<Integer, Integer>(89);
            p.setMessageAndStart("HashMap add descending nrKeys=" + nrKeys);
            int i4 = nrKeys + 1;
            while (i4-- > 1) {
                hMap.put(keys[i4], keys[i4]);
            }
            p.stopAndPrintStatus();
            hMap.clear();
            p.setMessageAndStart("HashMap add ascending nrKeys=" + nrKeys);
            ++nrKeys;
            i4 = 1;
            while (i4 < nrKeys) {
                hMap.put(keys[i4], keys[i4]);
                ++i4;
            }
            p.stopAndPrintStatus();
            p.setMessageAndStart("HashMap get descending nrKeys=" + --nrKeys);
            i4 = nrKeys + 1;
            while (i4-- > 1) {
                hMap.get(keys[i4]);
            }
            p.stopAndPrintStatus();
            p.setMessageAndStart("HashMap remove descending nrKeys=" + nrKeys);
            i4 = nrKeys + 1;
            while (i4-- > 1) {
                hMap.remove(keys[i4]);
            }
            p.stopAndPrintStatus();
            p.setMessageAndStart("LongToObjectMap add object descending nrKeys=" + nrKeys);
            i4 = nrKeys + 1;
            while (i4-- > 1) {
                longMap.put(keys[i4], keys[i4]);
            }
            p.stopAndPrintStatus("keyTable.length=" + longMap.getKeys().length);
            longMap.clear();
            p.setMessageAndStart("LongToObjectMap add object ascending nrKeys=" + nrKeys);
            ++nrKeys;
            i4 = 1;
            while (i4 < nrKeys) {
                longMap.put(keys[i4], keys[i4]);
                ++i4;
            }
            p.stopAndPrintStatus();
            p.setMessageAndStart("LongToObjectMap get object descending nrKeys=" + --nrKeys);
            i4 = nrKeys + 1;
            while (i4-- > 1) {
                longMap.get(keys[i4]);
            }
            p.stopAndPrintStatus("keyTable.length=" + longMap.getKeys().length);
            p.setMessageAndStart("LongToObjectMap remove and compact object descending nrKeys=" + nrKeys);
            i4 = nrKeys + 1;
            while (i4-- > 1) {
                longMap.remove(keys[i4]);
            }
            longMap.compact();
            p.stopAndPrintStatus("keyTable.length=" + longMap.getKeys().length);
            ++j;
        }
    }

    public LongToObjectMapImpl() {
        this.init(13);
    }

    public LongToObjectMapImpl(int size) {
        this.init(size);
    }

    public void clear() {
        this.init(13);
    }

    public int compact() {
        long[] kt = this.keyTable;
        Object[] vt = this.valueTable;
        int newElementSize = 0;
        int i = kt.length;
        while (i-- > 0) {
            if (kt[i] == 0L || vt[i] == MISSING_VALUE) continue;
            ++newElementSize;
        }
        this.elementSize = newElementSize;
        this.rehash();
        return newElementSize;
    }

    protected int computeNewSize(int oldSize) {
        int extraRoom = (int)((float)oldSize * 1.25f);
        if (this.threshold == extraRoom) {
            ++extraRoom;
        }
        extraRoom = SizesAsPrimes.getSize(1.25f, extraRoom);
        return extraRoom;
    }

    public boolean containsKey(long key) {
        int index;
        if (key == 0L) {
            --key;
        }
        return (index = this.getIndex(key)) != -1;
    }

    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        return this.containsKey(key.hashCode());
    }

    public boolean containsValue(Object value) {
        if (value == MISSING_VALUE) {
            return false;
        }
        long[] kt = this.keyTable;
        Object[] vt = this.valueTable;
        int i = vt.length;
        while (i-- > 0) {
            if (kt[i] == 0L || vt[i] != value) continue;
            return true;
        }
        return false;
    }

    public Set entrySet() {
        HashSet<1> entries = new HashSet<1>();
        int i = 0;
        while (i < this.keyTable.length) {
            if (this.keyTable[i] != 0L) {
                final long currentKey = this.keyTable[i];
                Map.Entry entry = new Map.Entry(){
                    Object key;
                    Object value;

                    public Object getKey() {
                        return this.key;
                    }

                    public Object getValue() {
                        return this.value;
                    }

                    public Object setValue(Object value) {
                        if (this.key != null) {
                            throw new UnsupportedOperationException();
                        }
                        this.value = value;
                        this.key = new Long(currentKey);
                        return value;
                    }
                };
                entry.setValue(this.valueTable[i]);
                entries.add(entry);
            }
            ++i;
        }
        return entries;
    }

    public Object get(long key) {
        int index;
        if (key == 0L) {
            --key;
        }
        if ((index = this.getIndex(key)) != -1) {
            return this.valueTable[index];
        }
        return MISSING_VALUE;
    }

    public Object get(Object key) {
        if (key == null) {
            return MISSING_VALUE;
        }
        return this.get(key.hashCode());
    }

    protected int getFreeSpot(long key, long[] kt) {
        long currentKey;
        int length = kt.length;
        int index = (int)((key & Long.MAX_VALUE) % (long)length);
        while ((currentKey = kt[index]) != 0L) {
            if (currentKey == key) {
                return -index;
            }
            index = (index + 1) % length;
            ++this.putIterations;
        }
        return index;
    }

    protected int getIndex(long key) {
        long currentKey;
        int length = this.keyTable.length;
        int index = (int)((key & Long.MAX_VALUE) % (long)length);
        long[] kt = this.keyTable;
        while ((currentKey = kt[index]) != 0L) {
            if (currentKey == key) {
                return index;
            }
            index = (index + 1) % length;
            ++this.getIterations;
        }
        return -1;
    }

    public long[] getKeys() {
        return this.keyTable;
    }

    public Object[] getValues() {
        return this.valueTable;
    }

    protected void init(int size) {
        this.elementSize = 0;
        this.threshold = size;
        int extraRoom = this.computeNewSize(size);
        this.keyTable = new long[extraRoom];
        this.valueTable = new Object[extraRoom];
    }

    public boolean isEmpty() {
        return this.elementSize == 0;
    }

    public Set keySet() {
        HashSet<Long> keys = new HashSet<Long>();
        int i = 0;
        while (i < this.keyTable.length) {
            if (this.keyTable[i] != 0L) {
                keys.add(new Long(this.keyTable[i]));
            }
            ++i;
        }
        return keys;
    }

    public Object put(long key, Object value) {
        int index;
        if (key == 0L) {
            --key;
        }
        if ((index = this.getFreeSpot(key, this.keyTable)) < 0) {
            index = -index;
            Object oldValue = this.valueTable[index];
            this.valueTable[index] = value;
            return oldValue;
        }
        this.keyTable[index] = key;
        Object oldValue = this.valueTable[index];
        this.valueTable[index] = value;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return oldValue;
    }

    public Object put(Object key, Object value) {
        if (key == null) {
            return value;
        }
        return this.put(key.hashCode(), value);
    }

    public void putAll(Map t) {
        for (Map.Entry element : this.entrySet()) {
            this.put(element.getKey(), element.getValue());
        }
    }

    protected void rehash() {
        if (ModelDebugger.INSTANCE.debugCustomMaps) {
            this.p.setMessageAndStart("IntToObjectMapImpl.rehash() firstValueType=" + this.getFirstValueTypeName() + ", elementSize=" + this.elementSize + ", oldGetIterations=" + this.getIterations + ", oldPutIterations=" + this.putIterations + ", oldKeyTable.lenght=" + this.keyTable.length);
        }
        this.threshold = (int)((float)this.elementSize * 1.25f);
        int extraRoom = this.computeNewSize(this.threshold);
        this.getIterations = 0;
        this.putIterations = 0;
        this.rehash(extraRoom);
        if (ModelDebugger.INSTANCE.debugCustomMaps) {
            this.p.stopAndPrintStatus("newGetIterations=" + this.getIterations + ", newPutIterations=" + this.putIterations + ", newKeyTable.lenght=" + this.keyTable.length);
        }
        this.putIterations = 0;
        this.getIterations = 0;
    }

    protected String getFirstValueTypeName() {
        if (ModelDebugger.INSTANCE.debug) {
            int i = 0;
            while (i < this.valueTable.length) {
                if (this.valueTable[i] != MISSING_VALUE) {
                    return this.valueTable[i].getClass().getName();
                }
                ++i;
            }
            return "null";
        }
        return "";
    }

    protected void rehash(int newSize) {
        long[] oKT = this.keyTable;
        Object[] oVT = this.valueTable;
        int oL = oKT.length;
        long[] nKT = new long[newSize];
        Object[] nVT = new Object[newSize];
        this.elementSize = 0;
        int i = oL;
        while (i-- > 0) {
            if (oKT[i] == 0L || oVT[i] == MISSING_VALUE) continue;
            long o = oKT[i];
            int index = this.getFreeSpot(o, nKT);
            if (index < 0) {
                index = -index;
            }
            nKT[index] = o;
            nVT[index] = oVT[i];
            ++this.elementSize;
        }
        this.keyTable = nKT;
        this.valueTable = nVT;
    }

    public Object remove(long key) {
        int index;
        if (key == 0L) {
            --key;
        }
        if ((index = this.getIndex(key)) != -1) {
            Object oldValue = this.valueTable[index];
            this.valueTable[index] = MISSING_VALUE;
            return oldValue;
        }
        return MISSING_VALUE;
    }

    public Object remove(Object key) {
        if (key == null) {
            return MISSING_VALUE;
        }
        return this.remove(key.hashCode());
    }

    public int size() {
        return this.elementSize;
    }

    public String toString() {
        String s = "LongToObjectMapImpl elementSize=" + this.elementSize + ", keyTable.length=" + this.keyTable.length + ", entries:\n";
        int i = 0;
        int length = this.keyTable.length;
        while (i < length) {
            Object object;
            if (this.keyTable[i] != 0L && (object = this.valueTable[i]) != MISSING_VALUE) {
                s = String.valueOf(s) + this.keyTable[i] + " -> " + object + "\n";
            }
            ++i;
        }
        return s;
    }

    public Collection values() {
        return Arrays.asList(this.valueTable);
    }
}

