/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.hierarchy.util.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.Operand;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleOperand;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.extensions.TimeBasedCorrelationQuery;
import org.eclipse.hyades.models.hierarchy.extensions.WhereExpression;
import org.eclipse.hyades.models.hierarchy.util.ContainmentTraverser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryUtils {
    public static final String DOLLAR_SIGN = "$";
    private static Map<EClass, Set<EClass>> _subTypesIndex = new HashMap<EClass, Set<EClass>>();

    public static SimpleSearchQuery removeClasses(SimpleSearchQuery simpleSearchQuery, final Set<EClass> classes) {
        SimpleSearchQuery query = (SimpleSearchQuery)EcoreUtil.copy((EObject)simpleSearchQuery);
        final HashMap alreadyProcessed = new HashMap();
        final HashSet<EObject> removeSet = new HashSet<EObject>();
        ArrayList<WhereExpression> roots = new ArrayList<WhereExpression>();
        roots.add(query.getWhereExpression());
        ContainmentTraverser containmentTraverser = new ContainmentTraverser(roots){

            protected boolean beforeChildren(EObject element) {
                String name = QueryUtils.getElementName(element);
                if (name != null && name.startsWith(QueryUtils.DOLLAR_SIGN)) {
                    return super.beforeChildren(element);
                }
                if (alreadyProcessed.containsKey(element)) {
                    return super.beforeChildren(element);
                }
                alreadyProcessed.put(element, null);
                if (element instanceof SimpleOperand) {
                    BinaryExpression be;
                    SimpleOperand o = (SimpleOperand)element;
                    EClass c = o.getType();
                    if (c == null && o.getFeature() != null) {
                        c = o.getFeature().getEContainingClass();
                    }
                    if (c != null && classes.contains(c) && (be = QueryUtils.getParentBinaryExpression(o)) != null) {
                        removeSet.add(be);
                    }
                }
                return super.beforeChildren(element);
            }
        };
        containmentTraverser.traverse();
        QueryUtils.removeElementsAndCompactQuery(query, removeSet);
        return query;
    }

    public static SimpleSearchQuery removeFeatures(SimpleSearchQuery simpleSearchQuery, final Set features, final boolean include) {
        SimpleSearchQuery query = (SimpleSearchQuery)EcoreUtil.copy((EObject)simpleSearchQuery);
        final HashMap alreadyProcessed = new HashMap();
        final HashSet<EObject> removeSet = new HashSet<EObject>();
        ArrayList<WhereExpression> roots = new ArrayList<WhereExpression>();
        roots.add(query.getWhereExpression());
        ContainmentTraverser containmentTraverser = new ContainmentTraverser(roots){

            protected boolean beforeChildren(EObject element) {
                SimpleOperand o;
                EStructuralFeature f;
                String name = QueryUtils.getElementName(element);
                if (name != null && name.startsWith(QueryUtils.DOLLAR_SIGN)) {
                    return super.beforeChildren(element);
                }
                if (alreadyProcessed.containsKey(element)) {
                    return super.beforeChildren(element);
                }
                alreadyProcessed.put(element, null);
                if (element instanceof SimpleOperand && (f = (o = (SimpleOperand)element).getFeature()) != null) {
                    BinaryExpression be;
                    if (features.contains(f)) {
                        BinaryExpression be2;
                        if (include && (be2 = QueryUtils.getParentBinaryExpression(o)) != null) {
                            removeSet.add(be2);
                        }
                    } else if (!include && (be = QueryUtils.getParentBinaryExpression(o)) != null) {
                        removeSet.add(be);
                    }
                }
                return super.beforeChildren(element);
            }
        };
        containmentTraverser.traverse();
        QueryUtils.removeElementsAndCompactQuery(query, removeSet);
        return query;
    }

    public static BinaryExpression getParentBinaryExpression(EObject o) {
        if (o != null) {
            if (o instanceof BinaryExpression) {
                return (BinaryExpression)o;
            }
            return QueryUtils.getParentBinaryExpression(o.eContainer());
        }
        return null;
    }

    public static void removeElementsAndCompactQuery(SimpleSearchQuery query, Set<EObject> elements) {
        for (EObject element : elements) {
            QueryUtils.removeElementAndCompactContainers(element);
        }
    }

    public static void removeElementAndCompactContainers(EObject element) {
        if (element == null) {
            return;
        }
        EObject container = element.eContainer();
        if (container == null) {
            return;
        }
        if (container instanceof LogicalExpression) {
            LogicalExpression le = (LogicalExpression)container;
            le.getArguments().remove((Object)element);
            if (le.getArguments().isEmpty()) {
                QueryUtils.removeElementAndCompactContainers(le);
            } else {
                QueryUtils.compactWhereExpression(le);
            }
        }
    }

    public static void compactWhereExpression(WhereExpression we) {
        if (we instanceof LogicalExpression && ((LogicalExpression)we).getArguments().size() > 0) {
            QueryUtils.compactLogicalExpression((LogicalExpression)we);
            return;
        }
        QueryUtils.compactBinaryExpression((BinaryExpression)we);
    }

    public static void compactLogicalExpression(LogicalExpression le) {
        if (le.getArguments().size() == 1 && le.getOperator() == LogicalOperators.NOT_LITERAL) {
            return;
        }
        if (le.getArguments().size() > 1) {
            return;
        }
        EObject container = le.eContainer();
        if (container == null) {
            return;
        }
        if (container instanceof LogicalExpression) {
            LogicalExpression c = (LogicalExpression)container;
            if (le.getArguments().size() == 1) {
                c.getArguments().set(c.getArguments().indexOf((Object)le), (Object)((WhereExpression)le.getArguments().get(0)));
            } else {
                c.getArguments().remove((Object)le);
            }
            QueryUtils.compactLogicalExpression(c);
        }
    }

    public static void compactBinaryExpression(BinaryExpression be) {
        if (be.getRightOperands().size() > 0) {
            return;
        }
        EObject container = be.eContainer();
        if (container == null) {
            return;
        }
        if (container instanceof LogicalExpression) {
            LogicalExpression c = (LogicalExpression)container;
            c.getArguments().remove((Object)be);
            QueryUtils.compactLogicalExpression(c);
        }
    }

    public static String getElementName(EObject element) {
        if (element instanceof WhereExpression) {
            return ((WhereExpression)element).getName();
        }
        if (element instanceof Operand) {
            return ((Operand)element).getName();
        }
        return element.toString();
    }

    public static Set<EClass> getAllSubTypes(EClass c) {
        Set<EClass> s = _subTypesIndex.get(c);
        if (s == null) {
            s = new HashSet<EClass>();
            _subTypesIndex.put(c, s);
            for (Map.Entry packageEntry : EPackage.Registry.INSTANCE.entrySet()) {
                if (packageEntry.getValue() == null || !(packageEntry.getValue() instanceof EPackage)) continue;
                for (EClassifier classifier : ((EPackage)packageEntry.getValue()).getEClassifiers()) {
                    EClass class1;
                    if (!(classifier instanceof EClass) || !(class1 = (EClass)classifier).getEAllSuperTypes().contains((Object)c)) continue;
                    s.add(class1);
                }
            }
        }
        return s;
    }

    public static void addSubTypes(EClass c, Map<EClass, Collection<EObject>> m, Collection<EObject> l) {
        for (EClass element : QueryUtils.getAllSubTypes(c)) {
            Collection<EObject> l1 = m.get(element);
            if (l1 != null) {
                l1.addAll(l);
                continue;
            }
            m.put(element, l);
        }
    }

    public static void addSuperTypes(EClass c, Map<EClass, Collection<EObject>> m, Collection<EObject> l) {
        for (EClass element : c.getEAllSuperTypes()) {
            Collection<EObject> l1 = m.get(element);
            if (l1 != null) {
                l1.addAll(l);
                continue;
            }
            m.put(element, l);
        }
    }

    public static void addSuperTypes(EClass c, Collection<Object> s) {
        for (EClass element : c.getEAllSuperTypes()) {
            s.add(element);
        }
    }

    public static void addSubTypes(EClass c, Collection<Object> s) {
        for (EClass element : QueryUtils.getAllSubTypes(c)) {
            s.add(element);
        }
    }

    public static Map<EClass, Collection<EObject>> getClassPredicatesIndex(SimpleSearchQuery query) {
        final HashMap whereExpressionValuesIndex = new HashMap();
        final HashMap<EClass, Collection<EObject>> classPredicatesIndex = new HashMap<EClass, Collection<EObject>>();
        final HashMap namesIndex = new HashMap();
        ArrayList<WhereExpression> roots = new ArrayList<WhereExpression>();
        roots.add(query.getWhereExpression());
        ContainmentTraverser containmentTraverser = new ContainmentTraverser(roots){

            protected boolean beforeChildren(EObject element) {
                String name = QueryUtils.getElementName(element);
                if (name != null && name.startsWith(QueryUtils.DOLLAR_SIGN)) {
                    return super.beforeChildren(element);
                }
                if (whereExpressionValuesIndex.containsKey(element)) {
                    return super.beforeChildren(element);
                }
                whereExpressionValuesIndex.put(element, null);
                if (element instanceof SimpleOperand) {
                    SimpleOperand o = (SimpleOperand)element;
                    EClass c = o.getType();
                    if (c != null) {
                        HashSet<EObject> l = (HashSet<EObject>)classPredicatesIndex.get(c);
                        if (l == null) {
                            l = new HashSet<EObject>();
                            classPredicatesIndex.put(c, l);
                            QueryUtils.addSubTypes(c, classPredicatesIndex, l);
                        }
                        l.add(element);
                    } else if (o.getFeature() != null) {
                        c = o.getFeature().getEContainingClass();
                        HashSet<EObject> l = (HashSet<EObject>)classPredicatesIndex.get(c);
                        if (l == null) {
                            l = new HashSet<EObject>();
                            classPredicatesIndex.put(c, l);
                            QueryUtils.addSubTypes(c, classPredicatesIndex, l);
                        }
                        l.add(element);
                    }
                }
                if (name != null) {
                    namesIndex.put(name, element);
                }
                return super.beforeChildren(element);
            }
        };
        containmentTraverser.traverse();
        return classPredicatesIndex;
    }

    private static Map<EClass, List<EObject>> getClassPredicatesNoSubClassesIndex(SimpleSearchQuery query) {
        final HashMap whereExpressionValuesIndex = new HashMap();
        final HashMap<EClass, List<EObject>> classPredicatesIndex = new HashMap<EClass, List<EObject>>();
        final HashMap namesIndex = new HashMap();
        ArrayList<WhereExpression> roots = new ArrayList<WhereExpression>();
        if (query.getWhereExpression() == null) {
            return classPredicatesIndex;
        }
        roots.add(query.getWhereExpression());
        ContainmentTraverser containmentTraverser = new ContainmentTraverser(roots){

            protected boolean beforeChildren(EObject element) {
                String name = QueryUtils.getElementName(element);
                if (name != null && name.startsWith(QueryUtils.DOLLAR_SIGN)) {
                    return super.beforeChildren(element);
                }
                if (whereExpressionValuesIndex.containsKey(element)) {
                    return super.beforeChildren(element);
                }
                whereExpressionValuesIndex.put(element, null);
                if (element instanceof SimpleOperand) {
                    SimpleOperand o = (SimpleOperand)element;
                    EClass c = o.getType();
                    if (c != null) {
                        ArrayList<EObject> l = (ArrayList<EObject>)classPredicatesIndex.get(c);
                        if (l == null) {
                            l = new ArrayList<EObject>();
                            classPredicatesIndex.put(c, l);
                        }
                        if (!l.contains(element)) {
                            l.add(element);
                        }
                    } else if (o.getFeature() != null) {
                        c = o.getFeature().getEContainingClass();
                        ArrayList<EObject> l = (ArrayList<EObject>)classPredicatesIndex.get(c);
                        if (l == null) {
                            l = new ArrayList<EObject>();
                            classPredicatesIndex.put(c, l);
                        }
                        if (!l.contains(element)) {
                            l.add(element);
                        }
                    }
                }
                if (name != null) {
                    namesIndex.put(name, element);
                }
                return super.beforeChildren(element);
            }
        };
        containmentTraverser.traverse();
        return classPredicatesIndex;
    }

    public static void removeClass(SimpleSearchQuery searchQuery, EClass clazz) {
        HashSet<EClass> s = new HashSet<EClass>();
        s.add(clazz);
        QueryUtils.removeClasses(searchQuery, s);
    }

    public static SimpleSearchQuery getEmptyQuery() {
        SimpleSearchQuery query = ExtensionsFactory.eINSTANCE.createSimpleSearchQuery();
        query.setName("EmptyFilter");
        LogicalExpression logicalExpression = ExtensionsFactory.eINSTANCE.createLogicalExpression();
        logicalExpression.setOperator(LogicalOperators.AND_LITERAL);
        query.setWhereExpression(logicalExpression);
        return query;
    }

    public static TimeBasedCorrelationQuery getEmptyTimeBasedCorrelationQuery() {
        TimeBasedCorrelationQuery query = ExtensionsFactory.eINSTANCE.createTimeBasedCorrelationQuery();
        query.setName("EmptyFilter");
        LogicalExpression logicalExpression = ExtensionsFactory.eINSTANCE.createLogicalExpression();
        logicalExpression.setOperator(LogicalOperators.AND_LITERAL);
        query.setWhereExpression(logicalExpression);
        return query;
    }

    public static int like(String lhs, String rhs) {
        int lhs_pos = 0;
        int rhs_pos = 0;
        int lhs_len = lhs.length();
        int rhs_len = rhs.length();
        int wildcard = -1;
        int curent_lhs_pos = -1;
        while (true) {
            if (rhs_pos < rhs_len && rhs.charAt(rhs_pos) == '*') {
                wildcard = ++rhs_pos;
                curent_lhs_pos = lhs_pos;
                continue;
            }
            if (lhs_pos == lhs_len) {
                if (rhs_pos < rhs_len) {
                    return -1;
                }
                return rhs_pos == rhs_len ? 0 : 1;
            }
            if (rhs_pos < rhs_len && (lhs.charAt(lhs_pos) == rhs.charAt(rhs_pos) || rhs.charAt(rhs_pos) == '?')) {
                ++lhs_pos;
                ++rhs_pos;
                continue;
            }
            if (wildcard < 0) break;
            lhs_pos = ++curent_lhs_pos;
            rhs_pos = wildcard;
        }
        if (rhs_pos == rhs_len) {
            return 1;
        }
        return lhs.charAt(lhs_pos) > rhs.charAt(rhs_pos) ? 1 : -1;
    }

    public static void main(String[] args) {
        System.out.println("QueryUtils.like() = " + QueryUtils.like("ABD", "ABC"));
        System.out.println("QueryUtils.like() = " + QueryUtils.like("ABC", "ABD"));
        System.out.println("QueryUtils.like() = " + QueryUtils.like("ABC", "ABC"));
        System.out.println("QueryUtils.like() = " + QueryUtils.like("ABC", "ABC*"));
        System.out.println("QueryUtils.like() = " + QueryUtils.like("ABC*", "ABC"));
        System.out.println("QueryUtils.like() = " + QueryUtils.like("ABC", "ABCD"));
        System.out.println("QueryUtils.like() = " + QueryUtils.like("ABCDGH", "ABC?G"));
        System.out.println("QueryUtils.like() = " + QueryUtils.like("ABCDGHIFFFLMNTLMN", "ABC*GHI*LMN"));
    }
}

