/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.hierarchy.util.internal;

import org.eclipse.hyades.models.hierarchy.extensions.ArithmeticExpression;
import org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.NumericFunction;
import org.eclipse.hyades.models.hierarchy.extensions.Operand;
import org.eclipse.hyades.models.hierarchy.extensions.OrderByElement;
import org.eclipse.hyades.models.hierarchy.extensions.Query;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleOperand;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.extensions.WhereExpression;

public class SSQEDebug {
    private static String r(int len) {
        len *= 3;
        String r = "";
        int x = 0;
        while (x < len) {
            r = String.valueOf(r) + " ";
            ++x;
        }
        return r;
    }

    public static String outputOrderByElement(OrderByElement e, int depth) {
        String s = "";
        s = String.valueOf(s) + SSQEDebug.r(depth) + "operand: " + e.getOperand();
        s = String.valueOf(s) + SSQEDebug.r(depth) + "operator: " + (Object)((Object)e.getOperator());
        return s;
    }

    public static String outputNumericFunction(NumericFunction e, int depth) {
        String s = "";
        s = String.valueOf(s) + SSQEDebug.r(depth) + "Function:" + (Object)((Object)e.getFunction()) + "\n";
        for (Operand o : e.getArguments()) {
            s = String.valueOf(s) + SSQEDebug.outputOperand(o, depth + 1);
        }
        return s;
    }

    public static String outputSimpleOperand(SimpleOperand e, int depth) {
        String s = "";
        if (e.getRawValue() != null) {
            s = String.valueOf(s) + SSQEDebug.r(depth) + "Raw Value: " + e.getRawValue() + "\n";
        }
        if (e.getValue() != null) {
            s = String.valueOf(s) + SSQEDebug.r(depth) + "Value: " + e.getValue() + "\n";
        }
        if (e.getType() != null) {
            s = String.valueOf(s) + SSQEDebug.r(depth) + "Type: " + e.getType() + "\n";
        }
        if (e.getFeature() != null) {
            s = String.valueOf(s) + SSQEDebug.r(depth) + "Feature: " + e.getFeature() + "\n";
        }
        if (e.getValueType() != null) {
            s = String.valueOf(s) + SSQEDebug.r(depth) + "Value Type: " + e.getValueType() + "\n";
        }
        return s;
    }

    public static String outputOperand(Operand o, int depth) {
        String s = "";
        s = String.valueOf(s) + SSQEDebug.r(depth) + "(operand class - " + o.getClass() + ") { \n";
        s = o instanceof ArithmeticExpression ? String.valueOf(s) + SSQEDebug.outputArithmeticExpression((ArithmeticExpression)o, depth + 1) : (o instanceof NumericFunction ? String.valueOf(s) + SSQEDebug.outputNumericFunction((NumericFunction)o, depth + 1) : (o instanceof SimpleOperand ? String.valueOf(s) + SSQEDebug.outputSimpleOperand((SimpleOperand)o, depth + 1) : String.valueOf(s) + "Unrecognized operand: " + o.getClass() + "\n"));
        s = String.valueOf(s) + SSQEDebug.r(depth) + "}\n";
        return s;
    }

    public static String outputLogicalExpression(LogicalExpression e, int depth) {
        String s = "";
        s = String.valueOf(s) + SSQEDebug.r(depth) + "operator: " + (Object)((Object)e.getOperator()) + "\n";
        s = String.valueOf(s) + SSQEDebug.r(depth) + "arguments: \n";
        for (WhereExpression we : e.getArguments()) {
            s = String.valueOf(s) + SSQEDebug.outputWhereExpression(we, depth + 1);
        }
        return s;
    }

    public static String outputBinaryExpression(BinaryExpression e, int depth) {
        String s = "";
        s = String.valueOf(s) + SSQEDebug.r(depth) + "operator: " + (Object)((Object)e.getOperator()) + "\n";
        s = String.valueOf(s) + SSQEDebug.r(depth) + "left Operand: \n";
        s = String.valueOf(s) + SSQEDebug.outputOperand(e.getLeftOperand(), depth + 1);
        s = String.valueOf(s) + SSQEDebug.r(depth) + "right Operands: \n";
        for (Operand o : e.getRightOperands()) {
            s = String.valueOf(s) + SSQEDebug.outputOperand(o, depth + 1);
        }
        return s;
    }

    public static String outputWhereExpression(WhereExpression e, int depth) {
        String s = "";
        s = String.valueOf(s) + SSQEDebug.r(depth) + "(where expression class: " + e.getClass() + ") {\n";
        s = e instanceof BinaryExpression ? String.valueOf(s) + SSQEDebug.outputBinaryExpression((BinaryExpression)e, depth + 1) : (e instanceof LogicalExpression ? String.valueOf(s) + SSQEDebug.outputLogicalExpression((LogicalExpression)e, depth + 1) : String.valueOf(s) + SSQEDebug.r(depth) + "Unrecognized WhereExpression: " + e.getClass() + "\n");
        s = String.valueOf(s) + SSQEDebug.r(depth) + "}\n";
        return s;
    }

    public static String outputArithmeticExpression(ArithmeticExpression e, int depth) {
        String s = "";
        s = String.valueOf(s) + SSQEDebug.r(depth) + "operator:" + (Object)((Object)e.getOperator()) + "\n";
        for (Operand o : e.getArguments()) {
            s = String.valueOf(s) + SSQEDebug.outputOperand(o, depth + 1);
        }
        return s;
    }

    public static void outputQuery(SimpleSearchQuery query, int depth) {
        String s = "";
        s = String.valueOf(s) + SSQEDebug.r(depth) + "Query name: " + query.getName() + "\n";
        s = String.valueOf(s) + SSQEDebug.r(depth) + "Order by expressions:\n";
        for (Object e : query.getOrderByExpresions()) {
            s = String.valueOf(s) + SSQEDebug.outputOrderByElement(e, depth + 1);
        }
        s = String.valueOf(s) + SSQEDebug.r(depth) + "Output elements:\n";
        for (Object e : query.getOutputElements()) {
            s = String.valueOf(s) + SSQEDebug.outputOperand((Operand)e, depth + 1);
        }
        s = String.valueOf(s) + SSQEDebug.r(depth) + "Where expression:\n";
        s = String.valueOf(s) + SSQEDebug.outputWhereExpression(query.getWhereExpression(), depth + 1);
        s = String.valueOf(s) + SSQEDebug.r(depth) + "SubQueries:\n";
        for (Query q : query.getSubQuery()) {
            s = String.valueOf(s) + SSQEDebug.r(depth) + q.getClass();
        }
        System.out.println("------------------");
        System.out.println(s);
    }
}

