/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.hierarchy.util.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.xml.type.util.XMLTypeUtil;
import org.eclipse.hyades.models.hierarchy.extensions.ArithmeticExpression;
import org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.NumericFunction;
import org.eclipse.hyades.models.hierarchy.extensions.Operand;
import org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleOperand;
import org.eclipse.hyades.models.hierarchy.extensions.WhereExpression;
import org.eclipse.hyades.models.hierarchy.extensions.impl.SimpleOperandImpl;
import org.eclipse.hyades.models.hierarchy.util.internal.QueryUtils;
import org.eclipse.hyades.models.hierarchy.util.internal.SimpleSearchQueryEngine;

public class SSQEEvalResult {
    public static final int IS_COMPLETE = 1;
    public static final int IS_NOT_COMPLETE = 2;
    public static final int IS_TRUE = 4;
    public static final int IS_FALSE = 8;
    public static final int IS_APPLICABLE = 16;
    private static final int BOOLEAN = 4;
    private static final int NUMERIC = 2;
    private static final int OBJECT = 5;
    private static final int SIMPLE_OPERAND = 1;
    private static final int STRING = 3;
    private Boolean _booleanValue;
    private int _compareResult;
    private boolean _complete;
    private EObject _context;
    private EClass _contextType;
    private WhereExpression _expression;
    private Number _numericValue;
    private Object _objectValue;
    private Operand _operand;
    private List<SSQEEvalResult> _partialResults = new ArrayList<SSQEEvalResult>();
    private String _stringValue;
    private int _valueType = -1;
    private SimpleSearchQueryEngine _ssqe;

    public SSQEEvalResult(SimpleSearchQueryEngine ssqe) {
        this._ssqe = ssqe;
    }

    public SSQEEvalResult(Operand operand, SimpleSearchQueryEngine ssqe) {
        this._operand = operand;
        this._ssqe = ssqe;
        this._contextType = this.getContextType();
    }

    public SSQEEvalResult(WhereExpression expression, SimpleSearchQueryEngine ssqe) {
        this._ssqe = ssqe;
        this._expression = expression;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("\n" + this.getLevelSpaces().toString());
        result.append(" (complete: ");
        result.append(this._complete);
        result.append(", valueType: ");
        result.append(this._valueType);
        result.append(", booleanValue: ");
        result.append(this._booleanValue);
        result.append(", contextType: ");
        result.append(this._contextType);
        result.append(", numericValue: ");
        result.append(this._numericValue);
        result.append(", stringValue: ");
        result.append(this._stringValue);
        result.append(", partialResults: ");
        for (SSQEEvalResult element : this._partialResults) {
            result.append(element.toString());
        }
        result.append(')');
        return result.toString();
    }

    private StringBuffer getLevelSpaces() {
        StringBuffer s = new StringBuffer();
        if (this._operand != null) {
            this.addLevelSpaces(this._operand, s);
        } else {
            this.addLevelSpaces(this._expression, s);
        }
        return s;
    }

    private void addLevelSpaces(EObject o, StringBuffer s) {
        if (o == null) {
            return;
        }
        s.append(" ");
        this.addLevelSpaces(o.eContainer(), s);
    }

    private Number add() {
        Number result = null;
        int i = 0;
        while (i < this._partialResults.size() && i < 2) {
            if (result == null) {
                result = this._partialResults.get(i).numericValue();
            } else if (result instanceof Double) {
                result = new Double(result.doubleValue() + this._partialResults.get(i).numericValue().doubleValue());
            } else if (result instanceof Integer) {
                result = new Integer(result.intValue() + this._partialResults.get(i).numericValue().intValue());
            } else if (result instanceof Float) {
                result = new Float(result.floatValue() + this._partialResults.get(i).numericValue().floatValue());
            } else if (result instanceof Short) {
                result = new Short((short)(result.shortValue() + this._partialResults.get(i).numericValue().shortValue()));
            } else if (result instanceof Long) {
                result = new Long(result.longValue() + this._partialResults.get(i).numericValue().longValue());
            } else if (result instanceof Byte) {
                result = new Long(result.byteValue() + this._partialResults.get(i).numericValue().byteValue());
            }
            ++i;
        }
        return result;
    }

    public void addPartialResult(SSQEEvalResult result) {
        this._partialResults.add(result);
    }

    public Boolean booleanValue() {
        return this._booleanValue;
    }

    private int compare(SSQEEvalResult lhs, SSQEEvalResult rhs) {
        if (lhs.isNumeric() && rhs.isNumeric() && lhs.numericValue() instanceof Comparable) {
            return ((Comparable)((Object)lhs.numericValue())).compareTo(rhs.numericValue());
        }
        if (lhs.isBoolean() && lhs.isBoolean()) {
            if (lhs.booleanValue() == Boolean.TRUE) {
                if (rhs.booleanValue() == Boolean.TRUE) {
                    return 0;
                }
                return 1;
            }
            if (rhs.booleanValue() == Boolean.FALSE) {
                return 0;
            }
            return -1;
        }
        if ((lhs.isObject() || lhs.isString()) && rhs.isObject()) {
            if (rhs.objectValue() instanceof List) {
                try {
                    if (lhs.objectValue() != null) {
                        return ((List)rhs.objectValue()).contains(lhs.objectValue()) ? 0 : -1;
                    }
                    return ((List)rhs.objectValue()).contains(lhs.stringValue()) ? 0 : -1;
                }
                catch (Exception exception) {
                    return -1;
                }
            }
            if (rhs._objectValue.getClass().getName().endsWith("XMLCalendar") && lhs._objectValue.getClass().getName().endsWith("XMLCalendar")) {
                try {
                    return XMLTypeUtil.compareCalendar((Object)lhs.objectValue(), (Object)rhs.objectValue());
                }
                catch (Exception exception) {}
            }
            return lhs.objectValue().toString().compareTo(rhs.objectValue().toString());
        }
        if (((BinaryExpression)this._expression).isCaseInsensitive()) {
            return lhs.stringValue().toLowerCase().compareTo(rhs.stringValue().toLowerCase());
        }
        return lhs.stringValue().compareTo(rhs.stringValue());
    }

    private SSQEEvalResult computePartialResult() {
        if (this.isComplete()) {
            return this;
        }
        if (this._operand != null) {
            if (this._operand instanceof NumericFunction) {
                this.updateNumericFunctionValue();
            } else if (this._operand instanceof ArithmeticExpression) {
                this.updateArithmeticExpressionValue();
            } else {
                this.updateSimpleOperand();
            }
        } else if (this._expression != null) {
            if (this._expression instanceof LogicalExpression) {
                this.updateLogicalExpressionValue();
            } else {
                this.updateBinaryExpressionValue();
            }
        }
        return this;
    }

    private Number divide() {
        Number result = null;
        int i = 0;
        while (i < this._partialResults.size() && i < 2) {
            if (result == null) {
                result = this._partialResults.get(i).numericValue();
            } else if (result instanceof Double) {
                result = new Double(result.doubleValue() / this._partialResults.get(i).numericValue().doubleValue());
            } else if (result instanceof Integer) {
                result = new Integer(result.intValue() / this._partialResults.get(i).numericValue().intValue());
            } else if (result instanceof Float) {
                result = new Float(result.floatValue() / this._partialResults.get(i).numericValue().floatValue());
            } else if (result instanceof Short) {
                result = new Short((short)(result.shortValue() / this._partialResults.get(i).numericValue().shortValue()));
            } else if (result instanceof Long) {
                result = new Long(result.longValue() / this._partialResults.get(i).numericValue().longValue());
            } else if (result instanceof Byte) {
                result = new Long(result.byteValue() / this._partialResults.get(i).numericValue().byteValue());
            }
            ++i;
        }
        return result;
    }

    public SSQEEvalResult eval(EObject element) {
        int i = 0;
        while (i < this._partialResults.size()) {
            SSQEEvalResult r = this._partialResults.get(i);
            r.eval(element);
            ++i;
        }
        if (this._expression != null || !(this._operand instanceof SimpleOperand)) {
            this.resetValues();
            this._complete = false;
        } else if (this.isValidContext(element)) {
            this._context = element;
            this.resetValues();
            this._complete = false;
        }
        this.computePartialResult();
        return this;
    }

    private EClass getContextType() {
        if (this._operand instanceof SimpleOperandImpl) {
            if (((SimpleOperand)this._operand).getType() != null) {
                return ((SimpleOperand)this._operand).getType();
            }
            if (((SimpleOperand)this._operand).getFeature() != null) {
                return ((SimpleOperand)this._operand).getFeature().getEContainingClass();
            }
        }
        return null;
    }

    private Number integerDivide() {
        int result = 0;
        boolean first = true;
        int i = 0;
        while (i < this._partialResults.size() && i < 2) {
            if (first) {
                result = this._partialResults.get(i).numericValue().intValue();
                first = false;
            } else {
                result /= this._partialResults.get(i).numericValue().intValue();
            }
            ++i;
        }
        return new Integer(result);
    }

    private boolean isArithmeticExpressionComplete(ArithmeticExpression arithmeticExpression) {
        int i = 0;
        while (i < this._partialResults.size()) {
            if (!this._partialResults.get(i).isComplete()) {
                return false;
            }
            ++i;
        }
        return i == arithmeticExpression.getArguments().size() - 1;
    }

    private boolean isBetweenComplete() {
        if (this._partialResults.size() == 3) {
            SSQEEvalResult lhs = this._partialResults.get(0);
            SSQEEvalResult rhs1 = this._partialResults.get(1);
            SSQEEvalResult rhs2 = this._partialResults.get(2);
            if (lhs.isComplete() && rhs1.isComplete() && rhs2.isComplete()) {
                int c2;
                int c1 = this.compare(rhs1, lhs);
                this._compareResult = c1 > 0 ? -1 : ((c2 = this.compare(lhs, rhs2)) > 0 ? 1 : 0);
                this._complete = true;
                return true;
            }
        }
        return false;
    }

    private boolean isBinaryComplete() {
        if (this._partialResults.size() == 2) {
            SSQEEvalResult lhs = this._partialResults.get(0);
            SSQEEvalResult rhs = this._partialResults.get(1);
            if (lhs.isComplete() && rhs.isComplete()) {
                this._compareResult = this.compare(lhs, rhs);
                this._complete = true;
                return true;
            }
        }
        return false;
    }

    private boolean isBoolean() {
        return this._valueType == 4;
    }

    public boolean isComplete() {
        if (this._complete) {
            return true;
        }
        if (this._objectValue != null || this._stringValue != null || this._booleanValue != null || this._numericValue != null) {
            this._complete = true;
            return true;
        }
        return false;
    }

    private boolean isInComplete() {
        if (this._partialResults.isEmpty()) {
            return false;
        }
        SSQEEvalResult lhs = this._partialResults.get(0);
        if (!lhs.isComplete()) {
            return false;
        }
        int i = 1;
        int j = 1;
        this._compareResult = -1;
        while (i < this._partialResults.size()) {
            SSQEEvalResult rhs = this._partialResults.get(1);
            if (rhs.isComplete()) {
                ++j;
                this._compareResult = this.compare(lhs, rhs);
                if (this._compareResult == 0) {
                    this._complete = true;
                    return true;
                }
            }
            ++i;
        }
        if (i == j) {
            this._complete = true;
            this._booleanValue = Boolean.FALSE;
        }
        return false;
    }

    private boolean isLikeComplete() {
        if (this._partialResults.size() == 2) {
            SSQEEvalResult lhs = this._partialResults.get(0);
            SSQEEvalResult rhs = this._partialResults.get(1);
            if (lhs.isComplete() && rhs.isComplete()) {
                this._compareResult = this.like(lhs, rhs);
                this._complete = true;
                return true;
            }
        }
        return false;
    }

    private boolean isNumeric() {
        return this._valueType == 2;
    }

    private boolean isObject() {
        return this._valueType == 5;
    }

    private boolean isString() {
        return this._valueType == 3;
    }

    private boolean isValidContext(EObject element) {
        return this._contextType != null && element != null && (element.eClass() == this._contextType || QueryUtils.getAllSubTypes(this._contextType).contains(element.eClass()));
    }

    private int like(SSQEEvalResult lhs, SSQEEvalResult rhs) {
        return this.like(lhs.stringValue(), rhs.stringValue());
    }

    private int like(String lhs, String rhs) {
        if (((BinaryExpression)this._expression).isCaseInsensitive()) {
            lhs = lhs.toLowerCase();
            rhs = rhs.toLowerCase();
        }
        return QueryUtils.like(lhs, rhs);
    }

    private Number mod() {
        Number result = null;
        int i = 0;
        while (i < this._partialResults.size() && i < 2) {
            if (result == null) {
                result = this._partialResults.get(i).numericValue();
            } else if (result instanceof Double) {
                result = new Double(result.doubleValue() % this._partialResults.get(i).numericValue().doubleValue());
            } else if (result instanceof Integer) {
                result = new Integer(result.intValue() % this._partialResults.get(i).numericValue().intValue());
            } else if (result instanceof Float) {
                result = new Float(result.floatValue() % this._partialResults.get(i).numericValue().floatValue());
            } else if (result instanceof Short) {
                result = new Short((short)(result.shortValue() % this._partialResults.get(i).numericValue().shortValue()));
            } else if (result instanceof Long) {
                result = new Long(result.longValue() % this._partialResults.get(i).numericValue().longValue());
            } else if (result instanceof Byte) {
                result = new Long(result.byteValue() % this._partialResults.get(i).numericValue().byteValue());
            }
            ++i;
        }
        return result;
    }

    private Number multiply() {
        Number result = null;
        int i = 0;
        while (i < this._partialResults.size()) {
            if (result == null) {
                result = this._partialResults.get(i).numericValue();
            } else if (result instanceof Double) {
                result = new Double(result.doubleValue() * this._partialResults.get(i).numericValue().doubleValue());
            } else if (result instanceof Integer) {
                result = new Integer(result.intValue() * this._partialResults.get(i).numericValue().intValue());
            } else if (result instanceof Float) {
                result = new Float(result.floatValue() * this._partialResults.get(i).numericValue().floatValue());
            } else if (result instanceof Short) {
                result = new Short((short)(result.shortValue() * this._partialResults.get(i).numericValue().shortValue()));
            } else if (result instanceof Long) {
                result = new Long(result.longValue() * this._partialResults.get(i).numericValue().longValue());
            } else if (result instanceof Byte) {
                result = new Long(result.byteValue() * this._partialResults.get(i).numericValue().byteValue());
            }
            ++i;
        }
        return result;
    }

    private Number numericValue() {
        return this._numericValue;
    }

    private Object objectValue() {
        return this._objectValue;
    }

    public boolean reset(EObject element) {
        if (this.isValidContext(element)) {
            this._context = null;
            this._complete = false;
        }
        int i = 0;
        while (i < this._partialResults.size()) {
            SSQEEvalResult r = this._partialResults.get(i);
            if (!r.reset(element)) {
                this._complete = false;
            }
            ++i;
        }
        if (!this._complete) {
            this.resetValues();
        }
        return this.isComplete();
    }

    private void resetValues() {
        this._numericValue = null;
        this._stringValue = null;
        this._objectValue = null;
        this._booleanValue = null;
    }

    private String stringValue() {
        if (this._stringValue != null) {
            return this._stringValue;
        }
        if (this._numericValue != null) {
            return this._numericValue.toString();
        }
        if (this._booleanValue != null) {
            return this._booleanValue.toString();
        }
        if (this._objectValue != null) {
            return this._objectValue.toString();
        }
        return "";
    }

    private Number substract() {
        Number result = null;
        int i = 0;
        while (i < this._partialResults.size()) {
            if (result == null) {
                result = this._partialResults.get(i).numericValue();
            } else if (result instanceof Double) {
                result = new Double(result.doubleValue() - this._partialResults.get(i).numericValue().doubleValue());
            } else if (result instanceof Integer) {
                result = new Integer(result.intValue() - this._partialResults.get(i).numericValue().intValue());
            } else if (result instanceof Float) {
                result = new Float(result.floatValue() - this._partialResults.get(i).numericValue().floatValue());
            } else if (result instanceof Short) {
                result = new Short((short)(result.shortValue() - this._partialResults.get(i).numericValue().shortValue()));
            } else if (result instanceof Long) {
                result = new Long(result.longValue() - this._partialResults.get(i).numericValue().longValue());
            } else if (result instanceof Byte) {
                result = new Long(result.byteValue() - this._partialResults.get(i).numericValue().byteValue());
            }
            ++i;
        }
        return result;
    }

    private void updateArithmeticExpressionValue() {
        ArithmeticExpression arithmeticExpression = (ArithmeticExpression)((Object)this._expression);
        if (this.isArithmeticExpressionComplete(arithmeticExpression)) {
            switch (arithmeticExpression.getOperator().getValue()) {
                case 0: {
                    this._numericValue = this.add();
                    break;
                }
                case 3: {
                    this._numericValue = this.divide();
                    break;
                }
                case 4: {
                    this._numericValue = this.integerDivide();
                    break;
                }
                case 5: {
                    this._numericValue = this.mod();
                    break;
                }
                case 2: {
                    this._numericValue = this.multiply();
                    break;
                }
                case 1: {
                    this._numericValue = this.substract();
                }
            }
        }
    }

    private void updateBinaryExpressionValue() {
        BinaryExpression binaryExpression = (BinaryExpression)this._expression;
        if (binaryExpression.getOperator() == RelationalOperators.BETWEEN_LITERAL) {
            if (this.isBetweenComplete()) {
                this._booleanValue = this._compareResult == 0;
            }
        } else if (binaryExpression.getOperator() == RelationalOperators.IN_LITERAL) {
            if (this.isInComplete()) {
                this._booleanValue = this._compareResult == 0;
            }
        } else if (binaryExpression.getOperator() == RelationalOperators.LIKE_LITERAL) {
            if (this.isLikeComplete()) {
                this._booleanValue = this._compareResult == 0;
            }
        } else if (this.isBinaryComplete()) {
            switch (binaryExpression.getOperator().getValue()) {
                case 2: {
                    this._booleanValue = this._compareResult == 0;
                    break;
                }
                case 4: {
                    this._booleanValue = this._compareResult >= 0;
                    break;
                }
                case 1: {
                    this._booleanValue = this._compareResult > 0;
                    break;
                }
                case 3: {
                    this._booleanValue = this._compareResult <= 0;
                    break;
                }
                case 0: {
                    this._booleanValue = this._compareResult < 0;
                    break;
                }
                case 5: {
                    this._booleanValue = this._compareResult != 0;
                }
            }
        }
    }

    private void updateLogicalExpressionValue() {
        LogicalExpression logicalExpression = (LogicalExpression)this._expression;
        int processed = 0;
        int i = 0;
        while (i < this._partialResults.size()) {
            SSQEEvalResult result = this._partialResults.get(i);
            if (result.isComplete()) {
                if (i == 0 && logicalExpression.getOperator().getValue() == 0) {
                    this._complete = true;
                    this._booleanValue = result.booleanValue() == false;
                } else if (logicalExpression.getOperator().getValue() == 1) {
                    ++processed;
                    if (!result.booleanValue().booleanValue()) {
                        this._complete = true;
                        this._booleanValue = Boolean.FALSE;
                    }
                } else if (logicalExpression.getOperator().getValue() == 2) {
                    ++processed;
                    if (result.booleanValue().booleanValue()) {
                        this._complete = true;
                        this._booleanValue = Boolean.TRUE;
                    }
                }
            }
            if (this._complete) break;
            ++i;
        }
        if (!this._complete && logicalExpression.getArguments().size() == processed) {
            this._complete = true;
            if (logicalExpression.getOperator().getValue() == 1) {
                this._booleanValue = Boolean.TRUE;
            } else if (logicalExpression.getOperator().getValue() == 2) {
                this._booleanValue = logicalExpression.getArguments().size() == 0 ? Boolean.TRUE : Boolean.FALSE;
            }
        }
    }

    private void updateNumericFunctionValue() {
        throw new RuntimeException("Not implemented yet !");
    }

    private void updateSimpleOperand() {
        if (this.isComplete()) {
            return;
        }
        SimpleOperand simpleOperand = (SimpleOperand)this._operand;
        if (simpleOperand.getType() != null) {
            if (this._context == null) {
                return;
            }
            this._valueType = 5;
            this._objectValue = this._context;
            this._complete = true;
        } else if (simpleOperand.getFeature() != null) {
            if (this._context == null) {
                return;
            }
            try {
                Object v = this._context.eGet(simpleOperand.getFeature(), false);
                this.updateSimpleOperandValue(v);
            }
            catch (Exception exception) {}
        } else {
            Object v = this._ssqe.getNonModeledElementValue(this, simpleOperand);
            this.updateSimpleOperandValue(v);
        }
    }

    private void updateSimpleOperandValue(Object v) {
        if (v instanceof Number) {
            this._numericValue = (Number)v;
            this._valueType = 2;
        } else if (v instanceof Boolean) {
            this._booleanValue = (Boolean)v;
            this._valueType = 4;
        } else if (v instanceof String) {
            this._stringValue = v.toString();
            this._valueType = 3;
        } else {
            this._objectValue = v;
            this._valueType = 5;
        }
        this._complete = true;
    }

    public SSQEEvalResult evalOnly(EStructuralFeature sf, Object value) {
        EClass c = sf.getEContainingClass();
        if (!this._ssqe._classPredicatesIndex.containsKey(c)) {
            this._complete = true;
            this._booleanValue = Boolean.TRUE;
            return this;
        }
        this.internalEvalOnly(sf, value);
        return this;
    }

    private SSQEEvalResult internalEvalOnly(EStructuralFeature sf, Object value) {
        if (this._operand instanceof SimpleOperand && ((SimpleOperand)this._operand).getFeature() == sf) {
            this._objectValue = value;
            this._complete = true;
        } else {
            int i = 0;
            while (i < this._partialResults.size()) {
                SSQEEvalResult r = this._partialResults.get(i);
                r.internalEvalOnly(sf, value);
                ++i;
            }
            this.computePartialResult();
        }
        return this;
    }

    public int partialEvalOnly(EClass value) {
        if (!this._ssqe._classPredicatesIndex.containsKey(value)) {
            return 0;
        }
        return this.internalEvalOnly(value);
    }

    private int internalEvalOnly(EClass value) {
        if (this._operand != null) {
            if (this._operand instanceof SimpleOperand) {
                if (this._contextType == null || this._contextType == value) {
                    return (this.isComplete() ? 1 : 2) | 0x10;
                }
                return this.isComplete() ? 1 : 2;
            }
        } else {
            int i = 0;
            int k = 0;
            int f = 0;
            int t = 0;
            while (i < this._partialResults.size()) {
                SSQEEvalResult r = this._partialResults.get(i);
                int res = r.internalEvalOnly(value);
                if ((res & 0x10) != 0) {
                    ++k;
                    if ((res & 1) != 0) {
                        if ((res & 4) != 0) {
                            ++t;
                        } else if ((res & 8) != 0) {
                            ++f;
                        }
                    } else {
                        return 18;
                    }
                }
                ++i;
            }
            if (k == 0) {
                return this.isComplete() ? 1 : 2;
            }
            if (this._expression instanceof BinaryExpression) {
                if (this.isComplete()) {
                    if (this.booleanValue().booleanValue()) {
                        return 21;
                    }
                    return 25;
                }
                return 18;
            }
            if (this._expression instanceof LogicalExpression) {
                LogicalExpression le = (LogicalExpression)this._expression;
                if (le.getOperator() == LogicalOperators.AND_LITERAL) {
                    if (k == t) {
                        return 21;
                    }
                    return 25;
                }
                if (le.getOperator() == LogicalOperators.OR_LITERAL) {
                    if (t > 0) {
                        return 21;
                    }
                    if (f > 0) {
                        return 25;
                    }
                    return 18;
                }
                if (le.getOperator() == LogicalOperators.NOT_LITERAL) {
                    if (t > 0) {
                        return 25;
                    }
                    if (f > 0) {
                        return 21;
                    }
                    return 18;
                }
            }
        }
        return 0;
    }

    public boolean resetOnly(EStructuralFeature sf) {
        EClass c = sf.getEContainingClass();
        if (!this._ssqe._classPredicatesIndex.containsKey(c)) {
            this._complete = false;
            this._booleanValue = null;
            return false;
        }
        return this.internalResetOnly(sf);
    }

    private boolean internalResetOnly(EStructuralFeature sf) {
        if (this._operand instanceof SimpleOperand && ((SimpleOperand)this._operand).getFeature() == sf) {
            this._objectValue = null;
            this._complete = false;
        } else {
            int i = 0;
            while (i < this._partialResults.size()) {
                SSQEEvalResult r = this._partialResults.get(i);
                if (!r.internalResetOnly(sf)) {
                    this._complete = false;
                }
                ++i;
            }
            if (!this._complete) {
                this.resetValues();
            }
        }
        return this.isComplete();
    }

    public EObject getContext() {
        return this._context;
    }
}

