/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.hierarchy.util.internal;

import org.eclipse.hyades.models.hierarchy.util.ShortList;

public class ShortListImpl
implements ShortList {
    public static final short MISSING_VALUE = -1;
    protected short[] data;
    protected int size;

    public ShortListImpl() {
        this.data = new short[10];
        this.size = 0;
    }

    public ShortListImpl(int initialCapacity) {
        this.data = new short[initialCapacity];
        this.size = 0;
    }

    public ShortList compact() {
        short[] newData = new short[this.size];
        System.arraycopy(this.data, 0, newData, 0, this.size);
        this.data = newData;
        return this;
    }

    public short set(short value, int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        short oldValue = this.data[index];
        this.data[index] = value;
        return oldValue;
    }

    public int size() {
        return this.size;
    }

    public ShortList add(short value) {
        this.ensureCapacity(this.size + 1);
        this.data[this.size++] = value;
        return this;
    }

    public ShortList add(short value, int index) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.data, index, this.data, index + 1, this.size - index);
        this.data[index] = value;
        ++this.size;
        return this;
    }

    protected void ensureCapacity(int index) {
        int oldCapacity;
        if (index >= this.data.length && index > (oldCapacity = this.data.length)) {
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < index) {
                newCapacity = index;
            }
            short[] newData = new short[newCapacity];
            System.arraycopy(this.data, 0, newData, 0, this.size);
            this.data = newData;
        }
    }

    public short get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        return this.data[index];
    }

    public int indexOf(short value, int startIndex) {
        if (startIndex < 0) {
            throw new IndexOutOfBoundsException("Index: " + startIndex + ", Size: " + this.size);
        }
        int i = startIndex;
        while (i < this.size) {
            if (this.data[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int lastIndexOf(short value, int endIndex) {
        if (endIndex < 0) {
            throw new IndexOutOfBoundsException("Index: " + endIndex + ", Size: " + this.size);
        }
        int i = endIndex;
        while (i-- > 0) {
            if (this.data[i] != value) continue;
            return i;
        }
        return -1;
    }

    public short[] getValues() {
        return this.data;
    }

    public ShortList clear() {
        this.data = new short[0];
        this.size = 0;
        return this;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        int i = 0;
        while (i < this.size) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.data[i]);
            ++i;
        }
        buf.append("]");
        return buf.toString();
    }
}

