/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.hierarchy.util.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xml.type.util.XMLTypeUtil;
import org.eclipse.hyades.models.hierarchy.extensions.ArithmeticExpression;
import org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.NumericFunction;
import org.eclipse.hyades.models.hierarchy.extensions.Operand;
import org.eclipse.hyades.models.hierarchy.extensions.OrderByElement;
import org.eclipse.hyades.models.hierarchy.extensions.OrderByOperators;
import org.eclipse.hyades.models.hierarchy.extensions.QueryResult;
import org.eclipse.hyades.models.hierarchy.extensions.ResultEntry;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleOperand;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.extensions.WhereExpression;
import org.eclipse.hyades.models.hierarchy.util.ContainmentTraverser;
import org.eclipse.hyades.models.hierarchy.util.FastList;
import org.eclipse.hyades.models.hierarchy.util.PerfUtil;
import org.eclipse.hyades.models.hierarchy.util.SaveUtil;
import org.eclipse.hyades.models.hierarchy.util.internal.QueryUtils;
import org.eclipse.hyades.models.hierarchy.util.internal.SSQEEvalResult;
import org.eclipse.hyades.models.util.ModelDebugger;
import org.eclipse.hyades.models.util.internal.IdentityHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleSearchQueryEngine {
    public static final String XMLCALENDAR = "XMLCalendar";
    private static final boolean DEBUG_SSQE = false;
    private Set<EObject> _alreadyProcessed = new IdentityHashSet<EObject>();
    Map<EClass, Collection<EObject>> _classPredicatesIndex = new IdentityHashMap<EClass, Collection<EObject>>();
    private Map<EClass, Collection<EObject>> _featurePredicatesIndex = new IdentityHashMap<EClass, Collection<EObject>>();
    private Map<String, EObject> _namesIndex = new HashMap<String, EObject>();
    private Set<EClass> _outputClasses = new IdentityHashSet<EClass>();
    private Set<Object> _outputClassesSuperTypes = new IdentityHashSet<Object>();
    private Set<Object> _outputClassesSubTypes = new IdentityHashSet<Object>();
    SimpleSearchQuery _query;
    private QueryResult _queryResult;
    private Set<EStructuralFeature> _requiredPaths = new IdentityHashSet<EStructuralFeature>();
    private Collection<EClass> _rootClasses = new IdentityHashSet<EClass>();
    private Collection<EObject> _rootNodes = new IdentityHashSet<EObject>();
    private ResourceSet _targetResourceSet;
    private Map<EObject, SSQEEvalResult> _whereExpressionValuesIndex = new IdentityHashMap<EObject, SSQEEvalResult>();
    SimpleSearchQueryEvaluator _queryEvaluator = new SimpleSearchQueryEvaluator();
    private SSQEEvalResult _result;
    private List<EObject> _resetStack = new FastList();
    private List<EObject> _resetParentsStack = new FastList();
    private PerfUtil _p;
    private ArrayList<EObject> _firstResList;

    public SimpleSearchQueryEngine(SimpleSearchQuery query, ResourceSet targetResourceSet) {
        this._query = query;
        this._targetResourceSet = targetResourceSet;
        for (EStructuralFeature element : query.getRequiredPaths()) {
            this._requiredPaths.add(element);
        }
    }

    private SSQEEvalResult createEvalResult(Operand operand) {
        return new SSQEEvalResult(operand, this);
    }

    protected SSQEEvalResult createEvalResult(WhereExpression expression) {
        return new SSQEEvalResult(expression, this);
    }

    private void addResultValue(EObject element) {
        if (this._queryResult.getResultEntries().size() == 1) {
            if (this._query.isDistinct() && this._firstResList.lastIndexOf(element) >= 0) {
                return;
            }
            this._firstResList.add(element);
            return;
        }
        throw new RuntimeException("Not implemented yet !");
    }

    protected void buildRequiredTraversalPaths() {
        this._alreadyProcessed.clear();
        for (EClass element : this._rootClasses) {
            this.processContainmentPath(element);
        }
    }

    private void evalSelfAndParents(EObject element) {
        if (element == null || this._alreadyProcessed.contains(element)) {
            return;
        }
        if (this._classPredicatesIndex.containsKey(element.eClass())) {
            this._alreadyProcessed.add(element);
            this._result.eval(element);
            this._resetParentsStack.add(element);
        }
        if (element.eContainer() != null) {
            this.evalSelfAndParents(element.eContainer());
        }
    }

    public QueryResult execute() {
        if (ModelDebugger.INSTANCE.debugPerfUtil) {
            this._p = PerfUtil.createInstance(null, false);
            this._p.setMessageAndStart("SimpleSearchQueryEngine.execute()");
        }
        this.prepareResult();
        this.populateRootNodesAndClasses();
        this.buildRequiredTraversalPaths();
        this.indexWhereExpression();
        this.populateResult();
        this.sortResult();
        this.limitResult();
        if (ModelDebugger.INSTANCE.debugPerfUtil) {
            this._p.stopAndPrintStatus("firstResList.size=" + (this._firstResList == null ? "null" : "" + this._firstResList.size()));
        }
        return this._queryResult;
    }

    protected void indexWhereExpression() {
        ArrayList<WhereExpression> roots = new ArrayList<WhereExpression>();
        if (this._query.getWhereExpression() == null) {
            return;
        }
        roots.add(this._query.getWhereExpression());
        ContainmentTraverser containmentTraverser = new ContainmentTraverser(roots){

            protected boolean beforeChildren(EObject element) {
                String name = QueryUtils.getElementName(element);
                if (name != null && name.startsWith("$")) {
                    return super.beforeChildren(element);
                }
                if (SimpleSearchQueryEngine.this._whereExpressionValuesIndex.containsKey(element)) {
                    return super.beforeChildren(element);
                }
                SimpleSearchQueryEngine.this._whereExpressionValuesIndex.put(element, null);
                if (element instanceof SimpleOperand) {
                    SimpleOperand o = (SimpleOperand)element;
                    EClass c = o.getType();
                    if (c != null) {
                        Collection<EObject> l = SimpleSearchQueryEngine.this._classPredicatesIndex.get(c);
                        if (l == null) {
                            l = new HashSet<EObject>();
                            SimpleSearchQueryEngine.this._classPredicatesIndex.put(c, l);
                            QueryUtils.addSubTypes(c, SimpleSearchQueryEngine.this._classPredicatesIndex, l);
                        }
                        if (!l.contains(element)) {
                            l.add(element);
                        }
                    } else if (o.getFeature() != null && !SimpleSearchQueryEngine.this._requiredPaths.contains(o.getFeature())) {
                        c = o.getFeature().getEContainingClass();
                        HashSet<EObject> l = SimpleSearchQueryEngine.this._classPredicatesIndex.get(c);
                        if (l == null) {
                            l = new HashSet<EObject>();
                            SimpleSearchQueryEngine.this._classPredicatesIndex.put(c, l);
                            QueryUtils.addSubTypes(c, SimpleSearchQueryEngine.this._classPredicatesIndex, (Collection<EObject>)l);
                        }
                        if (!l.contains(element)) {
                            l.add(element);
                            QueryUtils.addSubTypes(c, SimpleSearchQueryEngine.this._classPredicatesIndex, l);
                        }
                        if (o.getFeature() instanceof EReference) {
                            l = (HashSet<EObject>)SimpleSearchQueryEngine.this._featurePredicatesIndex.get(c);
                            if (l == null) {
                                l = new HashSet<EObject>();
                                SimpleSearchQueryEngine.this._featurePredicatesIndex.put(c, l);
                                QueryUtils.addSubTypes(c, SimpleSearchQueryEngine.this._featurePredicatesIndex, l);
                            }
                            if (!l.contains(o.getFeature())) {
                                l.add((EObject)o.getFeature());
                                QueryUtils.addSubTypes(c, SimpleSearchQueryEngine.this._featurePredicatesIndex, l);
                            }
                        }
                    }
                }
                if (name != null) {
                    SimpleSearchQueryEngine.this._namesIndex.put(name, element);
                }
                return super.beforeChildren(element);
            }
        };
        containmentTraverser.traverse();
    }

    private boolean isOutputElement(EObject element) {
        EClass c = element.eClass();
        return this.isOutputElement(c);
    }

    private boolean isOutputElement(EClass eClass) {
        return this._outputClasses.contains(eClass) || this._outputClassesSubTypes.contains(eClass);
    }

    private void limitResult() {
        int start;
        if (this._query.getMaxElements() == 0) {
            return;
        }
        ResultEntry tempResult = (ResultEntry)this._queryResult.getResultEntries().get(0);
        List initialList = (List)((ResultEntry)this._queryResult.getResultEntries().get(0)).getValue();
        ArrayList resultList = new ArrayList();
        int end = 0;
        if (this._query.getStartWith() >= 0) {
            start = this._query.getStartWith();
            end = Math.min(start + this._query.getMaxElements() - 1, initialList.size() - 1);
        } else {
            end = Math.max(0, initialList.size() + this._query.getStartWith());
            start = Math.max(0, end - this._query.getMaxElements());
        }
        int i = start;
        while (i <= end) {
            resultList.add(initialList.get(i));
            ++i;
        }
        tempResult.setValue(resultList);
    }

    protected void populateResult() {
        this._result = this._queryEvaluator.prepareEvalResult();
        this._alreadyProcessed.clear();
        if (this._firstResList != null) {
            this._firstResList.clear();
        }
        ContainmentTraverser containmentTraverser = new ContainmentTraverser(this._rootNodes){
            protected int depth;
            {
                this.depth = 0;
            }

            protected boolean afterChildren(EObject element) {
                --this.depth;
                EClass eClass = element.eClass();
                if (SimpleSearchQueryEngine.this._classPredicatesIndex.containsKey(eClass)) {
                    int ei;
                    if (this.depth == 0 && !SimpleSearchQueryEngine.this._resetParentsStack.isEmpty()) {
                        SimpleSearchQueryEngine.this.processResetList(SimpleSearchQueryEngine.this._resetParentsStack, 0);
                    }
                    if (SimpleSearchQueryEngine.this.isOutputElement(eClass) && (ei = SimpleSearchQueryEngine.this._resetStack.lastIndexOf(element)) >= 0) {
                        SimpleSearchQueryEngine.this.processResetList(SimpleSearchQueryEngine.this._resetStack, ei);
                    }
                    this.pruneSubtree = SimpleSearchQueryEngine.this.shouldPrune(element, this.depth, false);
                }
                return true;
            }

            protected boolean beforeChildren(EObject element) {
                ++this.depth;
                EClass eClass = element.eClass();
                if (SimpleSearchQueryEngine.this._classPredicatesIndex.containsKey(element.eClass())) {
                    if (this.depth == 1) {
                        SimpleSearchQueryEngine.this._alreadyProcessed.clear();
                        SimpleSearchQueryEngine.this.evalSelfAndParents(element.eContainer());
                    }
                    SimpleSearchQueryEngine.this._result.eval(element);
                    SimpleSearchQueryEngine.this._resetStack.add(element);
                    if (SimpleSearchQueryEngine.this.isOutputElement(eClass)) {
                        if (SimpleSearchQueryEngine.this._result.isComplete()) {
                            if (SimpleSearchQueryEngine.this._result.booleanValue().booleanValue()) {
                                SimpleSearchQueryEngine.this.addResultValue(element);
                                this.pruneSubtree = SimpleSearchQueryEngine.this.shouldPrune(element, this.depth, true);
                            }
                        } else if (SimpleSearchQueryEngine.this.traverseFeatures(element, SimpleSearchQueryEngine.this._resetStack) && SimpleSearchQueryEngine.this._result.isComplete() && SimpleSearchQueryEngine.this._result.booleanValue().booleanValue()) {
                            SimpleSearchQueryEngine.this.addResultValue(element);
                            this.pruneSubtree = SimpleSearchQueryEngine.this.shouldPrune(element, this.depth, true);
                        }
                    } else if (SimpleSearchQueryEngine.this._result.isComplete()) {
                        EObject outputElement;
                        if (SimpleSearchQueryEngine.this._result.booleanValue().booleanValue() && (outputElement = SimpleSearchQueryEngine.this.findOutputElementInParents(element)) != null) {
                            SimpleSearchQueryEngine.this.addResultValue(outputElement);
                            this.pruneSubtree = SimpleSearchQueryEngine.this.shouldPrune(element, this.depth, true);
                        }
                    } else {
                        SimpleSearchQueryEngine.this.traverseFeatures(element, SimpleSearchQueryEngine.this._resetStack);
                    }
                }
                return true;
            }

            protected boolean isRequiredFeature(EStructuralFeature sf) {
                return SimpleSearchQueryEngine.this._requiredPaths.contains(sf);
            }
        };
        try {
            containmentTraverser.traverse();
        }
        catch (ConcurrentModificationException concurrentModificationException) {}
    }

    private boolean shouldPrune(EObject element, int depth, boolean children) {
        return false;
    }

    protected EObject findOutputElementInParents(EObject element) {
        if (this._rootNodes.contains(element)) {
            return null;
        }
        EObject eContainer = element.eContainer();
        if (eContainer != null) {
            if (this.isOutputElement(eContainer)) {
                return eContainer;
            }
            if (this._rootNodes.contains(eContainer)) {
                return null;
            }
            return this.findOutputElementInParents(eContainer);
        }
        return null;
    }

    protected boolean traverseFeatures(EObject element, List<EObject> resetList) {
        Collection<EObject> fl = this._featurePredicatesIndex.get(element.eClass());
        boolean ret = false;
        if (fl != null) {
            Iterator<EObject> iter = fl.iterator();
            block0: while (iter.hasNext()) {
                if (ret) break;
                EReference sf = (EReference)iter.next();
                if (this._requiredPaths.contains(sf)) continue;
                if (sf.isMany()) {
                    List rl = (List)element.eGet((EStructuralFeature)sf);
                    Iterator iterator = rl.iterator();
                    while (iterator.hasNext()) {
                        if (ret) continue block0;
                        EObject le = (EObject)iterator.next();
                        if (this._classPredicatesIndex.get(le.eClass()) == null) continue;
                        resetList.add(le);
                        int pos = resetList.size() - 1;
                        ret = this.processEObject(resetList, le, pos);
                        if (ret || !this.processResetListIsRequired(le)) continue;
                        this.processResetList(resetList, pos);
                    }
                    continue;
                }
                EObject ro = (EObject)element.eGet((EStructuralFeature)sf);
                if (this._classPredicatesIndex.get(ro.eClass()) == null) continue;
                resetList.add(ro);
                int pos = resetList.size() - 1;
                ret = this.processEObject(resetList, ro, pos);
                if (ret || !this.processResetListIsRequired(ro)) continue;
                this.processResetList(resetList, pos);
            }
        }
        return ret;
    }

    private boolean processResetListIsRequired(EObject eObject) {
        return (this._result.partialEvalOnly(eObject.eClass()) & 0x15) != 21;
    }

    private boolean processEObject(List<EObject> resetList, EObject eObject, int pos) {
        boolean ret;
        this._result.eval(eObject);
        if (this._result.isComplete()) {
            ret = this.addResultValueIfRequired(eObject, pos);
        } else {
            ret = this.traverseFeatures(eObject, resetList);
            if (this._result.isComplete()) {
                ret = this.addResultValueIfRequired(eObject, pos);
            }
        }
        return ret;
    }

    private boolean addResultValueIfRequired(EObject eObject, int pos) {
        if (this._result.booleanValue().booleanValue()) {
            if (this.isOutputElement(eObject)) {
                this.addResultValue(eObject);
                return false;
            }
            return true;
        }
        return false;
    }

    protected void populateRootNodesAndClasses() {
        this._rootNodes.clear();
        this._rootClasses.clear();
        for (String element : this._query.getSources()) {
            URI uri = SaveUtil.createURI(element);
            EObject n = this._targetResourceSet.getEObject(uri, false);
            if (n == null) continue;
            EClass c = n.eClass();
            if (!this._rootNodes.contains(n)) {
                this._rootNodes.add(n);
            }
            if (this._rootClasses.contains(c)) continue;
            this._rootClasses.add(c);
        }
    }

    protected void prepareResult() {
        this._queryResult = ExtensionsFactory.eINSTANCE.createQueryResult();
        this._queryResult.setQuery(this._query);
        for (SimpleOperand outputElement : this._query.getOutputElements()) {
            EClass c = outputElement.getType();
            if (c == null && outputElement.getFeature() != null) {
                c = outputElement.getFeature().getEContainingClass();
            }
            if (c != null) {
                this._outputClasses.add(c);
                QueryUtils.addSubTypes(c, this._outputClassesSubTypes);
                QueryUtils.addSuperTypes(c, this._outputClassesSuperTypes);
                this._classPredicatesIndex.put(c, null);
                QueryUtils.addSubTypes(c, this._classPredicatesIndex, null);
            }
            ResultEntry resultEntry = ExtensionsFactory.eINSTANCE.createResultEntry();
            this._queryResult.getResultEntries().add((Object)resultEntry);
            this._firstResList = new ArrayList();
            resultEntry.setValue(this._firstResList);
        }
    }

    private boolean processContainmentPath(EClass element) {
        if (this._alreadyProcessed.contains(element)) {
            return this._outputClasses.contains(element) || this._outputClassesSuperTypes.contains(element);
        }
        this._alreadyProcessed.add((EObject)element);
        boolean result = false;
        boolean ret = false;
        if (this._outputClasses.contains(element) || this._outputClassesSuperTypes.contains(element)) {
            result = true;
        }
        for (EReference ref : element.getEAllContainments()) {
            ret = this.processContainmentPath(ref.getEReferenceType());
            boolean bl = result = result || ret;
            if (!ret) continue;
            this._requiredPaths.add((EStructuralFeature)ref);
        }
        return result;
    }

    private void sortResult() {
        if (this._query.getOrderByExpresions().size() != 1) {
            return;
        }
        final EAttribute compareAttribute = (EAttribute)((SimpleOperand)((OrderByElement)this._query.getOrderByExpresions().get(0)).getOperand()).getFeature();
        OrderByOperators compareOperator = ((OrderByElement)this._query.getOrderByExpresions().get(0)).getOperator();
        final boolean reversOrder = compareOperator.getValue() == 1;
        Comparator<EObject> comparator = new Comparator<EObject>(){

            @Override
            public int compare(EObject o1, EObject o2) {
                Object o1Value = o1.eGet((EStructuralFeature)compareAttribute);
                Object o2Value = o2.eGet((EStructuralFeature)compareAttribute);
                try {
                    if (o2Value.getClass().getName().endsWith(SimpleSearchQueryEngine.XMLCALENDAR)) {
                        return XMLTypeUtil.compareCalendar((Object)o1Value, (Object)o2Value);
                    }
                    return reversOrder ? -((Comparable)o1Value).compareTo(o2Value) : ((Comparable)o1Value).compareTo(o2Value);
                }
                catch (Exception exception) {
                    try {
                        return reversOrder ? -o1Value.toString().compareTo(o2Value.toString()) : o1Value.toString().compareTo(o2Value.toString());
                    }
                    catch (Exception exception2) {
                        return 0;
                    }
                }
            }
        };
        ResultEntry tempResult = (ResultEntry)this._queryResult.getResultEntries().get(0);
        List resultList = (List)tempResult.getValue();
        Collections.sort(resultList, comparator);
        tempResult.setValue(resultList);
    }

    private void processResetList(List<EObject> list, int startPosition) {
        this._alreadyProcessed.clear();
        int i = list.size() - 1;
        while (i >= startPosition) {
            EObject resetElement = list.get(i);
            if (!this._alreadyProcessed.contains(resetElement.eClass())) {
                this._result.reset(resetElement);
                this._alreadyProcessed.add((EObject)resetElement.eClass());
                list.remove(i);
            }
            --i;
        }
    }

    public Set<EStructuralFeature> getRequiredPaths() {
        return this._requiredPaths;
    }

    protected Object getNonModeledElementValue(SSQEEvalResult evalResult, SimpleOperand simpleOperand) {
        return simpleOperand.getValue();
    }

    public class SimpleSearchQueryEvaluator {
        protected WhereExpression getExpression(String string) {
            return (WhereExpression)SimpleSearchQueryEngine.this._namesIndex.get(string);
        }

        protected Operand getOperand(String string) {
            return (Operand)SimpleSearchQueryEngine.this._namesIndex.get(string);
        }

        private SSQEEvalResult internalPrepareEvalResult() {
            if (SimpleSearchQueryEngine.this._query.getWhereExpression() == null) {
                return new SSQEEvalResult(SimpleSearchQueryEngine.this);
            }
            if (SimpleSearchQueryEngine.this._whereExpressionValuesIndex.get(SimpleSearchQueryEngine.this._query.getWhereExpression()) != null) {
                return (SSQEEvalResult)SimpleSearchQueryEngine.this._whereExpressionValuesIndex.get(SimpleSearchQueryEngine.this._query.getWhereExpression());
            }
            return this.parseWhereExpression(SimpleSearchQueryEngine.this._query.getWhereExpression());
        }

        private SSQEEvalResult parseWhereExpression(WhereExpression expression) {
            if (expression instanceof LogicalExpression) {
                return this.parseLogicalExpression((LogicalExpression)expression);
            }
            return this.parseBinaryExpression((BinaryExpression)expression);
        }

        public SSQEEvalResult prepareEvalResult() {
            return this.internalPrepareEvalResult();
        }

        private SSQEEvalResult parseArithmeticExpression(ArithmeticExpression expression) {
            if (SimpleSearchQueryEngine.this._whereExpressionValuesIndex.get(expression) != null) {
                return (SSQEEvalResult)SimpleSearchQueryEngine.this._whereExpressionValuesIndex.get(expression);
            }
            if (expression.getName() != null && expression.getName().startsWith("$")) {
                return this.parseOperand(this.getOperand(expression.getName().substring(1)));
            }
            SSQEEvalResult result = SimpleSearchQueryEngine.this.createEvalResult(expression);
            SimpleSearchQueryEngine.this._whereExpressionValuesIndex.put(expression, result);
            for (Operand element : expression.getArguments()) {
                result.addPartialResult(this.parseOperand(element));
            }
            return result;
        }

        private SSQEEvalResult parseBinaryExpression(BinaryExpression expression) {
            if (SimpleSearchQueryEngine.this._whereExpressionValuesIndex.get(expression) != null) {
                return (SSQEEvalResult)SimpleSearchQueryEngine.this._whereExpressionValuesIndex.get(expression);
            }
            if (expression.getName() != null && expression.getName().startsWith("$")) {
                return this.parseWhereExpression(this.getExpression(expression.getName().substring(1)));
            }
            SSQEEvalResult result = SimpleSearchQueryEngine.this.createEvalResult(expression);
            SimpleSearchQueryEngine.this._whereExpressionValuesIndex.put(expression, result);
            Operand operand = expression.getLeftOperand();
            result.addPartialResult(this.parseOperand(operand));
            for (Operand element : expression.getRightOperands()) {
                result.addPartialResult(this.parseOperand(element));
            }
            return result;
        }

        private SSQEEvalResult parseLogicalExpression(LogicalExpression expression) {
            if (SimpleSearchQueryEngine.this._whereExpressionValuesIndex.get(expression) != null) {
                return (SSQEEvalResult)SimpleSearchQueryEngine.this._whereExpressionValuesIndex.get(expression);
            }
            if (expression.getName() != null && expression.getName().startsWith("$")) {
                return this.parseWhereExpression(this.getExpression(expression.getName().substring(1)));
            }
            SSQEEvalResult result = SimpleSearchQueryEngine.this.createEvalResult(expression);
            SimpleSearchQueryEngine.this._whereExpressionValuesIndex.put(expression, result);
            for (WhereExpression element : expression.getArguments()) {
                result.addPartialResult(this.parseWhereExpression(element));
            }
            return result;
        }

        private SSQEEvalResult parseNumericFunction(NumericFunction function) {
            if (SimpleSearchQueryEngine.this._whereExpressionValuesIndex.get(function) != null) {
                return (SSQEEvalResult)SimpleSearchQueryEngine.this._whereExpressionValuesIndex.get(function);
            }
            if (function.getName() != null && function.getName().startsWith("$")) {
                return this.parseOperand(this.getOperand(function.getName().substring(1)));
            }
            SSQEEvalResult result = SimpleSearchQueryEngine.this.createEvalResult(function);
            SimpleSearchQueryEngine.this._whereExpressionValuesIndex.put(function, result);
            for (Operand element : function.getArguments()) {
                result.addPartialResult(this.parseOperand(element));
            }
            return result;
        }

        private SSQEEvalResult parseOperand(Operand operand) {
            if (operand instanceof ArithmeticExpression) {
                return this.parseArithmeticExpression((ArithmeticExpression)operand);
            }
            if (operand instanceof NumericFunction) {
                return this.parseNumericFunction((NumericFunction)operand);
            }
            return this.parseSimpleOperand(operand);
        }

        private SSQEEvalResult parseSimpleOperand(Operand operand) {
            if (SimpleSearchQueryEngine.this._whereExpressionValuesIndex.get(operand) != null) {
                return (SSQEEvalResult)SimpleSearchQueryEngine.this._whereExpressionValuesIndex.get(operand);
            }
            if (operand.getName() != null && operand.getName().startsWith("$")) {
                return this.parseSimpleOperand(this.getOperand(operand.getName().substring(1)));
            }
            SSQEEvalResult result = SimpleSearchQueryEngine.this.createEvalResult(operand);
            SimpleSearchQueryEngine.this._whereExpressionValuesIndex.put(operand, result);
            return result;
        }
    }
}

