/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.hierarchy.util.internal;

import java.util.Arrays;

public class SizesAsPrimes {
    public static final float GROWTH_FACTOR = 1.25f;
    public static int[] growth1_13 = new int[]{89, 101, 127, 131, 149, 163, 191, 211, 233, 263, 293, 331, 373, 421, 479, 541, 607, 683, 773, 877, 983, 1109, 1259, 1423, 1597, 1811, 2039, 2309, 2609, 2939, 3319, 3761, 4241, 4787, 5413, 6113, 6907, 7817, 8819, 9967, 11257, 12721, 14369, 16249, 18353, 20731, 23431, 26479, 29917, 33797, 38189, 43151, 48761, 55103, 62273, 70373, 79531, 89833, 101513, 114713, 129629, 146477, 165511, 187027, 211339, 238829, 269851, 304933, 344587, 389369, 439991, 497197, 561829, 634853, 717397, 810643, 916031, 1035107, 1169669, 1321729, 1493539, 1687729, 1907107, 2155057, 2435179, 2751761, 3109471, 3513701, 3970489, 4486649, 5069921, 5728997, 6473801, 7315367, 8266351, 9340999, 10555301, 11927521, 13478077, 15230219, 17210147, 19447457, 21975637, 24832469, 28060699, 31708583, 0x222BB8B, 40488653, 45752207, 51699961, 58420969, 66015689, 74597723, 84295427, 95253863, 107636833, 121629617, 137441477, 155308877, 175499017};
    public static int[] growth1_33 = new int[]{89, 127, 157, 211, 277, 367, 487, 647, 859, 1151, 1523, 2017, 2683, 3571, 4751, 6299, 8377, 11149, 14813, 19699, 26203, 34843, 46349, 61631, 81971, 109037, 145007, 192847, 256483, 341123, 453683, 603391, 802511, 1067347, 1419557, 0x1CCF1F, 2511049, 3339709, 4441823, 5907589, 7857107, 10449931, 13898411, 18484889, 24584893, 32697913, 43488223, 57839323, 76926319, 102311983, 136074929};
    public static int[] growth1_50 = new int[]{89, 137, 211, 307, 449, 673, 1009, 1511, 2267, 3391, 5087, 7639, 11443, 17167, 25741, 38611, 57917, 86923, 130337, 195469, 293201, 439799, 659689, 989533, 1484291, 2226431, 3339647, 5009471, 7514231, 11271319, 16906949, 25360441, 38040619, 57060931, 85591417, 128387137};
    public static int[] growth1_75 = new int[]{89, 157, 277, 479, 839, 1451, 2539, 4441, 7789, 13597, 23801, 41641, 72859, 127493, 223129, 390449, 683273, 1195723, 2092529, 3661907, 6408323, 11214571, 19625491, 34344599, 60103063, 105180319};

    public static int getSize(float growthFactor, int extraRoom) {
        int growth = (int)growthFactor * 100;
        switch (growth) {
            case 113: {
                return SizesAsPrimes.getSize(growth1_13, extraRoom);
            }
            case 133: {
                return SizesAsPrimes.getSize(growth1_33, extraRoom);
            }
            case 150: {
                return SizesAsPrimes.getSize(growth1_50, extraRoom);
            }
            case 175: {
                return SizesAsPrimes.getSize(growth1_75, extraRoom);
            }
        }
        return SizesAsPrimes.getSize(growth1_13, extraRoom);
    }

    public static int getNextSize(float growthFactor, int sizeIndex) {
        int growth = (int)growthFactor * 100;
        switch (growth) {
            case 113: {
                return SizesAsPrimes.getNextSize(growth1_13, sizeIndex);
            }
            case 133: {
                return SizesAsPrimes.getNextSize(growth1_33, sizeIndex);
            }
            case 150: {
                return SizesAsPrimes.getNextSize(growth1_50, sizeIndex);
            }
            case 175: {
                return SizesAsPrimes.getNextSize(growth1_75, sizeIndex);
            }
        }
        return SizesAsPrimes.getSize(growth1_13, sizeIndex);
    }

    public static int getSize(int[] sizes, int extraRoom) {
        int res = Arrays.binarySearch(sizes, extraRoom);
        if (res < 0) {
            if (res == -sizes.length) {
                return extraRoom;
            }
            return sizes[-res];
        }
        return extraRoom;
    }

    public static int getNextSize(int[] sizes, int index) {
        if (++index >= sizes.length) {
            return -1;
        }
        return sizes[index];
    }
}

