/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.extensions.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.hyades.loaders.util.HyadesConfigurationElement;
import org.eclipse.hyades.loaders.util.RegistryReader;
import org.eclipse.hyades.models.hierarchy.plugin.ModelsHierarchyPlugin;
import org.eclipse.hyades.models.util.ModelDebugger;
import org.eclipse.tptp.platform.extensions.IApplicationManager;
import org.eclipse.tptp.platform.extensions.IApplicationManagerListener;
import org.eclipse.tptp.platform.extensions.IHandlerElement;
import org.eclipse.tptp.platform.extensions.impl.HandlerElementImpl;

public class TPTPApplicationManager
implements IApplicationManager {
    protected static final String DEFAULT_HANDLER = "defaultHandler";
    protected Map defaultHandlersByApplicationFunction = new HashMap();
    protected Map handlersByUniqueId = new HashMap();
    protected Map handlersByApplicationFunction = new HashMap();
    protected Set disabledOrReplacedHandlers = new HashSet();
    protected GenericHandlerRegistryReader registryReader;

    public TPTPApplicationManager() {
        this.init();
    }

    protected void init() {
        this.readRegistry();
        this.setDefaults();
    }

    protected void setDefaults() {
        for (Map.Entry entry : this.handlersByApplicationFunction.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            String defaultHandlerUniqueId = this.registryReader.getPluginCustomizationString(ModelsHierarchyPlugin.getPlugin().getBundle().getSymbolicName(), (entry.getKey() + "/" + DEFAULT_HANDLER).replace('/', '_'));
            List handlers = (List)entry.getValue();
            IHandlerElement maxPriorityHandler = null;
            IHandlerElement defaultHandler = null;
            for (IHandlerElement handler : handlers) {
                if ("disabled".equals(handler.getModifier())) continue;
                String handlerId = handler.getUniqueID();
                if (this.disabledOrReplacedHandlers.contains(handlerId)) {
                    if (!"replace".equals(handler.getModifier())) continue;
                    handlerId = handler.getTargetId();
                    if (handlerId.equals(defaultHandlerUniqueId)) {
                        defaultHandler = handler;
                        break;
                    }
                }
                if (handler.getUniqueID().equals(defaultHandlerUniqueId)) {
                    defaultHandler = handler;
                    break;
                }
                if (maxPriorityHandler != null && !(maxPriorityHandler.getPriority() < handler.getPriority())) continue;
                maxPriorityHandler = handler;
            }
            IHandlerElement existingHandler = (IHandlerElement)this.defaultHandlersByApplicationFunction.get(entry.getKey());
            if (defaultHandler != null) {
                if (existingHandler != null && !(existingHandler.getPriority() < defaultHandler.getPriority())) continue;
                this.defaultHandlersByApplicationFunction.put(entry.getKey(), defaultHandler);
                continue;
            }
            if (maxPriorityHandler == null || existingHandler != null && !(existingHandler.getPriority() < maxPriorityHandler.getPriority())) continue;
            this.defaultHandlersByApplicationFunction.put(entry.getKey(), maxPriorityHandler);
        }
    }

    protected void readRegistry() {
        this.registryReader = new GenericHandlerRegistryReader();
        this.registryReader.readRegistry();
    }

    public void addListener(IApplicationManagerListener listener, int targetEventType) {
    }

    public Object createDefaultHandlerInstance(String applicationAndFunction) {
        return this.createHandlerInstance(this.getDefaultHandlerElement(applicationAndFunction));
    }

    public Object createHandlerInstance(IHandlerElement handlerElement) {
        try {
            return this.registryReader.createPluginClassDescriptor(((HandlerElementImpl)handlerElement).getConfigurationElement(), "class").createInstance();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public List findHandlerElements(IHandlerElement templateQuery, boolean defaultsOnly) {
        if (templateQuery != null && templateQuery.getApplication() != null && templateQuery.getFunction() != null) {
            ArrayList<Object> result = new ArrayList<Object>();
            if (templateQuery.getId() != null) {
                result.add(this.handlersByUniqueId.get(templateQuery.getUniqueID()));
            } else {
                for (IHandlerElement handler : (List)this.handlersByApplicationFunction.get(String.valueOf(templateQuery.getApplication()) + "/" + templateQuery.getFunction())) {
                    if (handler == null) continue;
                    result.add(handler);
                }
            }
            return result;
        }
        return Arrays.asList(this.handlersByUniqueId.values().toArray());
    }

    public IHandlerElement getDefaultHandlerElement(String applicationAndFunction) {
        return (IHandlerElement)this.defaultHandlersByApplicationFunction.get(applicationAndFunction);
    }

    public void removeListener(IApplicationManagerListener listener, int targetEventType) {
    }

    public static IApplicationManager createInstance() {
        return new TPTPApplicationManager();
    }

    class GenericHandlerRegistryReader
    extends RegistryReader {
        static final String TAG_LOADER = "handler";

        public GenericHandlerRegistryReader() {
            super(ModelsHierarchyPlugin.INSTANCE.getSymbolicName(), TAG_LOADER);
        }

        protected boolean readElement(HyadesConfigurationElement element) {
            if (element.getName().equals(TAG_LOADER)) {
                if (element.getAttribute("class") == null) {
                    this.logMissingAttribute(element, "class");
                } else {
                    try {
                        HandlerElementImpl handler = new HandlerElementImpl();
                        handler.setConfigurationElement(element);
                        if (element.getAttribute("id") != null) {
                            handler.setId(element.getAttribute("id"));
                        }
                        if (element.getAttribute("application") != null) {
                            handler.setApplication(element.getAttribute("application"));
                        }
                        if (element.getAttribute("function") != null) {
                            handler.setFunction(element.getAttribute("function"));
                        }
                        if (element.getAttribute("class") != null) {
                            handler.setClassName(element.getAttribute("class"));
                        }
                        if (element.getAttribute("modifier") != null) {
                            handler.setModifier(element.getAttribute("modifier"));
                        }
                        if (element.getAttribute("name") != null) {
                            handler.setName(element.getAttribute("name"));
                        }
                        if (element.getElement() instanceof IConfigurationElement) {
                            handler.setOwner(((IConfigurationElement)element.getElement()).getContributor().getName());
                        }
                        if (element.getAttribute("parentId") != null) {
                            handler.setParentId(element.getAttribute("parentId"));
                        }
                        if (element.getAttribute("priority") != null) {
                            try {
                                handler.setPriority(Float.parseFloat(element.getAttribute("priority")));
                            }
                            catch (Exception e) {
                                ModelDebugger.log(e, "Error when reading extension point " + element.getDeclaringExtensionName() + ", attribute " + "priority");
                            }
                        }
                        if (element.getAttribute("targetId") != null) {
                            handler.setTargetId(element.getAttribute("targetId"));
                            if ("disabled".equals(handler.getModifier()) || "replace".equals(handler.getModifier())) {
                                TPTPApplicationManager.this.disabledOrReplacedHandlers.add(handler.getTargetId());
                            }
                        } else if (handler.getModifier() != null) {
                            ModelDebugger.log("Error when reading extension point " + element.getDeclaringExtensionName() + ", attribute targetId is empty!");
                        }
                        if (element.getAttribute("targetExtension") != null) {
                            handler.setTargetExtension(element.getAttribute("targetExtension"));
                        }
                        if (element.getAttribute("type") != null) {
                            handler.setType(element.getAttribute("type"));
                        }
                        if (element.getAttribute("version") != null) {
                            handler.setVersion(element.getAttribute("version"));
                        }
                        int i = 0;
                        while (i < element.getChildren().length) {
                            HyadesConfigurationElement child = element.getChildren()[i];
                            if (child.getName().equals("parameter") && child.getAttribute("name") != null) {
                                handler.getParametersNames().add(child.getAttribute("name"));
                                handler.getParametersValues().add(child.getAttribute("value"));
                            }
                            ++i;
                        }
                        String disabled = ModelsHierarchyPlugin.getPlugin().getPluginPreferences().getString(String.valueOf(handler.getUniqueID()) + "." + "disabled");
                        if (Boolean.valueOf(disabled).booleanValue()) {
                            TPTPApplicationManager.this.disabledOrReplacedHandlers.add(handler.getUniqueID());
                        } else {
                            IHandlerElement existingHandler;
                            ArrayList<HandlerElementImpl> handlers = (ArrayList<HandlerElementImpl>)TPTPApplicationManager.this.handlersByApplicationFunction.get(String.valueOf(handler.getApplication()) + "/" + handler.getFunction());
                            if (handlers == null) {
                                handlers = new ArrayList<HandlerElementImpl>();
                                TPTPApplicationManager.this.handlersByApplicationFunction.put(String.valueOf(handler.getApplication()) + "/" + handler.getFunction(), handlers);
                            }
                            if ((existingHandler = (IHandlerElement)TPTPApplicationManager.this.handlersByUniqueId.get(handler.getUniqueID())) == null) {
                                TPTPApplicationManager.this.handlersByUniqueId.put(handler.getUniqueID(), handler);
                                handlers.add(handler);
                            } else if (existingHandler.getVersion().compareTo(handler.getVersion()) > 0) {
                                TPTPApplicationManager.this.handlersByUniqueId.put(handler.getUniqueID(), handler);
                                handlers.remove(existingHandler);
                                TPTPApplicationManager.this.disabledOrReplacedHandlers.add(existingHandler);
                                handlers.add(handler);
                            }
                        }
                    }
                    catch (Exception e) {
                        this.logError(element, e.getLocalizedMessage());
                    }
                    return true;
                }
            }
            return false;
        }
    }
}

