/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.common;

import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.hyades.loaders.common.ExecutionXMLLoadersFactory;
import org.eclipse.hyades.loaders.common.XMLexecutionEventLoader;
import org.eclipse.hyades.loaders.common.XMLinvocationEventLoader;
import org.eclipse.hyades.loaders.common.XMLloopEventLoader;
import org.eclipse.hyades.loaders.common.XMLmessageEventLoader;
import org.eclipse.hyades.loaders.common.XMLtimedEventLoader;
import org.eclipse.hyades.loaders.common.XMLtypedEventLoader;
import org.eclipse.hyades.loaders.common.XMLverdictEventLoader;
import org.eclipse.hyades.loaders.common.XMLwaitEventLoader;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupService;

public class GenerateConstants {
    private static Class[] classes = new Class[]{ExecutionXMLLoadersFactory.class, XMLtimedEventLoader.class, XMLwaitEventLoader.class, XMLexecutionEventLoader.class, XMLloopEventLoader.class, XMLtypedEventLoader.class, XMLmessageEventLoader.class, XMLverdictEventLoader.class, XMLinvocationEventLoader.class};
    private static Class[] lookUpServiceClasses = new Class[0];

    public static void main(String[] args) {
        GenerateConstants generateConstants = new GenerateConstants();
        generateConstants.processClasses();
    }

    private void processClasses() {
        ArrayList list = new ArrayList();
        int i = 0;
        while (i < classes.length) {
            this.addFieldsName(classes[i], list);
            ++i;
        }
        i = 0;
        while (i < lookUpServiceClasses.length) {
            this.addLookUpServiceName(lookUpServiceClasses[i], list);
            ++i;
        }
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((String[])o1)[0].compareTo(((String[])o2)[0]);
            }
        });
        try {
            PrintWriter out = new PrintWriter(new FileWriter("C:/temp/ExecutionConstants.java"));
            out.println("/**********************************************************************\n * Copyright (c) 2003, 2010 IBM Corporation and others.\n * All rights reserved.   This program and the accompanying materials\n * are made available under the terms of the Eclipse Public License v1.0\n * which accompanies this distribution, and is available at\n * http://www.eclipse.org/legal/epl-v10.html\n * $Id: GenerateConstants.java,v 1.11 2010/09/08 15:20:49 mreid Exp $\n * \n * Contributors:\n * IBM - Initial API and implementation\n **********************************************************************/\npackage org.eclipse.hyades.loaders.common;\n\n/**\n * <p>Generated by {@link GenerateConstants}.</p>\n * \n * \n * @author  Ashish K. Mathur\n * @author  Joseph P. Toomey\n * @version " + SimpleDateFormat.getPatternInstance((String)"MMMM d, yyyy").format(Calendar.getInstance().getTime()) + "\n" + " * @since   January 25, 2005\n" + " */\n" + "public class ExecutionConstants {\n");
            for (String[] field : list) {
                out.println("\tprotected static final int " + field[0] + "_int = " + LoadersUtils.getHashCode((String)field[1]) + ";");
            }
            out.println("}\n");
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void addLookUpServiceName(Class class1, List list) {
        try {
            LookupService lookupService = (LookupService)class1.newInstance();
            for (Class element : lookupService.getSupportedTypes()) {
                String name = element.getName();
                if (name.lastIndexOf(46) > 0) {
                    name = name.substring(name.lastIndexOf(46) + 1);
                }
                list.add(new String[]{name, element.getName()});
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private void addFieldsName(Class theClass, List list) {
        try {
            Field[] fields = theClass.getDeclaredFields();
            int i = 0;
            while (i < fields.length) {
                Object value;
                int mod = fields[i].getModifiers();
                if (Modifier.isProtected(mod) && Modifier.isStatic(mod) && Modifier.isFinal(mod) && fields[i].getType() == String.class && (value = fields[i].get(null)) != null) {
                    list.add(new String[]{fields[i].getName(), value.toString()});
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

