/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.trace;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.eclipse.hyades.loaders.trace.TraceLookupService;
import org.eclipse.hyades.loaders.trace.TraceMethodBaseLoader;
import org.eclipse.hyades.loaders.trace.TraceXMLFragmentLoader;
import org.eclipse.hyades.loaders.trace.TraceXMLLoadersFactory;
import org.eclipse.hyades.loaders.trace.XMLagMethodEntryLoader;
import org.eclipse.hyades.loaders.trace.XMLagMethodExitLoader;
import org.eclipse.hyades.loaders.trace.XMLclassDefLoader;
import org.eclipse.hyades.loaders.trace.XMLgcFinishLoader;
import org.eclipse.hyades.loaders.trace.XMLgcRootLoader;
import org.eclipse.hyades.loaders.trace.XMLgcStartLoader;
import org.eclipse.hyades.loaders.trace.XMLheapDumpDefLoader;
import org.eclipse.hyades.loaders.trace.XMLmethodDefLoader;
import org.eclipse.hyades.loaders.trace.XMLmethodEntryLoader;
import org.eclipse.hyades.loaders.trace.XMLmethodExitLoader;
import org.eclipse.hyades.loaders.trace.XMLmethodInvocationsLoader;
import org.eclipse.hyades.loaders.trace.XMLmonContendedEnterLoader;
import org.eclipse.hyades.loaders.trace.XMLmonNotifyCalledLoader;
import org.eclipse.hyades.loaders.trace.XMLmonStillOwnedLoader;
import org.eclipse.hyades.loaders.trace.XMLmonWaitLoader;
import org.eclipse.hyades.loaders.trace.XMLobjAllocLoader;
import org.eclipse.hyades.loaders.trace.XMLobjReferenceLoader;
import org.eclipse.hyades.loaders.trace.XMLthreadInterruptCalledLoader;
import org.eclipse.hyades.loaders.trace.XMLthreadSleepEndLoader;
import org.eclipse.hyades.loaders.trace.XMLthreadSleepStartLoader;
import org.eclipse.hyades.loaders.trace.XMLthreadStartCalledLoader;
import org.eclipse.hyades.loaders.trace.XMLthreadStartLoader;
import org.eclipse.hyades.loaders.trace.XMLtraceStartLoader;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupService;
import org.eclipse.hyades.models.util.ModelDebugger;

public class GenerateConstants {
    private static Class[] classes = new Class[]{TraceXMLLoadersFactory.class, TraceXMLFragmentLoader.class, XMLobjAllocLoader.class, XMLclassDefLoader.class, XMLmethodDefLoader.class, TraceMethodBaseLoader.class, XMLmethodEntryLoader.class, XMLmethodExitLoader.class, XMLthreadStartLoader.class, XMLheapDumpDefLoader.class, XMLobjReferenceLoader.class, XMLgcRootLoader.class, XMLmonWaitLoader.class, XMLmonContendedEnterLoader.class, XMLmonStillOwnedLoader.class, XMLtraceStartLoader.class, XMLmethodInvocationsLoader.class, XMLagMethodEntryLoader.class, XMLagMethodExitLoader.class, XMLgcStartLoader.class, XMLgcFinishLoader.class, XMLmonNotifyCalledLoader.class, XMLthreadInterruptCalledLoader.class, XMLthreadStartCalledLoader.class, XMLthreadSleepStartLoader.class, XMLthreadSleepEndLoader.class};
    private static Class[] lookUpServiceClasses = new Class[]{TraceLookupService.class};
    private String[] args;

    public static void main(String[] args) {
        GenerateConstants generateConstants = new GenerateConstants();
        generateConstants.setArgs(args);
        generateConstants.processClasses();
    }

    protected void setArgs(String[] args) {
        this.args = args;
    }

    private void processClasses() {
        ArrayList list = new ArrayList();
        int i = 0;
        while (i < classes.length) {
            this.addFieldsName(classes[i], list);
            ++i;
        }
        i = 0;
        while (i < lookUpServiceClasses.length) {
            this.addLookUpServiceName(lookUpServiceClasses[i], list);
            ++i;
        }
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((String[])o1)[0].compareTo(((String[])o2)[0]);
            }
        });
        PrintWriter out = null;
        try {
            out = new PrintWriter(new FileWriter(this.args[0]));
            out.println("/**********************************************************************\n * Copyright (c) 2003, 2007 IBM Corporation and others.\n * All rights reserved.   This program and the accompanying materials\n * are made available under the terms of the Eclipse Public License v1.0\n * which accompanies this distribution, and is available at\n * http://www.eclipse.org/legal/epl-v10.html\n *\n * Contributors:\n * IBM - Initial API and implementation\n *\n * $Id: GenerateConstants.java,v 1.14 2010/05/11 16:30:05 jwest Exp $\n **********************************************************************/\npackage org.eclipse.hyades.loaders.trace;\n\n/**\n * @author slavescu\n */\npublic class TraceConstants {\n");
            HashSet<String> processed = new HashSet<String>();
            for (String[] field : list) {
                if (processed.contains(field[0])) continue;
                processed.add(field[0]);
                out.println("\tprotected static final int " + field[0] + "_int = " + LoadersUtils.getHashCode((String)field[1]) + ";");
            }
            out.println("}\n");
            out.close();
        }
        catch (IOException e) {
            if (out != null) {
                out.close();
            }
            ModelDebugger.log((Throwable)e);
        }
    }

    private void addLookUpServiceName(Class class1, List list) {
        try {
            LookupService lookupService = (LookupService)class1.newInstance();
            for (Class element : lookupService.getSupportedTypes()) {
                String name = element.getName();
                if (name.lastIndexOf(46) > 0) {
                    name = name.substring(name.lastIndexOf(46) + 1);
                }
                list.add(new String[]{name, element.getName()});
            }
        }
        catch (InstantiationException e) {
            ModelDebugger.log((Throwable)e);
        }
        catch (IllegalAccessException e) {
            ModelDebugger.log((Throwable)e);
        }
    }

    private void addFieldsName(Class theClass, List list) {
        try {
            Field[] fields = theClass.getDeclaredFields();
            int i = 0;
            while (i < fields.length) {
                Object value;
                int mod = fields[i].getModifiers();
                if (Modifier.isProtected(mod) && Modifier.isStatic(mod) && Modifier.isFinal(mod) && fields[i].getType() == String.class && (value = fields[i].get(null)) != null) {
                    list.add(new String[]{fields[i].getName(), value.toString()});
                }
                ++i;
            }
        }
        catch (Exception e) {
            ModelDebugger.log((Throwable)e);
        }
    }
}

