/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.trace;

import org.eclipse.hyades.models.trace.TRCObject;

public class TRCObjectEntry {
    private TRCObject[] data;

    public TRCObject get(Class type) {
        if (this.data != null) {
            int i = 0;
            while (i < this.data.length) {
                if (this.data[i].getClass() == type) {
                    return this.data[i];
                }
                ++i;
            }
        }
        return null;
    }

    public boolean put(Class type, TRCObject value) {
        if (this.data != null) {
            int i = 0;
            while (i < this.data.length) {
                if (this.data[i].getClass() == type) {
                    this.data[i] = value;
                    return true;
                }
                ++i;
            }
        }
        this.addValue(value);
        return false;
    }

    private void addValue(TRCObject value) {
        if (this.data == null) {
            this.data = new TRCObject[1];
            this.data[0] = value;
        } else {
            TRCObject[] newArray = new TRCObject[this.data.length + 1];
            System.arraycopy(this.data, 0, newArray, 0, this.data.length);
            newArray[this.data.length] = value;
            this.data = newArray;
        }
    }

    public boolean remove(Class type) {
        if (this.data != null) {
            int i = 0;
            while (i < this.data.length) {
                if (this.data[i].getClass() == type) {
                    this.remove(i);
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private void remove(long i) {
        if (this.data.length == 1) {
            this.data = null;
            return;
        }
        int j = (int)i;
        TRCObject[] newArray = new TRCObject[this.data.length - 1];
        System.arraycopy(this.data, 0, newArray, 0, j);
        System.arraycopy(this.data, j + 1, newArray, j, this.data.length - j);
        this.data = newArray;
    }

    public long getId() {
        if (this.data != null && this.data.length > 0) {
            return this.data[0].getId();
        }
        return -1L;
    }
}

