/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.trace;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.loaders.trace.CallStackPerThread;
import org.eclipse.hyades.loaders.trace.InvocationContext;
import org.eclipse.hyades.loaders.trace.TraceUtils;
import org.eclipse.hyades.loaders.trace.TraceXMLFragmentLoader;
import org.eclipse.hyades.loaders.util.AgentsContext;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.models.hierarchy.CorrelationSourceInfo;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.UnresolvedCorrelation;
import org.eclipse.hyades.models.hierarchy.impl.UnresolvedCorrelationImpl;
import org.eclipse.hyades.models.hierarchy.util.FastList;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.models.hierarchy.util.LongToObjectMap;
import org.eclipse.hyades.models.hierarchy.util.SaveUtil;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TRCInputOutputContainer;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCObjectValue;
import org.eclipse.hyades.models.trace.TRCObjectValueKind;
import org.eclipse.hyades.models.trace.TRCObjectValuePosition;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCTypedObjectValue;
import org.eclipse.hyades.models.trace.TraceFactory;
import org.eclipse.hyades.models.trace.TracePackage;
import org.eclipse.hyades.models.trace.impl.TRCFullMethodInvocationImpl;
import org.eclipse.hyades.models.trace.impl.TRCThreadImpl;
import org.eclipse.hyades.models.util.ModelDebugger;

public class TraceMethodBaseLoader
extends TraceXMLFragmentLoader {
    protected static final String TICKET = "ticket";
    protected static final String STACK_DEPTH = "stackDepth";
    protected static final String PARAMETER = "parameter";
    protected static final String RETURN_VALUE = "returnValue";
    protected static final String VALUE = "value";
    protected static final String VALUE_KIND = "valueKind";
    protected static final String VALUE_POSITION = "valuePos";
    protected static final String PARAM_INDEX = "index";
    protected static final String PARAMETER_ID_REF = "parameterIdRef";
    protected static final String INVOCATION_CONTEXT = "InvocationContext";
    protected static final String AGENT_ID_REF = "agentIdRef";
    protected static final String PROCESS_ID_REF = "processIdRef";
    protected static final String NODE_ID_REF = "nodeIdRef";
    protected static final String SEQUENCE_COUNTER = "sequenceCounter";
    protected static final String REMOTE_AGENT_ID_REF = "remoteAgentIdRef";
    protected static final String REMOTE_PROCESS_ID_REF = "remoteProcessIdRef";
    protected static final String REMOTE_NODE_ID_REF = "remoteNodeIdRef";
    protected static final String REMOTE_SEQUENCE_COUNTER = "remoteSequenceCounter";
    protected static final String REMOTE_THREAD_ID_REF = "remoteThreadIdRef";
    protected static final String REMOTE_TICKET = "remoteTicket";
    protected CallStackPerThread cs;
    protected TraceUtils.InvocationPool invocationPool;
    protected TRCClass invokerClass;
    protected TRCClass invokerObjectClass;
    protected TRCFullMethodInvocation fullInvocation;
    protected TRCFullMethodInvocation fullInvoker;
    protected TRCFullTraceObject invokerObject;
    protected TRCMethod invokerMethod;
    protected double deltaBaseTime;
    protected double deltaCumulativeTime;
    protected double lastChildExitTime;
    protected double previousSiblingExitTime;
    protected long ticket;
    protected short stackDepth;
    protected List<TRCObjectValue> inputValues = new FastList();
    protected List<TRCObjectValue> outputValues = new FastList();
    protected InvocationContext invocationContext = new InvocationContext();
    protected boolean activeInvocationContext;
    protected long sequenceCounter;
    protected static final Object REMOTE_INVOCATION_RESOLUTION_LOCK = new Object();
    protected boolean remoteInvocationContext;
    protected int childId;
    protected boolean useUpdateStatisticalInfoOld = false;

    protected void updateTimeStatisticsNew() {
        this.updateBaseTime();
        int i = this.cs.size();
        while (i-- > 0) {
            TRCClass objectClass;
            TRCFullTraceObject obj;
            TraceUtils.InvocationInfo invocationInfo = (TraceUtils.InvocationInfo)this.cs.get(i);
            if (!invocationInfo.isObjectLocked() && (obj = invocationInfo.getObject()) != null) {
                obj.setCumulativeTime(obj.getCumulativeTime() + this.deltaCumulativeTime);
            }
            if ((objectClass = invocationInfo.getObjectClass()) != null && !invocationInfo.isObjectClassLocked()) {
                objectClass.setInheritedCumulativeTime(objectClass.getInheritedCumulativeTime() + this.deltaCumulativeTime);
                objectClass.getPackage().setInheritedCumulativeTime(objectClass.getPackage().getInheritedCumulativeTime() + this.deltaCumulativeTime);
                objectClass.getPackage().getProcess().setInheritedCumulativeTime(objectClass.getPackage().getProcess().getInheritedCumulativeTime() + this.deltaCumulativeTime);
            }
            if (!invocationInfo.isMethodLocked()) {
                invocationInfo.getMethod().setCumulativeTime(invocationInfo.getMethod().getCumulativeTime() + this.deltaCumulativeTime);
            }
            if (invocationInfo.isClassLocked()) continue;
            this.invokerClass = invocationInfo.getTheClass();
            this.invokerClass.setCumulativeTime(this.invokerClass.getCumulativeTime() + this.deltaCumulativeTime);
            if (!invocationInfo.isPackageLocked()) {
                this.invokerClass.getPackage().setCumulativeTime(this.invokerClass.getPackage().getCumulativeTime() + this.deltaCumulativeTime);
            }
            this.invokerClass.getPackage().getProcess().setCumulativeTime(this.invokerClass.getPackage().getProcess().getCumulativeTime() + this.deltaCumulativeTime);
        }
    }

    protected void updateBaseTime() {
        this.invokerMethod.setBaseTime(this.invokerMethod.getBaseTime() + this.deltaBaseTime);
        if (this.invokerObject != null) {
            this.invokerObject.setBaseTime(this.invokerObject.getBaseTime() + this.deltaBaseTime);
            if (this.invokerObjectClass != null) {
                this.invokerObjectClass.setInheritedBaseTime(this.invokerObjectClass.getInheritedBaseTime() + this.deltaBaseTime);
                this.invokerObjectClass.getPackage().setInheritedBaseTime(this.invokerObjectClass.getPackage().getInheritedBaseTime() + this.deltaBaseTime);
                this.invokerObjectClass.getPackage().getProcess().setInheritedBaseTime(this.invokerObjectClass.getPackage().getProcess().getInheritedBaseTime() + this.deltaBaseTime);
            }
        }
        this.invokerClass.setBaseTime(this.invokerClass.getBaseTime() + this.deltaBaseTime);
        this.invokerClass.getPackage().setBaseTime(this.invokerClass.getPackage().getBaseTime() + this.deltaBaseTime);
        this.invokerClass.getPackage().getProcess().setBaseTime(this.invokerClass.getPackage().getProcess().getBaseTime() + this.deltaBaseTime);
    }

    protected void updateTimeStatistics() {
        this.updateBaseTime();
        int i = this.cs.size();
        while (i-- > 0) {
            TRCClass objectClass;
            TRCFullTraceObject obj;
            TraceUtils.InvocationInfo invocationInfo = (TraceUtils.InvocationInfo)this.cs.get(i);
            if (!invocationInfo.isObjectLocked() && (obj = invocationInfo.getObject()) != null) {
                obj.setCumulativeTime(obj.getCumulativeTime() + this.deltaBaseTime);
            }
            if ((objectClass = invocationInfo.getObjectClass()) != null && !invocationInfo.isObjectClassLocked()) {
                objectClass.setInheritedCumulativeTime(objectClass.getInheritedCumulativeTime() + this.deltaBaseTime);
                objectClass.getPackage().setInheritedCumulativeTime(objectClass.getPackage().getInheritedCumulativeTime() + this.deltaBaseTime);
                objectClass.getPackage().getProcess().setInheritedCumulativeTime(objectClass.getPackage().getProcess().getInheritedCumulativeTime() + this.deltaBaseTime);
            }
            if (!invocationInfo.isMethodLocked()) {
                invocationInfo.getMethod().setCumulativeTime(invocationInfo.getMethod().getCumulativeTime() + this.deltaBaseTime);
            }
            if (invocationInfo.isClassLocked()) continue;
            this.invokerClass = invocationInfo.getTheClass();
            this.invokerClass.setCumulativeTime(this.invokerClass.getCumulativeTime() + this.deltaBaseTime);
            if (!invocationInfo.isPackageLocked()) {
                this.invokerClass.getPackage().setCumulativeTime(this.invokerClass.getPackage().getCumulativeTime() + this.deltaBaseTime);
            }
            this.invokerClass.getPackage().getProcess().setCumulativeTime(this.invokerClass.getPackage().getProcess().getCumulativeTime() + this.deltaBaseTime);
        }
    }

    protected TRCClass getExtendedClass(TRCObject anObject, TRCClass aClass) {
        if (anObject != null && anObject.getIsA() != aClass && anObject.getIsA() != this.theProcess.getClassClass()) {
            return anObject.getIsA();
        }
        return null;
    }

    protected void setMaxStackDepth(TRCThread theThread) {
        if (theThread == null) {
            return;
        }
        if (this.stackDepth > theThread.getMaxStackDepth()) {
            theThread.setMaxStackDepth(this.stackDepth);
        }
    }

    public void startChild(String name) {
        super.startChild(name);
        if (name.equals(PARAMETER)) {
            this.objectValue = TraceFactory.eINSTANCE.createTRCObjectValue();
            this.inputValues.add(this.objectValue);
            this.childId = 1954460585;
        } else if (name.equals(RETURN_VALUE)) {
            this.objectValue = TraceFactory.eINSTANCE.createTRCObjectValue();
            this.outputValues.add(this.objectValue);
            this.childId = -1495129567;
        } else {
            this.childId = 0;
        }
    }

    public void endChild(String name) {
        super.endChild(name);
        if (name.equals(PARAMETER) || name.equals(RETURN_VALUE)) {
            this.objectValue = null;
            this.childId = 0;
        }
    }

    public void addInputOutputValues() {
        if (this.inputValues.isEmpty() && this.outputValues.isEmpty()) {
            return;
        }
        EList l = (EList)this.getInputOutputContainer().getEntries().get((Object)this.fullInvocation);
        if (l == null) {
            l = new BasicEList(0);
            this.getInputOutputContainer().getEntries().put((Object)this.fullInvocation, (Object)l);
            l = (EList)this.getInputOutputContainer().getEntries().get((Object)this.fullInvocation);
        }
        if (!this.outputValues.isEmpty()) {
            if (l.isEmpty()) {
                l.add((Object)this.outputValues.get(this.outputValues.size() - 1));
            } else {
                l.set(0, (Object)this.outputValues.get(this.outputValues.size() - 1));
            }
        } else if (l.isEmpty()) {
            TRCObjectValue objectValue = TraceFactory.eINSTANCE.createTRCObjectValue();
            l.add((Object)objectValue);
        }
        if (!this.inputValues.isEmpty()) {
            l.addAll(this.inputValues);
        }
    }

    protected TRCInputOutputContainer getInputOutputContainer() {
        TRCInputOutputContainer inputOutputContainer = this.getProcess().getInputOutputContainer();
        if (inputOutputContainer == null) {
            inputOutputContainer = TraceFactory.eINSTANCE.createTRCInputOutputContainer();
            inputOutputContainer.setProcess(this.getProcess());
            Resource r = this.createInputOutputContainerResource(inputOutputContainer);
            r.getContents().add((Object)inputOutputContainer);
        }
        return inputOutputContainer;
    }

    protected Resource createInputOutputContainerResource(TRCInputOutputContainer inputOutputContainer) {
        String uri = inputOutputContainer.getProcess().eResource().getURI().toString();
        String newUri = uri.substring(0, uri.indexOf(".trca"));
        newUri = newUri.concat(".trciov").concat(uri.substring(uri.indexOf(".trca") + 5));
        return HierarchyResourceSetImpl.getInstance().createResource(SaveUtil.createURI((String)newUri));
    }

    public void addAttribute(String name, String value) {
        switch (LoadersUtils.getHashCode((String)name)) {
            case 2011131163: {
                this.stackDepth = Short.parseShort(value);
                break;
            }
            case -873960692: {
                if (!this.activeInvocationContext) {
                    this.ticket = Long.parseLong(value);
                    break;
                }
                this.invocationContext.setInvocationTicket(Long.parseLong(value));
                break;
            }
            case -360813829: {
                if (!this.activeInvocationContext) {
                    this.sequenceCounter = Long.parseLong(value);
                    break;
                }
                this.invocationContext.setInvocationSequenceCounter(Long.parseLong(value));
                break;
            }
            case 445000854: {
                if (!this.activeInvocationContext) break;
                this.invocationContext.setInvocationNodeIdRef(value);
                break;
            }
            case 1972566089: {
                if (!this.activeInvocationContext) break;
                this.invocationContext.setInvocationProcessIdRef(value);
                break;
            }
            case -1203355277: {
                if (!this.activeInvocationContext) break;
                this.invocationContext.setInvocationAgentIdRef(value);
                break;
            }
            case 1910215054: {
                if (!this.activeInvocationContext) {
                    this.threadIdRef = Integer.parseInt(value);
                    break;
                }
                this.invocationContext.setInvocationThreadIdRef(Integer.parseInt(value));
                break;
            }
            case -426379687: {
                if (!this.remoteInvocationContext) {
                    this.setNullInvocationContext();
                    this.remoteInvocationContext = true;
                }
                this.invocationContext.setInvocationAgentIdRef(value);
                break;
            }
            case 1855537904: {
                if (!this.remoteInvocationContext) {
                    this.setNullInvocationContext();
                    this.remoteInvocationContext = true;
                }
                this.invocationContext.setInvocationNodeIdRef(value);
                break;
            }
            case 1321798575: {
                if (!this.remoteInvocationContext) {
                    this.setNullInvocationContext();
                    this.remoteInvocationContext = true;
                }
                this.invocationContext.setInvocationProcessIdRef(value);
                break;
            }
            case 226654568: {
                if (!this.remoteInvocationContext) {
                    this.setNullInvocationContext();
                    this.remoteInvocationContext = true;
                }
                this.invocationContext.setInvocationThreadIdRef(Integer.parseInt(value));
                break;
            }
            case 106550741: {
                if (!this.remoteInvocationContext) {
                    this.setNullInvocationContext();
                    this.remoteInvocationContext = true;
                }
                this.invocationContext.setInvocationSequenceCounter(Long.parseLong(value));
                break;
            }
            case -26049806: {
                if (!this.remoteInvocationContext) {
                    this.setNullInvocationContext();
                    this.remoteInvocationContext = true;
                }
                this.invocationContext.setInvocationTicket(Long.parseLong(value));
                break;
            }
            case 1112512335: {
                break;
            }
            case -765976411: {
                if (this.objectValue == null) break;
                this.convertToTypedObjectValue();
                ((TRCTypedObjectValue)this.objectValue).setValueKind(TRCObjectValueKind.get(value));
                break;
            }
            case -1410177245: {
                if (this.objectValue == null) break;
                this.convertToTypedObjectValue();
                ((TRCTypedObjectValue)this.objectValue).setPositionKind(TRCObjectValuePosition.get(value));
                break;
            }
            case 100346066: {
                if (this.objectValue == null) break;
                this.convertToTypedObjectValue();
                ((TRCTypedObjectValue)this.objectValue).setPosition(Short.parseShort(value));
                break;
            }
            default: {
                super.addAttribute(name, value);
            }
        }
    }

    protected void convertToTypedObjectValue() {
        if (this.objectValue instanceof TRCTypedObjectValue) {
            return;
        }
        TRCTypedObjectValue newObjectValue = TraceFactory.eINSTANCE.createTRCTypedObjectValue();
        newObjectValue.setStringValue(this.objectValue.getStringValue());
        if (this.childId == 1954460585) {
            int i = this.inputValues.indexOf(this.objectValue);
            if (i < 0) {
                this.inputValues.add(newObjectValue);
            } else {
                this.inputValues.set(i, newObjectValue);
            }
        } else if (this.childId == -1495129567) {
            int i = this.outputValues.indexOf(this.objectValue);
            if (i < 0) {
                this.outputValues.add(newObjectValue);
            } else {
                this.outputValues.set(i, newObjectValue);
            }
        }
        this.objectValue = newObjectValue;
    }

    protected void setNullInvocationContext() {
        this.invocationContext.setInvocationAgentIdRef(null);
        this.invocationContext.setInvocationNodeIdRef(null);
        this.invocationContext.setInvocationProcessIdRef(null);
        this.invocationContext.setInvocationSequenceCounter(0L);
        this.invocationContext.setInvocationThreadIdRef(0);
        this.invocationContext.setInvocationTicket(0L);
    }

    public void initialize(HierarchyContext context, String name) {
        super.initialize(context, name);
        this.activeInvocationContext = false;
        this.remoteInvocationContext = false;
        this.stackDepth = 0;
        this.ticket = 0L;
        this.sequenceCounter = 0L;
        this.inputValues.clear();
        this.outputValues.clear();
        this.objectValue = null;
    }

    protected TRCFullMethodInvocation resolveInvocation(InvocationContext invContext) {
        TRCFullMethodInvocation targetInvocation = null;
        try {
            LongToObjectMap ticketsMap;
            HierarchyContext targetContext;
            TRCAgent targetAgent = null;
            AgentsContext agentsContext = (AgentsContext)LookupServiceExtensions.getInstance().locate(null, AgentsContext.class, LoadersUtils.getLookUpKey((String)invContext.getInvocationAgentIdRef()));
            if (agentsContext != null) {
                targetAgent = agentsContext.getActiveAgent(this.context.getAgent());
            }
            if (targetAgent != null && (targetContext = LoadersUtils.locateHierarchyContext(targetAgent)) != null && (ticketsMap = (LongToObjectMap)LookupServiceExtensions.getInstance().locate(targetContext, TRCFullMethodInvocation.class, invContext.getInvocationThreadIdRef())) != null && (targetInvocation = (TRCFullMethodInvocation)ticketsMap.get(invContext.getInvocationTicket())) == null) {
                boolean inOrder = false;
                TRCThread targetThread = (TRCThread)LookupServiceExtensions.getInstance().locate(targetContext, TRCThreadImpl.class, invContext.getInvocationThreadIdRef());
                if (targetThread != null) {
                    for (TRCFullMethodInvocation this.fullInvoker : targetThread.getInitialInvocations()) {
                        if (!TRCFullMethodInvocationImpl.class.isAssignableFrom(this.fullInvoker.getClass())) continue;
                        if (this.fullInvoker.getThread() == targetThread && ((TRCFullMethodInvocationImpl)this.fullInvoker).getTicket() == invContext.getInvocationTicket()) {
                            inOrder = true;
                            break;
                        }
                        if (!this.checkTicket(targetThread, this.fullInvoker.getInvokes(), invContext.getInvocationTicket())) continue;
                        inOrder = true;
                        break;
                    }
                }
                if (inOrder) {
                    targetInvocation = this.fullInvoker;
                }
            }
        }
        catch (Exception e) {
            ModelDebugger.log((Throwable)e);
        }
        return targetInvocation;
    }

    protected boolean checkTicket(TRCThread theThread, EList list, long ticket) {
        boolean inOrder = false;
        for (TRCFullMethodInvocation this.fullInvoker : list) {
            if (this.fullInvoker.getClass() != TRCFullMethodInvocationImpl.class) continue;
            if (this.fullInvoker.getThread() == theThread && ((TRCFullMethodInvocationImpl)this.fullInvoker).getTicket() == ticket) {
                inOrder = true;
                break;
            }
            if (!this.checkTicket(theThread, this.fullInvoker.getInvokes(), ticket)) continue;
            inOrder = true;
            break;
        }
        return inOrder;
    }

    /*
     * Unable to fully structure code
     */
    protected TRCMethodInvocation setInvokerMethod(TRCThread thread, TRCMethodInvocation invocation) {
        block5: {
            block4: {
                if (!this.activeInvocationContext && !this.remoteInvocationContext) break block4;
                this.fullInvoker = this.resolveInvocation(this.invocationContext);
                if (this.fullInvoker == null) {
                    this.addForwardInvocation(invocation);
                } else {
                    invocation.setInvokedBy(this.fullInvoker);
                }
                break block5;
            }
            if (this.cs != null && !this.cs.isEmpty()) {
                this.fullInvoker = ((TraceUtils.InvocationInfo)this.cs.peek()).getMethodInvocation();
            }
            if (this.fullInvoker == null) break block5;
            if (this.fullInvoker.getStackDepth() >= this.stackDepth) ** GOTO lbl19
            invocation.setInvokedBy(this.fullInvoker);
            break block5;
lbl-1000:
            // 1 sources

            {
                this.fullInvoker = (TRCFullMethodInvocation)this.fullInvoker.getInvokedBy();
                if (this.fullInvoker.getStackDepth() >= this.stackDepth) continue;
                invocation.setInvokedBy(this.fullInvoker);
                break;
lbl19:
                // 2 sources

                ** while (this.fullInvoker.getInvokedBy() != null && this.fullInvoker.getInvokedBy() instanceof TRCFullMethodInvocation)
            }
        }
        return this.fullInvoker;
    }

    protected void addForwardInvocation(TRCMethodInvocation invocation) {
        String contextId = String.valueOf(this.invocationContext.getInvocationAgentIdRef()) + "/" + this.invocationContext.getInvocationThreadIdRef() + "/" + this.invocationContext.getInvocationTicket() + "/" + this.invocationContext.getInvocationSequenceCounter();
        UnresolvedCorrelation unresolvedCorrelation = HierarchyFactory.eINSTANCE.createUnresolvedCorrelation();
        unresolvedCorrelation.setContextId(contextId);
        CorrelationSourceInfo correlationSourceInfo = HierarchyFactory.eINSTANCE.createCorrelationSourceInfo();
        correlationSourceInfo.setOwner((EObject)invocation);
        correlationSourceInfo.setReference(TracePackage.eINSTANCE.getTRCMethodInvocation_InvokedBy());
        unresolvedCorrelation.getSourceInfos().add((Object)correlationSourceInfo);
        unresolvedCorrelation.setAgent(this.context.getAgent());
    }

    protected void updateForwardInvokes(TRCMethodInvocation sourceInvocation) {
        UnresolvedCorrelation unresolvedCorrelation = (UnresolvedCorrelation)LookupServiceExtensions.getInstance().locate(null, UnresolvedCorrelationImpl.class, (Object)(String.valueOf(this.context.getAgent().getRuntimeId()) + "/" + this.threadIdRef + "/" + this.ticket + "/" + this.sequenceCounter));
        if (unresolvedCorrelation != null) {
            Iterator iterator = unresolvedCorrelation.getSourceInfos().iterator();
            while (iterator.hasNext()) {
                CorrelationSourceInfo correlationSourceInfo = (CorrelationSourceInfo)iterator.next();
                EReference reference = correlationSourceInfo.getReference();
                EObject owner = correlationSourceInfo.getOwner();
                if (!(owner instanceof TRCMethodInvocation) || reference != TracePackage.eINSTANCE.getTRCMethodInvocation_InvokedBy() || sourceInvocation == null) continue;
                ((TRCMethodInvocation)owner).setInvokedBy(sourceInvocation);
                iterator.remove();
            }
            if (unresolvedCorrelation.getSourceInfos().size() == 0) {
                unresolvedCorrelation.setAgent(null);
            }
        }
    }

    protected void updateBaseTimeIfRequired(TRCMethodInvocation callee, TRCMethodInvocation caller) {
        if (callee instanceof TRCFullMethodInvocation && caller instanceof TRCFullMethodInvocation) {
            TRCFullMethodInvocation cr = (TRCFullMethodInvocation)caller;
            TRCFullMethodInvocation ce = (TRCFullMethodInvocation)callee;
            if (cr.eIsSet((EStructuralFeature)TracePackage.eINSTANCE.getTRCFullMethodInvocation_ExitTime()) && ce.eIsSet((EStructuralFeature)TracePackage.eINSTANCE.getTRCFullMethodInvocation_ExitTime())) {
                this.deltaBaseTime = -(ce.getExitTime() - ce.getEntryTime() - ce.getOverhead());
                this.deltaCumulativeTime = 0.0;
                this.invokerMethod = cr.getMethod();
                this.invokerObject = (TRCFullTraceObject)cr.getOwningObject();
                this.invokerClass = cr.getMethod().getDefiningClass();
                this.invokerObjectClass = this.getExtendedClass(this.invokerObject, this.invokerClass);
                this.updateBaseTime();
            }
        }
    }

    public void addCharacters(char[] data, int offset, int length) {
        String s;
        if (this.objectValue != null && (s = new String(data, offset, length)).trim().length() > 0) {
            this.objectValue.setStringValue(String.valueOf(this.objectValue.getStringValue()) + s);
        }
    }
}

