/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.trace;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.loaders.hierarchy.IgnoredXMLFragmentLoader;
import org.eclipse.hyades.loaders.trace.TRCObjectEntry;
import org.eclipse.hyades.loaders.trace.TraceUtils;
import org.eclipse.hyades.loaders.trace.VirtualObjectInfo;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCAnnotation;
import org.eclipse.hyades.models.trace.TRCArrayClass;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCFullHeapObject;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TRCHeapDump;
import org.eclipse.hyades.models.trace.TRCHeapObject;
import org.eclipse.hyades.models.trace.TRCLanguageElement;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCObjectValue;
import org.eclipse.hyades.models.trace.TRCPrimitiveType;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCThreadEvent;
import org.eclipse.hyades.models.trace.TraceFactory;
import org.eclipse.hyades.models.trace.impl.TRCArrayClassImpl;
import org.eclipse.hyades.models.trace.impl.TRCClassImpl;
import org.eclipse.hyades.models.trace.impl.TRCFullHeapObjectImpl;
import org.eclipse.hyades.models.trace.impl.TRCFullTraceObjectImpl;
import org.eclipse.hyades.models.trace.impl.TRCHeapObjectImpl;
import org.eclipse.hyades.models.trace.impl.TRCMethodImpl;
import org.eclipse.hyades.models.trace.impl.TRCMethodWithLLDataImpl;
import org.eclipse.hyades.models.trace.impl.TRCThreadImpl;

public class TraceXMLFragmentLoader
extends IgnoredXMLFragmentLoader {
    protected static final String NAME = "name";
    protected static final String VALUE = "value";
    protected static final String OBJ_ID_REF = "objIdRef";
    protected static final String METHOD_ID_REF = "methodIdRef";
    protected static final String CLASS_ID_REF = "classIdRef";
    protected static final String THREAD_ID_REF = "threadIdRef";
    protected static final String TIME = "time";
    protected static final String CLASS_CLASS1 = "java/lang/Class";
    protected static final String CLASS_CLASS2 = "java.lang.Class";
    protected static final String SOURCE_NAME = "sourceName";
    protected static final String PRECISION = "precision";
    protected static final String LANGUAGE = "language";
    protected static final String ANNOTATION = "annotation";
    protected static final String UNKNOWN = "unknown";
    protected TRCClass theClass;
    protected TRCHeapDump theHeapDump;
    protected TRCMethod theMethod;
    protected TRCObject theObject;
    protected TRCProcess theProcess;
    protected TRCThread theThread;
    protected VirtualObjectInfo virtualObject;
    protected boolean loadToModel;
    protected double time = 0.0;
    protected long classIdRef;
    protected int deltaSize = 0;
    protected int methodIdRef;
    protected int threadIdRef = 0;
    protected long precision;
    protected long objIdRef;
    protected String sourceName;
    protected String language;
    protected TRCClass aClass;
    protected TRCAnnotation currentAnnotation;
    protected StringBuffer currentAnnotationValueEntry = new StringBuffer();
    protected boolean currentAnnotationValueEntryActive;
    protected List annotations = new ArrayList();
    protected TRCObjectValue objectValue;
    protected boolean createVirtualObjects;
    protected boolean createClassObjects;

    public void addAttribute(String name, String value) {
        switch (LoadersUtils.getHashCode((String)name)) {
            case 3560141: {
                this.time = LoadersUtils.parseTraceTime((String)value);
                break;
            }
            case 1910215054: {
                this.threadIdRef = Integer.parseInt(value);
                break;
            }
            case -311104800: {
                this.classIdRef = Long.parseLong(value);
                break;
            }
            case -947782377: {
                this.methodIdRef = Integer.parseInt(value);
                break;
            }
            case 64634561: {
                this.objIdRef = Long.parseLong(value);
                break;
            }
            case -1111633594: {
                this.sourceName = value;
                break;
            }
            case -1376177026: {
                this.precision = Long.parseLong(value);
                break;
            }
            case -1613589672: {
                this.language = value;
                break;
            }
            case 111972721: {
                if (this.objectValue != null) {
                    this.objectValue.setStringValue(value);
                }
                if (this.currentAnnotation == null) break;
                this.currentAnnotation.getValues().add((Object)value);
                break;
            }
            case 3373707: {
                if (this.currentAnnotation == null) break;
                this.currentAnnotation.setName(value);
                break;
            }
        }
    }

    public void initialize(HierarchyContext context, String name) {
        super.initialize(context, name);
        this.threadIdRef = 0;
        this.classIdRef = 0L;
        this.methodIdRef = 0;
        this.objIdRef = 0L;
        this.time = 0.0;
        this.theProcess = null;
        this.theThread = null;
        this.theClass = null;
        this.theMethod = null;
        this.theObject = null;
        this.virtualObject = null;
    }

    protected TRCClass getClassByIdRef(TRCThread thread, Class theObjectClass, int isArray) {
        int h;
        String name;
        TRCClass targetClass = null;
        TRCObject anObject = null;
        if (isArray > 0) {
            this.theClass = (TRCClass)LookupServiceExtensions.getInstance().locate(this.context, TRCArrayClassImpl.class, -this.classIdRef);
            if (this.theClass != null) {
                return this.theClass;
            }
            targetClass = (TRCClass)LookupServiceExtensions.getInstance().locate(this.context, TRCClassImpl.class, this.classIdRef);
            if (targetClass == null) {
                targetClass = (TRCClass)LookupServiceExtensions.getInstance().locate(this.context, TRCArrayClassImpl.class, this.classIdRef);
            }
        } else {
            this.theClass = (TRCClass)LookupServiceExtensions.getInstance().locate(this.context, TRCClassImpl.class, this.classIdRef);
            if (this.theClass != null) {
                return this.theClass;
            }
        }
        if (isArray > 0) {
            this.theClass = TraceFactory.eINSTANCE.createTRCArrayClass();
            this.theClass.setId(-this.classIdRef);
            ((TRCArrayClass)this.theClass).setArrayType(TRCPrimitiveType.get(isArray));
        } else {
            this.theClass = TraceFactory.eINSTANCE.createTRCClass();
            this.theClass.setId(this.classIdRef);
        }
        if (targetClass != null) {
            TRCClass tc = TraceUtils.findClass(this.theProcess, String.valueOf(targetClass.getName()) + "[]", targetClass.getPackage().getName());
            if (tc != null) {
                this.theClass = tc;
                this.theClass.setId(-this.classIdRef);
            }
            this.theClass.setName(String.valueOf(targetClass.getName()) + "[]");
            this.theClass.setLoadTime(this.createDeltaTime());
            this.theClass.setLoadedBy(thread);
            this.theClass.setPackage(targetClass.getPackage());
            if (this.createClassObjects) {
                anObject = this.getClassObjectByIdRef(-this.classIdRef, theObjectClass);
                this.theClass.getClassObjects().add((Object)anObject);
                anObject.setSize(this.theClass.getSize());
                TraceUtils.addClassObjectToClassClass(this.context, this.theProcess, anObject);
            }
            return this.theClass;
        }
        String sourceName = name = UNKNOWN + this.classIdRef;
        this.theClass.setName(TraceUtils.className(name));
        this.theClass.setId(this.classIdRef);
        this.theClass.setLoadTime(this.createDeltaTime());
        TraceUtils.addClassToPackage(this.context, this.theClass, name, this.theProcess);
        TraceUtils.setSourceInfo(this.context, this.theProcess, this.theClass, sourceName, this.language);
        this.addLanguageIfRequired((List)this.theProcess.getLanguages());
        if (this.theProcess.getClassClass() == null && ((h = LoadersUtils.getHashCode((String)name)) == 1995981828 || h == -530663260)) {
            this.theProcess.setClassClass(this.theClass);
        }
        anObject = this.getClassObjectByIdRef(-this.classIdRef, theObjectClass);
        anObject.setSize(this.theClass.getSize());
        this.theClass.getClassObjects().add((Object)anObject);
        this.theClass.setLoadedBy(thread);
        TraceUtils.addClassObjectToClassClass(this.context, this.theProcess, anObject);
        return this.theClass;
    }

    protected TRCObject getClassObjectByIdRef(long id, Class theObjectClass) {
        this.aClass = this.theProcess.getClassClass();
        if (this.aClass == null) {
            TraceUtils.addClassObjectToClassClass(this.context, this.theProcess, null);
            this.aClass = this.theProcess.getClassClass();
        }
        return this.createObjectAndClassObject(id, theObjectClass);
    }

    protected TRCMethod getMethodByIdRef(TRCClass theClass) {
        Class clazz = TraceUtils.isBooleanOptionEnabled(this.context, "LLDATA_ENABLED") ? TRCMethodWithLLDataImpl.class : TRCMethodImpl.class;
        TRCMethod method = (TRCMethod)LookupServiceExtensions.getInstance().locate(this.context, clazz, this.methodIdRef);
        if (method == null) {
            method = this.createTRCMethod(theClass);
            method.setId(this.methodIdRef);
            method.setName(UNKNOWN + this.methodIdRef);
            method.setSignature("()");
            method.setDefiningClass(theClass);
        }
        return method;
    }

    protected TRCMethod createTRCMethod(TRCClass theClass2) {
        TRCMethod method = null;
        method = TraceUtils.isBooleanOptionEnabled(this.context, "LLDATA_ENABLED") ? TraceFactory.eINSTANCE.createTRCMethodWithLLData() : TraceFactory.eINSTANCE.createTRCMethod();
        return method;
    }

    protected TRCObject getObjectByIdRef(long id, Class theObjectClass) {
        this.aClass = this.theClass;
        if (this.aClass == null) {
            this.theProcess = this.getProcess();
            this.aClass = this.theProcess.getClassClass();
            if (this.aClass == null) {
                TraceUtils.addClassObjectToClassClass(this.context, this.theProcess, null);
                this.aClass = this.theProcess.getClassClass();
            }
        }
        return this.createObjectAndClassObject(id, theObjectClass);
    }

    protected TRCProcess getProcess() {
        TRCProcess p;
        if (this.context.getAgent() == null) {
            LoadersUtils.createAgent((HierarchyContext)this.context);
        }
        if ((p = TraceUtils.getProcess(this.context.getAgent())) == null) {
            p = TraceFactory.eINSTANCE.createTRCProcess();
            p.setId(this.context.getProcessProxy().getRuntimeId());
            p.setPid(this.context.getProcessProxy().getPid());
            p.setAgent(this.context.getAgent());
            p.setStartTime(this.createDeltaTime());
        }
        return p;
    }

    protected TRCThread getThreadByIdRef(TRCProcess p) {
        TRCThread thread = (TRCThread)LookupServiceExtensions.getInstance().locate(this.context, TRCThreadImpl.class, this.threadIdRef);
        if (thread == null) {
            thread = TraceFactory.eINSTANCE.createTRCThread();
            thread.setId(this.threadIdRef);
            thread.setName(UNKNOWN + this.threadIdRef);
            thread.setStartTime(this.createDeltaTime());
            thread.setProcess(p);
        }
        return thread;
    }

    protected double createDeltaTime() {
        double res = this.time - this.getZeroTime();
        if (this.getProcess() != null && this.getProcess().getLastEventTime() < res) {
            this.getProcess().setLastEventTime(res);
        }
        return res;
    }

    protected TRCObject createObject(long id, Class theObjectClass) {
        if (theObjectClass == TRCHeapObjectImpl.class) {
            return this.createTRCHeapObject(id);
        }
        if (theObjectClass == TRCFullHeapObjectImpl.class) {
            return this.createTRCFullHeapObject(id);
        }
        if (theObjectClass == TRCFullTraceObjectImpl.class) {
            return this.createTRCFullTraceObject(id);
        }
        return this.createTRCObject(id);
    }

    protected TRCObject createObject(long id, Class theObjectClass, TRCObjectEntry objectEntry) {
        if (theObjectClass == TRCHeapObjectImpl.class) {
            return this.createTRCHeapObject(id, objectEntry);
        }
        if (theObjectClass == TRCFullHeapObjectImpl.class) {
            return this.createTRCHeapObject(id, objectEntry);
        }
        if (theObjectClass == TRCFullTraceObjectImpl.class) {
            return this.createTRCFullTraceObject(id, objectEntry);
        }
        return this.createTRCObject(id);
    }

    protected TRCObject createTRCFullTraceObject(long oId) {
        TRCFullTraceObject object = TraceFactory.eINSTANCE.createTRCFullTraceObject();
        object.setId(oId);
        object.setCreateTime(this.createDeltaTime());
        object.setThread(this.theClass.getLoadedBy());
        object.setIsA(this.aClass);
        object.setProcess(this.getTRCObjectProcess());
        return object;
    }

    protected TRCObject createTRCFullTraceObject(long oId, TRCObjectEntry objectEntry) {
        TRCFullTraceObject object = TraceFactory.eINSTANCE.createTRCFullTraceObject();
        object.setId(oId);
        TRCHeapObject o = (TRCHeapObject)objectEntry.get(TRCHeapObjectImpl.class);
        if (o != null) {
            object.setIsA(o.getIsA());
        } else {
            object.setIsA(this.theClass);
        }
        object.setCreateTime(this.createDeltaTime());
        object.setThread(this.theClass.getLoadedBy());
        object.setProcess(this.getTRCObjectProcess());
        return object;
    }

    protected TRCObject createTRCHeapObject(long oId) {
        TRCHeapObject object = TraceFactory.eINSTANCE.createTRCHeapObject();
        object.setId(oId);
        object.setIsA(this.aClass);
        object.setProcess(this.getTRCObjectProcess());
        return object;
    }

    protected TRCObject createTRCFullHeapObject(long oId) {
        TRCFullHeapObject object = TraceFactory.eINSTANCE.createTRCFullHeapObject();
        object.setId(oId);
        object.setIsA(this.aClass);
        object.setProcess(this.getTRCObjectProcess());
        return object;
    }

    protected TRCObject createTRCHeapObject(long oId, TRCObjectEntry objectEntry) {
        TRCHeapObject object = TraceFactory.eINSTANCE.createTRCHeapObject();
        object.setId(oId);
        TRCFullTraceObject o = (TRCFullTraceObject)objectEntry.get(TRCFullTraceObjectImpl.class);
        if (o != null) {
            object.setIsA(o.getIsA());
        } else {
            object.setIsA(this.theClass);
        }
        object.setProcess(this.getTRCObjectProcess());
        return object;
    }

    protected TRCObject createTRCFullHeapObject(long oId, TRCObjectEntry objectEntry) {
        TRCFullHeapObject object = TraceFactory.eINSTANCE.createTRCFullHeapObject();
        object.setId(oId);
        TRCFullTraceObject o = (TRCFullTraceObject)objectEntry.get(TRCFullTraceObjectImpl.class);
        if (o != null) {
            object.setIsA(o.getIsA());
        } else {
            object.setIsA(this.theClass);
        }
        object.setProcess(this.getTRCObjectProcess());
        return object;
    }

    protected TRCObject createTRCObject(long oId) {
        TRCObject object = TraceFactory.eINSTANCE.createTRCObject();
        object.setId(oId);
        object.setIsA(this.aClass);
        object.setProcess(this.getTRCObjectProcess());
        return object;
    }

    protected void dispatchProcessMode(int step) {
        switch (this.context.getCollectionMode().getValue()) {
            case 0: {
                this.createVirtualObjects = true;
                this.createClassObjects = true;
                this.processHS(step);
                break;
            }
            case 1: {
                this.createVirtualObjects = false;
                this.createClassObjects = false;
                this.processHF(step);
                break;
            }
            case 2: {
                this.createVirtualObjects = false;
                this.createClassObjects = true;
                this.processHF_EF(step);
                break;
            }
            case 3: {
                this.createVirtualObjects = true;
                this.createClassObjects = true;
                this.processHS_ES(step);
                break;
            }
            case 5: {
                this.createVirtualObjects = false;
                this.createClassObjects = false;
                this.processENI(step);
                break;
            }
            case 6: {
                this.createVirtualObjects = false;
                this.createClassObjects = true;
                this.processEF(step);
                break;
            }
            case 7: {
                this.createVirtualObjects = true;
                this.createClassObjects = false;
                this.processHF_ES(step);
                break;
            }
            case 4: {
                this.createVirtualObjects = true;
                this.createClassObjects = false;
                this.processES(step);
                break;
            }
            case 8: {
                this.createVirtualObjects = true;
                this.createClassObjects = true;
                this.processHS_ENI(step);
                break;
            }
            default: {
                this.dynamicProcess(this, step);
            }
        }
    }

    protected void processHS_ENI(int step) {
        this.processHS(step);
        this.processENI(step);
    }

    protected void dynamicProcess(TraceXMLFragmentLoader loader, int step) {
    }

    protected void processEF(int step) {
    }

    protected void processENI(int step) {
        this.processEF(step);
    }

    protected void processES(int step) {
    }

    protected void processHF(int step) {
    }

    protected void processHF_EF(int step) {
        this.processHF(step);
        this.processEF(step);
    }

    protected void processHF_ES(int step) {
        this.processHF(step);
        this.processES(step);
    }

    protected void processHS(int step) {
    }

    protected void processHS_ES(int step) {
        this.processHS(step);
        this.processES(step);
    }

    protected void updateVirtualObject(long oId, int size) {
        this.virtualObject = (VirtualObjectInfo)LookupServiceExtensions.getInstance().locate(this.context, VirtualObjectInfo.class, oId);
        if (this.virtualObject == null) {
            this.virtualObject = new VirtualObjectInfo();
            LoadersUtils.registerGenericLookUpEntry((HierarchyContext)this.context, (Object)LoadersUtils.getLookUpKey((long)oId), (Object)this.virtualObject);
        }
        this.virtualObject.myClass = this.theClass;
        this.virtualObject.myThread = this.theThread;
        this.virtualObject.createTime = this.createDeltaTime();
        this.virtualObject.size = size;
    }

    protected TRCProcess getTRCObjectProcess() {
        return this.getProcess();
    }

    protected double getZeroTime() {
        return this.getProcess().getAgent().getStartTime();
    }

    protected TRCObject createObjectAndClassObject(long id, Class theObjectClass) {
        TRCObjectEntry objectEntry = (TRCObjectEntry)LookupServiceExtensions.getInstance().locate(this.context, TRCObjectEntry.class, id);
        TRCObject object = null;
        if (objectEntry != null) {
            object = objectEntry.get(theObjectClass);
            if (object == null) {
                object = this.createObject(id, theObjectClass, objectEntry);
                objectEntry.put(object.getClass(), object);
            }
        } else {
            object = this.createObject(id, theObjectClass);
        }
        return object;
    }

    protected TRCObject getClassObject(TRCClass class1, Class class2) {
        for (TRCObject element : class1.getClassObjects()) {
            if (element.getClass() != class2) continue;
            return element;
        }
        TRCObject aObject = this.getClassObjectByIdRef(-this.classIdRef, class2);
        aObject.setSize(class1.getSize());
        this.theClass.getClassObjects().add((Object)aObject);
        TraceUtils.addClassObjectToClassClass(this.context, this.theProcess, aObject);
        return aObject;
    }

    protected boolean addLanguageIfRequired(List languages) {
        return TraceUtils.addLanguageIfRequired(this.language, languages);
    }

    protected boolean addAnnotationsIfRequired(TRCLanguageElement target) {
        if (this.annotations != null && this.annotations.size() > 0) {
            target.getAnnotations().addAll((Collection)this.annotations);
            return true;
        }
        return false;
    }

    protected boolean addAnnotationsIfRequired(TRCThreadEvent target) {
        if (this.annotations != null && this.annotations.size() > 0) {
            target.getAnnotations().addAll((Collection)this.annotations);
            return true;
        }
        return false;
    }

    protected boolean addCopyOfAnnotationsIfRequired(TRCThreadEvent target) {
        if (this.annotations != null && this.annotations.size() > 0) {
            target.getAnnotations().addAll(EcoreUtil.copyAll((Collection)this.annotations));
            return true;
        }
        return false;
    }

    protected boolean addAnnotationsIfRequired(TRCThread target) {
        if (this.annotations != null && this.annotations.size() > 0) {
            target.getAnnotations().addAll((Collection)this.annotations);
            return true;
        }
        return false;
    }

    protected boolean addAnnotationsIfRequired(TRCProcess target) {
        if (this.annotations != null && this.annotations.size() > 0) {
            target.getAnnotations().addAll((Collection)this.annotations);
            return true;
        }
        return false;
    }

    public void endChild(String name) {
        switch (LoadersUtils.getHashCode((String)name)) {
            case -1555043537: {
                this.annotations.add(this.currentAnnotation);
                this.currentAnnotation = null;
                break;
            }
            case 111972721: {
                if (!this.currentAnnotationValueEntryActive || this.currentAnnotationValueEntry.length() <= 0) break;
                this.currentAnnotation.getValues().add((Object)this.currentAnnotationValueEntry.toString().trim());
                this.currentAnnotationValueEntry.setLength(0);
                this.currentAnnotationValueEntryActive = false;
                break;
            }
        }
    }

    public void startChild(String name) {
        switch (LoadersUtils.getHashCode((String)name)) {
            case -1555043537: {
                this.currentAnnotation = HierarchyFactory.eINSTANCE.createTRCAnnotation();
                break;
            }
            case 111972721: {
                if (this.currentAnnotation == null) break;
                this.currentAnnotationValueEntry.setLength(0);
                this.currentAnnotationValueEntryActive = true;
                break;
            }
        }
    }

    public void addCharacters(char[] data, int offset, int length) {
        if (this.currentAnnotationValueEntryActive) {
            this.currentAnnotationValueEntry.append(data, offset, length);
        }
    }
}

