/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.trace;

import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Stack;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.loaders.trace.CallStackPerThread;
import org.eclipse.hyades.loaders.trace.TraceMethodBaseLoader;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.models.trace.TRCAggregatedMethodInvocation;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TraceFactory;
import org.eclipse.hyades.models.trace.TracePackage;
import org.eclipse.hyades.models.util.ModelDebugger;

public class XMLagMethodEntryLoader
extends TraceMethodBaseLoader {
    protected double baseTime;
    protected double minTime;
    protected double maxTime;
    protected int numCalls;
    protected static final String AG_BASE_TIME = "baseTime";
    protected static final String NUM_CALLS = "numcalls";
    protected double cpuTime;
    protected IdentityHashMap visitedNodes;

    public void addAttribute(String name, String value) {
        switch (LoadersUtils.getHashCode((String)name)) {
            case -1721500354: 
            case -1720547042: {
                this.baseTime = Double.parseDouble(value);
                break;
            }
            case 1063908415: {
                this.minTime = Double.parseDouble(value);
                break;
            }
            case 844110417: {
                this.maxTime = Double.parseDouble(value);
                break;
            }
            case -1885640177: 
            case 94851343: {
                this.numCalls = Integer.parseInt(value);
                break;
            }
            case 985674901: {
                this.cpuTime = LoadersUtils.parseTraceTime((String)value);
                break;
            }
            default: {
                super.addAttribute(name, value);
            }
        }
    }

    protected void processEF(int step) {
        double deltaBaseTime;
        int deltaNumCalls;
        int i;
        EList<TRCMethodInvocation> l;
        if (ModelDebugger.INSTANCE.debug) {
            System.out.println("push");
        }
        this.cs = (CallStackPerThread)LookupServiceExtensions.getInstance().locate(this.context, CallStackPerThread.class, this.threadIdRef);
        if (this.cs == null) {
            Object csKey = LoadersUtils.getLookUpKey((int)this.threadIdRef);
            this.cs = new CallStackPerThread();
            LoadersUtils.registerGenericLookUpEntry((HierarchyContext)this.context, (Object)csKey, (Object)this.cs);
        }
        TRCAggregatedMethodInvocation tos = null;
        TRCAggregatedMethodInvocation invocation = null;
        if (this.cs.size() > 0) {
            tos = (TRCAggregatedMethodInvocation)this.cs.peek();
            l = tos.getInvokes();
            i = l.size();
            while (--i >= 0) {
                TRCAggregatedMethodInvocation aggIn;
                Object in = l.get(i);
                if (!(in instanceof TRCAggregatedMethodInvocation) || (aggIn = (TRCAggregatedMethodInvocation)in).getMethod() != this.theMethod) continue;
                if (ModelDebugger.INSTANCE.debug) {
                    System.out.println("re-use existing agMI for this frame");
                }
                invocation = aggIn;
                break;
            }
        } else {
            l = this.theMethod.getInvocations();
            i = l.size();
            while (--i >= 0) {
                TRCAggregatedMethodInvocation aggIn;
                Object in = l.get(i);
                if (!(in instanceof TRCAggregatedMethodInvocation) || (aggIn = (TRCAggregatedMethodInvocation)in).getThread() != this.theThread || aggIn.getInvokedBy() != null) continue;
                if (ModelDebugger.INSTANCE.debug) {
                    System.out.println("re-use existing agMI for this frame");
                }
                invocation = aggIn;
                break;
            }
        }
        if (invocation == null) {
            invocation = TraceFactory.eINSTANCE.createTRCAggregatedMethodInvocation();
            invocation.setMethod(this.theMethod);
            invocation.setProcess(this.theProcess);
            invocation.setThread(this.theThread);
            if (tos == null) {
                this.theThread.getInitialInvocations().add((Object)invocation);
            } else {
                invocation.setInvokedBy(tos);
            }
        }
        this.cs.push(invocation);
        if (this.theProcess.getAgent().getName().equals("org.eclipse.tptp.jvmti")) {
            deltaNumCalls = this.numCalls;
            deltaBaseTime = this.baseTime;
            invocation.setCount(invocation.getCount() + this.numCalls);
            invocation.setBaseTime(invocation.getBaseTime() + this.baseTime);
        } else {
            deltaBaseTime = this.baseTime - invocation.getBaseTime();
            deltaNumCalls = this.numCalls - invocation.getCount();
            invocation.setCount(this.numCalls);
            invocation.setBaseTime(this.baseTime);
        }
        if (invocation.getMinTime() == 0.0 || invocation.getMinTime() > this.minTime) {
            invocation.setMinTime(this.minTime);
        }
        if (invocation.getMaxTime() < this.maxTime) {
            invocation.setMaxTime(this.maxTime);
        }
        if (this.numCalls == 0 || deltaNumCalls == 0 && deltaBaseTime == 0.0) {
            return;
        }
        this.updateMethodStatisticalInfo(this.cs, deltaBaseTime, deltaNumCalls);
    }

    protected void processENI(int step) {
        super.processENI(step);
    }

    protected void processES(int step) {
        this.processEF(step);
    }

    public void addYourselfInContext() {
        if (!this.loadToModel) {
            return;
        }
        if (this.context.isFilterOn() && this.context.getFilterEngine().isFiltered((EStructuralFeature)TracePackage.eINSTANCE.getTRCMethod_Name(), LoadersUtils.getLookUpKey((int)this.methodIdRef))) {
            return;
        }
        this.theProcess = this.getProcess();
        this.theThread = this.getThreadByIdRef(this.theProcess);
        this.theMethod = this.getMethodByIdRef(null);
        this.dispatchProcessMode(0);
    }

    public void cleanUp() {
        if (ModelDebugger.INSTANCE.debug) {
            System.out.println("Cleaning up aggrmethodcallload");
            this.dump(new CallBack(){

                public void call(TRCAggregatedMethodInvocation o, int level) {
                    int i = 0;
                    while (i < level) {
                        System.out.print("  ");
                        ++i;
                    }
                    System.out.println(o.getMethod().getId());
                }
            }, this.theProcess.getThreads().iterator(), 0);
        }
        if (this.cs != null) {
            this.cs.clear();
            LookupServiceExtensions.getInstance().deregister(this.context, CallStackPerThread.class, this.threadIdRef);
        }
    }

    protected void dump(CallBack cb, Iterator it, int level) {
        while (it.hasNext()) {
            Object o = it.next();
            if (o instanceof TRCThread) {
                TRCThread t = (TRCThread)o;
                this.dump(cb, t.getInitialInvocations().iterator(), level + 1);
                continue;
            }
            if (!(o instanceof TRCAggregatedMethodInvocation)) continue;
            TRCAggregatedMethodInvocation in = (TRCAggregatedMethodInvocation)o;
            cb.call((TRCAggregatedMethodInvocation)o, level);
            this.dump(cb, in.getInvokes().iterator(), level + 1);
        }
    }

    protected void updateMethodStatisticalInfo(Stack cs, double deltaBaseTime, int deltaNumCalls) {
        if (this.theMethod != null) {
            TRCClass theClass;
            this.theMethod.setBaseTime(this.theMethod.getBaseTime() + deltaBaseTime);
            this.theMethod.setCalls(this.theMethod.getCalls() + deltaNumCalls);
            if (this.cpuTime != 0.0) {
                this.theMethod.setTotalCpuTime(this.cpuTime);
            }
            if ((theClass = this.theMethod.getDefiningClass()) != null) {
                TRCPackage thePackage;
                theClass.setBaseTime(theClass.getBaseTime() + deltaBaseTime);
                theClass.setCalls(theClass.getCalls() + deltaNumCalls);
                if (this.cpuTime != 0.0) {
                    theClass.setTotalCpuTime(theClass.getTotalCpuTime() + this.cpuTime);
                }
                if ((thePackage = theClass.getPackage()) != null) {
                    thePackage.setBaseTime(thePackage.getBaseTime() + deltaBaseTime);
                    thePackage.setCalls(thePackage.getCalls() + deltaNumCalls);
                    if (this.cpuTime != 0.0) {
                        thePackage.setTotalCpuTime(thePackage.getTotalCpuTime() + this.cpuTime);
                    }
                }
            }
        }
        if (this.theProcess != null) {
            this.theProcess.setBaseTime(this.theProcess.getBaseTime() + deltaBaseTime);
            this.theProcess.setCalls(this.theProcess.getCalls() + deltaNumCalls);
            if (this.cpuTime != 0.0) {
                this.theProcess.setTotalCpuTime(this.theProcess.getTotalCpuTime() + this.cpuTime);
            }
        }
        if (this.visitedNodes == null) {
            this.visitedNodes = new IdentityHashMap();
        } else {
            this.visitedNodes.clear();
        }
        int i = cs.size();
        while (--i >= 0) {
            TRCProcess theProcess;
            TRCPackage thePackage;
            TRCClass theClass;
            TRCAggregatedMethodInvocation frame = (TRCAggregatedMethodInvocation)cs.get(i);
            TRCMethod theMethod = frame.getMethod();
            if (this.visitedNodes.containsKey(theMethod)) continue;
            this.visitedNodes.put(theMethod, null);
            theMethod.setCumulativeTime(theMethod.getCumulativeTime() + deltaBaseTime);
            if (this.cpuTime != 0.0) {
                theMethod.setTotalCpuTime(theMethod.getTotalCpuTime() + this.cpuTime);
            }
            if ((theClass = theMethod.getDefiningClass()) == null || this.visitedNodes.containsKey(theClass)) continue;
            this.visitedNodes.put(theClass, null);
            theClass.setCumulativeTime(theClass.getCumulativeTime() + deltaBaseTime);
            if (this.cpuTime != 0.0) {
                theClass.setTotalCpuTime(theClass.getTotalCpuTime() + this.cpuTime);
            }
            if ((thePackage = theClass.getPackage()) == null || this.visitedNodes.containsKey(thePackage)) continue;
            this.visitedNodes.put(thePackage, null);
            thePackage.setCumulativeTime(thePackage.getCumulativeTime() + deltaBaseTime);
            if (this.cpuTime != 0.0) {
                thePackage.setTotalCpuTime(thePackage.getTotalCpuTime() + this.cpuTime);
            }
            if ((theProcess = thePackage.getProcess()) == null || this.visitedNodes.containsKey(theProcess)) continue;
            this.visitedNodes.put(theProcess, null);
            theProcess.setCumulativeTime(theProcess.getCumulativeTime() + deltaBaseTime);
            if (this.cpuTime == 0.0) continue;
            theProcess.setTotalCpuTime(theProcess.getTotalCpuTime() + this.cpuTime);
        }
        this.visitedNodes.clear();
    }

    public void initialize(HierarchyContext context, String name) {
        this.loadToModel = context.isLoadToModel();
        super.initialize(context, name);
        this.maxTime = 0.0;
        this.minTime = 0.0;
        this.numCalls = 0;
        this.baseTime = 0.0;
        this.cpuTime = 0.0;
    }

    public static interface CallBack {
        public void call(TRCAggregatedMethodInvocation var1, int var2);
    }
}

