/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.trace;

import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.loaders.trace.TraceUtils;
import org.eclipse.hyades.loaders.trace.TraceXMLFragmentLoader;
import org.eclipse.hyades.loaders.trace.VirtualObjectInfo;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.models.trace.TRCArrayClass;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TraceFactory;
import org.eclipse.hyades.models.trace.TracePackage;
import org.eclipse.hyades.models.trace.impl.TRCClassImpl;
import org.eclipse.hyades.models.trace.impl.TRCFullHeapObjectImpl;
import org.eclipse.hyades.models.trace.impl.TRCFullTraceObjectImpl;
import org.eclipse.hyades.models.trace.impl.TRCHeapObjectImpl;

public class XMLclassDefLoader
extends TraceXMLFragmentLoader {
    protected static final String NUM_STATIC_FIELDS = "numStaticFields";
    protected static final String NUM_METHODS = "numMethods";
    protected static final String NUM_INTERFACES = "numInterfaces";
    protected static final String NUM_INSTANCES_FIELDS = "numInstanceFields";
    protected static final String ACCESS = "access";
    protected static final String CLASS_ID = "classId";
    protected static final String IS_CLASS_CLASS = "isClassClass";
    protected String access;
    protected String name;
    protected long classId;
    protected int numInstanceFields;
    protected int numInterfaces;
    protected int numMethods;
    protected int numStaticFields;
    protected boolean java_lang_class;
    protected boolean isClassClass;

    public void addAttribute(String name, String value) {
        switch (LoadersUtils.getHashCode((String)name)) {
            case 853619891: {
                this.classId = Long.parseLong(value);
                break;
            }
            case 3373707: {
                if (this.currentAnnotation != null) {
                    this.currentAnnotation.setName(value);
                    break;
                }
                this.name = value;
                break;
            }
            case -1423461020: {
                this.access = value;
                break;
            }
            case -1583525676: {
                this.numInstanceFields = Integer.parseInt(value);
                break;
            }
            case 2103939712: {
                this.numInterfaces = Integer.parseInt(value);
                break;
            }
            case -1847438004: {
                this.numMethods = Integer.parseInt(value);
                break;
            }
            case -1488120467: {
                this.numStaticFields = Integer.parseInt(value);
                break;
            }
            default: {
                super.addAttribute(name, value);
            }
        }
    }

    public void addYourselfInContext() {
        if (this.sourceName == null) {
            this.sourceName = "unknown";
        }
        if (this.name == null || this.name.length() == 0) {
            this.name = "unknown";
        }
        if (this.context.isFilterOn()) {
            if (this.context.getFilterEngine().isFiltered((EStructuralFeature)TracePackage.eINSTANCE.getTRCThread_Name(), LoadersUtils.getLookUpKey((int)this.threadIdRef))) {
                return;
            }
            if (this.context.getFilterEngine().isFiltered((EStructuralFeature)TracePackage.eINSTANCE.getTRCPackage_Name(), LoadersUtils.getLookUpKey((String)TraceUtils.packageName(this.name)), (Object)TraceUtils.packageName(this.name))) {
                this.context.getFilterEngine().addExcludedId((EStructuralFeature)TracePackage.eINSTANCE.getTRCClass_Name(), LoadersUtils.getLookUpKey((long)this.classId));
                return;
            }
            if (this.context.getFilterEngine().isFiltered((EStructuralFeature)TracePackage.eINSTANCE.getTRCClass_Name(), LoadersUtils.getLookUpKey((long)this.classId), (Object)TraceUtils.className(this.name))) {
                return;
            }
        }
        this.createTRCType();
    }

    public void initialize(HierarchyContext context, String name) {
        super.initialize(context, name);
        this.classId = 0L;
        this.sourceName = null;
        name = null;
        this.access = null;
        this.numStaticFields = 0;
        this.numMethods = 0;
        this.numInstanceFields = 0;
        this.language = null;
        this.annotations.clear();
        this.currentAnnotationValueEntryActive = false;
        this.isClassClass = false;
    }

    protected void processEF(int step) {
        super.processEF(step);
        this.processES(step);
    }

    protected void processES(int step) {
        super.processES(step);
        switch (step) {
            case 4: {
                if (!this.createClassObjects) break;
                this.theObject = this.objIdRef != 0L ? this.getClassObjectByIdRef(this.objIdRef, TRCFullTraceObjectImpl.class) : this.getClassObjectByIdRef(-this.classId, TRCFullTraceObjectImpl.class);
                if (this.theObject == null) {
                    this.theObject = TraceFactory.eINSTANCE.createTRCFullTraceObject();
                    if (this.objIdRef == 0L) {
                        this.theObject.setId(-this.classId);
                    } else {
                        this.theObject.setId(this.objIdRef);
                        this.updateTRCFullTraceObjectFromVOI(this.objIdRef);
                    }
                    this.theObject.setProcess(this.theProcess);
                }
                if (!this.theObject.eIsSet((EStructuralFeature)TracePackage.eINSTANCE.getTRCObject_Size())) {
                    this.theObject.setSize(this.theClass.getSize());
                }
                this.theClass.getClassObjects().add((Object)this.theObject);
                TraceUtils.addClassObjectToClassClass(this.context, this.theProcess, this.theObject);
                break;
            }
        }
    }

    protected void processHF(int step) {
        super.processHF(step);
        this.processHS(step);
    }

    protected void processHS(int step) {
        super.processHS(step);
        switch (step) {
            case 4: {
                this.theObject = null;
                Class clazz = TraceUtils.isBooleanOptionEnabled(this.context, "MULTIPLE_HEAP_DUMPS") ? TRCFullHeapObjectImpl.class : TRCHeapObjectImpl.class;
                this.theObject = this.objIdRef != 0L ? this.getClassObjectByIdRef(this.objIdRef, clazz) : this.getClassObjectByIdRef(-this.classId, clazz);
                if (this.theObject == null) {
                    this.theObject = TraceUtils.isBooleanOptionEnabled(this.context, "MULTIPLE_HEAP_DUMPS") ? TraceFactory.eINSTANCE.createTRCFullHeapObject() : TraceFactory.eINSTANCE.createTRCHeapObject();
                    if (this.objIdRef == 0L) {
                        this.theObject.setId(-this.classId);
                    } else {
                        this.theObject.setId(this.objIdRef);
                    }
                    this.theObject.setProcess(this.theProcess);
                }
                this.theClass.getClassObjects().add((Object)this.theObject);
                TraceUtils.addClassObjectToClassClass(this.context, this.theProcess, this.theObject);
                break;
            }
        }
    }

    protected void updateTRCFullTraceObjectFromVOI(long oId) {
        VirtualObjectInfo objectInfo = (VirtualObjectInfo)LookupServiceExtensions.getInstance().locate(this.context, VirtualObjectInfo.class, oId);
        if (objectInfo != null) {
            TRCFullTraceObject object = (TRCFullTraceObject)this.theObject;
            object.setCreateTime(objectInfo.createTime);
            object.setSize(objectInfo.size);
            TraceUtils.removeVirtualObject(this.context, this.objIdRef);
        }
    }

    private void createTRCType() {
        this.theProcess = this.getProcess();
        this.java_lang_class = false;
        int hash = LoadersUtils.getHashCode((String)this.name);
        if (this.isClassClass || (this.theProcess.getLanguages().isEmpty() || this.theProcess.getLanguages().indexOf((Object)"Java") != -1) && hash == 1995981828 || hash == -530663260) {
            this.theClass = this.theProcess.getClassClass();
            if (this.theClass != null) {
                if (this.theClass.getId() != this.classId) {
                    LookupServiceExtensions.getInstance().deregister(this.context, TRCClassImpl.class, this.theClass.getId());
                    this.theClass.setId(this.classId);
                    LookupServiceExtensions.getInstance().register(this.context, (Object)this.theClass);
                }
            } else {
                this.theClass = (TRCClass)LookupServiceExtensions.getInstance().locate(this.context, TRCClassImpl.class, this.classId);
                this.java_lang_class = true;
            }
        } else {
            this.theClass = (TRCClass)LookupServiceExtensions.getInstance().locate(this.context, TRCClassImpl.class, this.classId);
        }
        String className = TraceUtils.className(this.name);
        if (this.theClass == null) {
            String packageName = TraceUtils.packageName(this.name);
            this.theClass = TraceUtils.findClass(this.theProcess, className, packageName);
            if (this.theClass == null) {
                if (this.name.charAt(0) == '[') {
                    this.theClass = TraceFactory.eINSTANCE.createTRCArrayClass();
                    TRCClass elementClass = TraceUtils.findClass(this.theProcess, className.substring(0, className.lastIndexOf("[]")), packageName);
                    if (elementClass != null) {
                        ((TRCArrayClass)this.theClass).setElementType(elementClass);
                    }
                } else {
                    this.theClass = TraceFactory.eINSTANCE.createTRCClass();
                }
            }
        }
        this.theClass.setName(className);
        this.theClass.setId(this.classId);
        this.theClass.setLoadTime(this.createDeltaTime());
        if (this.theClass.getPackage() != null) {
            this.theClass.setPackage(null);
        }
        TraceUtils.addClassToPackage(this.context, this.theClass, this.name, this.theProcess);
        TraceUtils.setSourceInfo(this.context, this.theProcess, this.theClass, this.sourceName, this.language);
        this.addLanguageIfRequired((List)this.theProcess.getLanguages());
        this.addAnnotationsIfRequired(this.theClass);
        if (this.theProcess.getClassClass() == null && this.java_lang_class) {
            this.theProcess.setClassClass(this.theClass);
        }
        this.theThread = this.getThreadByIdRef(this.theProcess);
        this.dispatchProcessMode(4);
        this.theClass.setLoadedBy(this.theThread);
    }
}

