/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.trace;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.loaders.trace.TraceUtils;
import org.eclipse.hyades.loaders.trace.TraceXMLFragmentLoader;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.models.trace.TRCGCRootType;
import org.eclipse.hyades.models.trace.TRCHeapDump;
import org.eclipse.hyades.models.trace.TRCHeapObject;
import org.eclipse.hyades.models.trace.TRCHeapRoot;
import org.eclipse.hyades.models.trace.TraceFactory;
import org.eclipse.hyades.models.trace.TracePackage;
import org.eclipse.hyades.models.trace.impl.TRCFullHeapObjectImpl;
import org.eclipse.hyades.models.trace.impl.TRCHeapDumpImpl;
import org.eclipse.hyades.models.trace.impl.TRCHeapObjectImpl;

public class XMLgcRootLoader
extends TraceXMLFragmentLoader {
    protected static final String TYPE = "type";
    protected static final String HEAP_DUMP_ID_REF = "heapDumpIdRef";
    protected TRCGCRootType fType;
    protected short fHeapDumpId;
    private TRCHeapDump heapDump;

    public void addAttribute(String name, String value) {
        switch (LoadersUtils.getHashCode((String)name)) {
            case 3575610: {
                this.fType = TRCGCRootType.get(value);
                break;
            }
            case 1586135896: {
                this.fHeapDumpId = Short.parseShort(value);
                break;
            }
            default: {
                super.addAttribute(name, value);
            }
        }
    }

    public void addYourselfInContext() {
        if (this.loadToModel && this.objIdRef >= 0L) {
            this.theProcess = this.getProcess();
            if (this.theProcess.getHeapDumps().size() > 0) {
                if (this.fHeapDumpId != -1) {
                    this.heapDump = (TRCHeapDump)LookupServiceExtensions.getInstance().locate(this.context, TRCHeapDumpImpl.class, (int)this.fHeapDumpId);
                }
                if (this.heapDump == null) {
                    this.heapDump = (TRCHeapDump)this.theProcess.getHeapDumps().get(this.theProcess.getHeapDumps().size() - 1);
                }
                this.dispatchProcessMode(0);
            }
        }
    }

    public void initialize(HierarchyContext context, String name) {
        this.loadToModel = context.isLoadToModel();
        super.initialize(context, name);
        this.fType = TRCGCRootType.UNKNOWN_LITERAL;
        this.fHeapDumpId = (short)-1;
        this.heapDump = null;
    }

    protected void processHF(int step) {
        super.processHF(step);
        Class clazz = TraceUtils.isBooleanOptionEnabled(this.context, "MULTIPLE_HEAP_DUMPS") ? TRCFullHeapObjectImpl.class : TRCHeapObjectImpl.class;
        this.theObject = (TRCHeapObject)LookupServiceExtensions.getInstance().locate(this.context, clazz, this.objIdRef);
        if (this.theObject == null) {
            return;
        }
        if (this.context.isFilterOn()) {
            if (this.context.getFilterEngine().isFiltered((EStructuralFeature)TracePackage.eINSTANCE.getTRCThread_Name(), LoadersUtils.getLookUpKey((int)this.threadIdRef))) {
                return;
            }
            if (this.context.getFilterEngine().isFiltered((EStructuralFeature)TracePackage.eINSTANCE.getTRCClass_Name(), LoadersUtils.getLookUpKey((long)this.theObject.getIsA().getId()))) {
                return;
            }
        }
        TRCHeapRoot heapRoot = TraceFactory.eINSTANCE.createTRCHeapRoot();
        heapRoot.setType(this.fType);
        heapRoot.setHeapDump(this.heapDump);
        heapRoot.setObject(this.theObject);
        if (this.threadIdRef != 0) {
            heapRoot.setThread(this.getThreadByIdRef(this.getProcess()));
        }
    }
}

